/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.SessionImpl;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Utils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ConnectionMonitor {
    private Map<String, Set<SessionImpl>> observedSessions = new HashMap<String, Set<SessionImpl>>();
    private Map<String, Timer> monitorTimers = new HashMap<String, Timer>();
    private Map<String, Connection> daemonConnections = new HashMap<String, Connection>();
    private static final int MONITOR_CONN_SOCKET_TIMEOUT = 60;
    private static final int TIMER_DELAY = 2;
    private static final int SCHEDULE_PERIOD = 20;

    private boolean checkValid(Statement statement) {
        boolean isValid = false;
        try {
            ResultSet resultSet = statement.executeQuery("select 1 from dual");
            if (resultSet.next()) {
                isValid = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return isValid;
    }

    private Timer createMonitorTimer(final String link) throws SQLException {
        final Statement statement = this.daemonConnections.get(link).createStatement();
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){
            private final String taskLink;
            private final Statement taskStmt;
            {
                this.taskLink = link;
                this.taskStmt = statement;
            }

            @Override
            public void run() {
                if (ConnectionMonitor.this.checkValid(this.taskStmt)) {
                    ConnectionMonitor.this.notifyHeartBeat(this.taskLink);
                    return;
                }
                ConnectionMonitor.this.notifyDisconnect(this.taskLink);
                try {
                    this.taskStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }, Utils.toMillisecond(2), (long)Utils.toMillisecond(20));
        return timer;
    }

    public synchronized void register(SessionImpl session) throws SQLException {
        String link = session.getHostSpec().getHost() + session.getHostSpec().getPort();
        if (!this.observedSessions.containsKey(link)) {
            this.observedSessions.put(link, new HashSet());
        }
        this.observedSessions.get(link).add(session);
        if (!this.daemonConnections.containsKey(link)) {
            try {
                Connection daemonConnection = (Connection)((ConnectionImpl)session.getConnection()).cloneForMonitor();
                daemonConnection.setNetworkTimeout(null, Utils.toMillisecond(60));
                this.daemonConnections.put(link, daemonConnection);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(e.getMessage(), YasState.DATA_ERROR);
            }
        }
        if (!this.monitorTimers.containsKey(link)) {
            Timer timer = this.createMonitorTimer(link);
            this.monitorTimers.put(link, timer);
        }
    }

    private void releaseMonitorResource(String link) {
        if (this.monitorTimers.containsKey(link)) {
            this.monitorTimers.get(link).cancel();
            this.monitorTimers.remove(link);
        }
        if (this.daemonConnections.containsKey(link)) {
            Connection connection = this.daemonConnections.get(link);
            this.daemonConnections.remove(link);
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public synchronized void unRegister(SessionImpl session) {
        String link = session.getHostSpec().getHost() + session.getHostSpec().getPort();
        if (!this.observedSessions.containsKey(link)) {
            return;
        }
        Set<SessionImpl> sessions = this.observedSessions.get(link);
        sessions.remove(session);
        if (!sessions.isEmpty()) {
            return;
        }
        this.releaseMonitorResource(link);
    }

    private synchronized void notifyHeartBeat(String link) {
        Set<SessionImpl> sessions = this.observedSessions.get(link);
        if (sessions.isEmpty()) {
            return;
        }
        for (SessionImpl session : sessions) {
            session.processHeartBeat();
        }
    }

    private synchronized void notifyDisconnect(String link) {
        Set<SessionImpl> sessions = this.observedSessions.get(link);
        if (sessions.isEmpty()) {
            return;
        }
        Iterator<SessionImpl> iterator = sessions.iterator();
        while (iterator.hasNext()) {
            SessionImpl session = iterator.next();
            if (!session.processInvalid()) continue;
            iterator.remove();
        }
        if (!sessions.isEmpty()) {
            this.reconstructHeartbeatDetection(link);
            return;
        }
        this.observedSessions.remove(link);
        this.releaseMonitorResource(link);
    }

    private void reconstructHeartbeatDetection(String link) {
        Set<SessionImpl> sessions = this.observedSessions.get(link);
        if (sessions.isEmpty()) {
            return;
        }
        this.daemonConnections.remove(link);
        if (this.monitorTimers.containsKey(link)) {
            this.monitorTimers.get(link).cancel();
            this.monitorTimers.remove(link);
        }
        Iterator<SessionImpl> iterator = sessions.iterator();
        boolean isReconnect = false;
        boolean isFirst = true;
        while (iterator.hasNext()) {
            SessionImpl session = iterator.next();
            if (isFirst) {
                isFirst = false;
                try {
                    Connection daemonConnection = (Connection)((ConnectionImpl)session.getConnection()).cloneForMonitor();
                    daemonConnection.setNetworkTimeout(null, Utils.toMillisecond(60));
                    this.daemonConnections.put(link, daemonConnection);
                    isReconnect = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            session.processHeartBeat();
            if (isReconnect) continue;
            session.processInvalid();
        }
        if (isReconnect) {
            Timer timer = null;
            try {
                timer = this.createMonitorTimer(link);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (timer != null) {
                this.monitorTimers.put(link, timer);
                return;
            }
        }
        sessions.clear();
        this.observedSessions.remove(link);
        this.releaseMonitorResource(link);
    }
}

