/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.conf.HostSpec;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DownHostsCache {
    static DownHostsCache downHostsCache;
    int refreshCacheTime = Integer.MAX_VALUE;
    int refreshInterval = 120;
    LocalDateTime lastRefreshTime = LocalDateTime.now();
    Map<HostSpec, LocalDateTime> downHostsCacheMap = new ConcurrentHashMap<HostSpec, LocalDateTime>();

    public static DownHostsCache getInstance() {
        if (downHostsCache == null) {
            downHostsCache = new DownHostsCache();
        }
        return downHostsCache;
    }

    private DownHostsCache() {
    }

    public boolean isDownHost(HostSpec hostSpec) {
        return this.downHostsCacheMap.containsKey(hostSpec);
    }

    public void markDownHost(HostSpec hostSpec) {
        if (!this.downHostsCacheMap.containsKey(hostSpec)) {
            this.downHostsCacheMap.put(hostSpec, LocalDateTime.now());
        }
    }

    void refreshCache() {
        if (this.refreshCacheTime < Integer.MAX_VALUE && LocalDateTime.now().minus(this.refreshInterval, ChronoUnit.SECONDS).isAfter(this.lastRefreshTime)) {
            for (HostSpec hostSpec : this.downHostsCacheMap.keySet()) {
                if (LocalDateTime.now().minus(this.refreshCacheTime, ChronoUnit.SECONDS).compareTo(this.downHostsCacheMap.get(hostSpec)) <= 0) continue;
                this.downHostsCacheMap.remove(hostSpec);
            }
            this.lastRefreshTime = LocalDateTime.now();
        }
    }

    public void reorderHosts(HostSpec[] hostSpecs) {
        if (this.downHostsCacheMap.isEmpty()) {
            return;
        }
        this.refreshCache();
        int left = 0;
        int right = hostSpecs.length - 1;
        while (left < right) {
            while (left <= right && !this.isDownHost(hostSpecs[left])) {
                ++left;
            }
            while (left <= right && this.isDownHost(hostSpecs[right])) {
                --right;
            }
            if (left >= right) continue;
            HostSpec tempHS = hostSpecs[left];
            hostSpecs[left] = hostSpecs[right];
            hostSpecs[right] = tempHS;
        }
    }

    public int getRefreshCacheTime() {
        return this.refreshCacheTime;
    }

    public void setRefreshCacheTime(int refreshCacheTime) {
        this.refreshCacheTime = refreshCacheTime;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }
}

