/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.ConnectionManager;
import com.yashandb.ParameterList;
import com.yashandb.Session;
import com.yashandb.SimpleParameterList;
import com.yashandb.YasResultSet;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.DebugBreakpoint;
import com.yashandb.jdbc.DebugFrame;
import com.yashandb.jdbc.DebugVar;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.TransactionState;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasDebugCallableStatement;
import com.yashandb.jdbc.YasFailover;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.YasSavepoint;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasBatchUpdateException;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.jdbc.failover.YasFailoverProcessor;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.parameter.BlobParameter;
import com.yashandb.parameter.ClobParameter;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.ConnectionServerMode;
import com.yashandb.protocol.DebugOperation;
import com.yashandb.protocol.LobOperation;
import com.yashandb.protocol.MsgType;
import com.yashandb.protocol.NativeProtocol;
import com.yashandb.protocol.Packet;
import com.yashandb.protocol.PacketProcessor;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.util.CharacterSet;
import com.yashandb.util.ConnectorFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import com.yashandb.util.StreamWrapper;
import com.yashandb.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;

public class SessionImpl
implements Session {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionImpl.class.getName());
    private static final ConnectionManager connectionManager = new ConnectionManager();
    protected YasSocketConnection yasSocketConnection;
    private final String user;
    private String schema;
    private final int cancelSignalTimeout;
    private YasConnection connection;
    private Statement statement = null;
    private boolean closed = false;
    private TransactionState transactionState = TransactionState.XACT_END;
    protected final boolean logServerErrorDetail;
    private boolean standardConformingStrings = false;
    private SQLWarning warnings;
    private final TreeMap<String, String> parameterStatuses = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private boolean autoCommit = false;
    private NativeProtocol protocol;
    private HostSpec[] hostSpecs;
    private HostSpec hostSpec;
    private Properties info;
    private int sessionID;
    private short charset;
    private short nCharset;
    private int sessionKey;
    private boolean debugExecute = false;
    private boolean debugOn = false;
    private final boolean userCaseSensitive;
    private boolean heartbeatFlag = false;
    private ConnectVersion connectVersion = ConnectVersion.getMaxConnectVersion();
    private List<YasLargeObject> tempLobList = new ArrayList<YasLargeObject>();
    private Set<YasLargeObject> updatedKnlLobs = Collections.synchronizedSet(new HashSet());
    private YasDebugCallableStatement runningDebugStatement = null;
    private YasFailoverProcessor yasFailoverProcessor = null;
    private Set<YasStatement> allStatements = null;
    private boolean failoverInTransaction = false;
    private boolean failoverSuccess = false;
    private boolean ioError = false;
    private boolean isMonitorSession = false;
    private short lobChunkSize = 0;

    public SessionImpl(YasConnection connection, HostSpec[] hostSpecs, String user, Properties info) throws SQLException {
        this.connection = connection;
        this.yasSocketConnection = null;
        if (!user.contains("\"")) {
            user = user.toUpperCase();
            this.userCaseSensitive = false;
        } else {
            user = user.substring(1, user.length() - 1);
            this.userCaseSensitive = true;
        }
        this.user = user;
        this.schema = user;
        this.cancelSignalTimeout = YasProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
        this.logServerErrorDetail = YasProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info);
        this.hostSpecs = hostSpecs;
        this.info = info;
        this.protocol = null;
    }

    public Object cloneForMonitor() throws CloneNotSupportedException {
        SessionImpl cloneSession = (SessionImpl)super.clone();
        cloneSession.yasFailoverProcessor = null;
        cloneSession.isMonitorSession = true;
        try {
            int connectTimeout = Utils.toMillisecond(YasProperty.CONNECT_TIMEOUT.getInt(this.info));
            cloneSession.yasSocketConnection = new YasSocketConnection(this.yasSocketConnection, connectTimeout, true);
            cloneSession.protocol = new NativeProtocol(cloneSession, cloneSession.yasSocketConnection);
            cloneSession.protocol.setServerMode(ConnectionServerMode.DEDICATE_MODE);
            String password = YasProperty.PASSWORD.get(this.info);
            cloneSession.protocol.connect(this.user, password, this.info);
        }
        catch (IOException | SQLException exception) {
            throw new CloneNotSupportedException(Messages.get("clone session attempt failed {0}", exception.getMessage()));
        }
        return cloneSession;
    }

    @Override
    public void setConnection(YasConnection connection) {
        this.connection = connection;
    }

    @Override
    public YasConnection getConnection() {
        return this.connection;
    }

    @Override
    public short getCharset() {
        return this.charset;
    }

    @Override
    public short getnCharset() {
        return this.nCharset;
    }

    @Override
    public void setnCharset(short nCharset) {
        this.nCharset = nCharset;
    }

    @Override
    public synchronized long getLobLength(YasLobProcessor lobProcessor) throws SQLException {
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_GET_LEN, lobProcessor, 0, 0L);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobMetaDataAck(lobProcessor, ackPacket, LobOperation.LOB_GET_LEN);
    }

    @Override
    public synchronized short getLobChunkSize(YasLobProcessor lobProcessor) throws SQLException {
        if (this.lobChunkSize != 0) {
            return this.lobChunkSize;
        }
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_GET_CHUNK_SIZE, lobProcessor, 0, 0L);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        this.lobChunkSize = (short)PacketProcessor.processLobMetaDataAck(lobProcessor, ackPacket, LobOperation.LOB_GET_CHUNK_SIZE);
        return this.lobChunkSize;
    }

    @Override
    public synchronized int getLobData(YasLobProcessor lobProcessor, int reqLen, long lobOffset, byte[] cacheData) throws SQLException {
        byte[] locator = lobProcessor.getLobLocator();
        if (cacheData.length < reqLen) {
            throw new YasException("lob cache buffer size too small: " + cacheData.length, YasState.OUT_OF_MEMORY);
        }
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_READ, lobProcessor, reqLen, lobOffset);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobDataAck(locator, ackPacket, cacheData);
    }

    @Override
    public synchronized YasClob createClob() throws SQLException {
        Packet sendPacket = this.protocol.getSendPacket();
        YasLobProcessor processor = new YasLobProcessor();
        processor.setLobLocator(null);
        processor.setLobType(29);
        processor.setSession(this);
        PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_TMP_CREATE, processor, 0, 0L);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        YasClob clob = new YasClob(true);
        byte[] lobLocator = PacketProcessor.processLobCreateAck(ackPacket);
        processor.setLobLocator(lobLocator);
        int lobType = lobLocator[0] & 0xFF;
        processor.setInnerLobType(lobType);
        processor.setLobLength(0L);
        clob.setLobProcessor(processor);
        clob.setConnection(this.getConnection());
        return clob;
    }

    @Override
    public synchronized YasBlob createBlob() throws SQLException {
        Packet sendPacket = this.protocol.getSendPacket();
        YasLobProcessor processor = new YasLobProcessor();
        processor.setLobLocator(null);
        processor.setLobType(30);
        processor.setSession(this);
        PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_TMP_CREATE, processor, 0, 0L);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        YasBlob blob = new YasBlob(true);
        byte[] lobLocator = PacketProcessor.processLobCreateAck(ackPacket);
        processor.setLobLocator(lobLocator);
        int lobType = lobLocator[0] & 0xFF;
        processor.setInnerLobType(lobType);
        processor.setLobLength(0L);
        blob.setLobProcessor(processor);
        blob.setConnection(this.getConnection());
        return blob;
    }

    @Override
    public synchronized long writeLob(YasLobProcessor lobProcessor, long lobPos, byte[] bytes, int start, int length) throws SQLException {
        int reqLobLen;
        int reqLobHeadLen = 16 + lobProcessor.getLobLocator().length;
        long offset = lobPos;
        long lobLength = 0L;
        Packet sendPacket = this.protocol.getSendPacket();
        for (int remainSize = length; remainSize > 0; remainSize -= reqLobLen) {
            sendPacket.clean();
            reqLobLen = Math.min(remainSize, sendPacket.getRemainSize() - reqLobHeadLen);
            PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_WRITE, lobProcessor, reqLobLen, offset);
            sendPacket.writeBytes(bytes, start, reqLobLen);
            Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
            lobLength = PacketProcessor.processLobMetaDataAck(lobProcessor, ackPacket, LobOperation.LOB_WRITE);
            offset += (long)reqLobLen;
            start += reqLobLen;
        }
        return lobLength;
    }

    @Override
    public synchronized long writeLobByLobLocator(YasLobProcessor lobProcessor, long lobPos, byte[] locBytes) throws SQLException {
        int locLength = locBytes.length;
        if (locLength != 80) {
            throw new YasException("tempLob locator length is error", YasState.DATA_ERROR);
        }
        Packet sendPacket = this.protocol.getSendPacket();
        sendPacket.clean();
        PacketProcessor.writeReqLobByLobLocator(sendPacket, LobOperation.LOB_WRITE, lobProcessor, locLength, lobPos);
        sendPacket.writeBytes(locBytes, 0, locLength);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobMetaDataAck(lobProcessor, ackPacket, LobOperation.LOB_WRITE);
    }

    @Override
    public synchronized void closeLob(YasLobProcessor lobProcessor) throws SQLException {
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_CLOSE, lobProcessor, 0, 0L);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        PacketProcessor.processLobMetaDataAck(lobProcessor, ackPacket, LobOperation.LOB_CLOSE);
    }

    @Override
    public synchronized YasResultSet directExecute(StatementImpl statement, String sql) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeReqExecute(statement, sendPacket, this.autoCommit);
        Packet ackPacket = this.sendCommandWithSql(sendPacket, sql, MsgType.CMD_DIRECT_EXECUTE);
        ackPacket = PacketProcessor.processInteractPacket(statement, ackPacket, this);
        YasResultSet resultSet = PacketProcessor.processDirectExecuteAck(statement, ackPacket, this);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return resultSet;
    }

    @Override
    public synchronized YasResultSet directExecute(StatementImpl statement, String sql, ParameterList[] parameters) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        if (parameters == null) {
            return this.directExecute(statement, sql);
        }
        YasResultSet resultSet = this.directExecuteWithBind(statement, sql, parameters);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return resultSet;
    }

    @Override
    public synchronized YasResultSet fetchCursor(StatementImpl statement) throws SQLException {
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeFetchCursor((short)statement.getID(), sendPacket, statement.getFetchSize());
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_FETCH_CURSOR, 0);
        YasResultSet resultSet = PacketProcessor.processDirectExecuteAck(statement, ackPacket, this);
        resultSet.setStmtQueryResult(true);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return resultSet;
    }

    @Override
    public YasResultSet fetchReturnResultSet(short cursorId) throws SQLException {
        StatementImpl statement = (StatementImpl)this.connection.createStatement();
        statement.setStmtID(cursorId, (byte)0);
        statement.closeOnCompletion();
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeFetchCursor(cursorId, sendPacket, statement.getFetchSize());
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_FETCH_CURSOR, 0);
        YasResultSet resultSet = PacketProcessor.processFetchImplicitResultAck(statement, ackPacket, this);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return resultSet;
    }

    private byte[] getSqlBytes(String sql) {
        Charset serverCharset;
        Charset clientCharset = Charset.defaultCharset();
        byte[] sqlBytes = clientCharset == (serverCharset = CharacterSet.getCharSet(this.charset)) ? sql.getBytes() : sql.getBytes(serverCharset);
        return sqlBytes;
    }

    private Packet sendCommandWithSql(Packet sendPacket, String sql, MsgType cmd) throws SQLException {
        byte[] sqlBytes = this.getSqlBytes(sql);
        int packetLen = 0;
        int sqlOffset = 0;
        if (sqlBytes.length > 0x200000) {
            throw SQLError.createSQLException("the length of sql text exceed limit", YasState.PROTOCOL_VIOLATION);
        }
        boolean firstPacket = true;
        for (int sqlLen = sqlBytes.length; sqlLen > 0; sqlLen -= packetLen) {
            packetLen = sendPacket.getCapacity() - sendPacket.getPostion() - 4;
            if (sqlLen < packetLen) {
                PacketProcessor.writeReqSql(sendPacket, sqlBytes, sqlOffset, sqlLen, false);
                break;
            }
            PacketProcessor.writeReqSql(sendPacket, sqlBytes, sqlOffset, packetLen, true);
            sendPacket.setHasMore(true);
            if (firstPacket) {
                this.sendCommandOnly(sendPacket, cmd, 0);
                firstPacket = false;
            } else {
                this.sendCommandOnly(sendPacket, MsgType.CMD_MORE_DATA, 0);
            }
            sendPacket.clean();
            sqlOffset += packetLen;
        }
        if (firstPacket) {
            return this.sendCommand(sendPacket, cmd, 0);
        }
        return this.sendCommand(sendPacket, MsgType.CMD_MORE_DATA, 0);
    }

    private boolean sendDirectExeWithPrepareSql(Packet sendPacket, String sql) throws SQLException {
        byte[] sqlBytes = this.getSqlBytes(sql);
        int packetLen = 0;
        int sqlOffset = 0;
        boolean hasMore = false;
        if (sqlBytes.length > 0x200000) {
            throw SQLError.createSQLException("the length of sql text exceed limit", YasState.PROTOCOL_VIOLATION);
        }
        boolean firstPacket = true;
        for (int sqlLen = sqlBytes.length; sqlLen > 0; sqlLen -= packetLen) {
            packetLen = sendPacket.getCapacity() - sendPacket.getPostion() - 4;
            if (sqlLen < packetLen) {
                PacketProcessor.writeReqSql(sendPacket, sqlBytes, sqlOffset, sqlLen, false);
                break;
            }
            PacketProcessor.writeReqSql(sendPacket, sqlBytes, sqlOffset, packetLen, true);
            sendPacket.setHasMore(true);
            hasMore = true;
            if (firstPacket) {
                this.sendCommandOnly(sendPacket, MsgType.CMD_DIRECT_EXECUTE, 0);
                firstPacket = false;
            } else {
                this.sendCommandOnly(sendPacket, MsgType.CMD_MORE_DATA, 0);
            }
            sendPacket.clean();
            sqlOffset += packetLen;
        }
        return hasMore;
    }

    @Override
    public synchronized void prepare(StatementImpl statement, String sql) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        Packet preparePacket = this.protocol.getSendPacket();
        PacketProcessor.writeReqPrepare(statement, preparePacket);
        Packet ackPacket = this.sendCommandWithSql(preparePacket, sql, MsgType.CMD_PREPARE);
        PacketProcessor.processPrepareAck(statement, ackPacket);
    }

    @Override
    public synchronized YasResultSet execute(StatementImpl query, ParameterList[] parameters, int maxRows, int fetchSize, int flags) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        this.debugExecute = false;
        YasResultSet resultSet = parameters == null ? this.executeNoBind(query) : this.executeWithBind(query, parameters);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return resultSet;
    }

    private void preProcessLobBind(ParameterList[] parameters) throws SQLException {
        for (ParameterList parameterList : parameters) {
            YasParameter[] yasParameters = parameterList.getParameters();
            for (int i = 0; i < yasParameters.length; ++i) {
                if (yasParameters[i] == null || yasParameters[i].isOutParameter() || yasParameters[i].getLength() <= 32000) continue;
                parameterList.replace(i, this.getLobParameter(yasParameters[i]));
            }
        }
    }

    private void writeBLobByStream(Blob blob, StreamWrapper streamWrapper) throws SQLException, IOException {
        InputStream inputStream = streamWrapper.getStream();
        OutputStream outputStream = blob.setBinaryStream(1L);
        int value = inputStream.read();
        for (int streamLength = streamWrapper.getLength(); value != -1 && streamLength > 0; --streamLength) {
            outputStream.write(value);
            value = inputStream.read();
        }
        outputStream.flush();
    }

    private YasParameter getLobParameter(YasParameter parameter) throws SQLException {
        if (parameter.getType() == 28) {
            YasBlob blob = this.createBlob();
            StreamWrapper streamWrapper = (StreamWrapper)parameter.getValue();
            try {
                this.writeBLobByStream(blob, streamWrapper);
            }
            catch (Exception exception) {
                throw SQLError.createSQLException(exception.getMessage(), YasState.DATA_ERROR);
            }
            BlobParameter blobParameter = new BlobParameter();
            blobParameter.setValue(blob);
            blobParameter.setInDirection();
            this.tempLobList.add(blob);
            return blobParameter;
        }
        YasClob clob = this.createClob();
        clob.setString(1L, (String)parameter.getValue());
        ClobParameter clobParameter = new ClobParameter();
        clobParameter.setValue(clob);
        clobParameter.setInDirection();
        this.tempLobList.add(clob);
        return clobParameter;
    }

    private void doFreeLobs() throws SQLException {
        if (!this.tempLobList.isEmpty()) {
            for (YasLargeObject largeObject : this.tempLobList) {
                largeObject.freeTemp();
            }
            this.tempLobList.clear();
        }
    }

    private void freeTempLobs() {
        try {
            this.doFreeLobs();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private YasResultSet executePartitionBinds(StatementImpl query, ParameterList[] parameters) throws SQLException {
        int batchSize = parameters.length;
        int beginBatch = 0;
        YasResultSet totalResult = null;
        while (batchSize > 0) {
            Packet ack;
            int subBatchSize = Math.min(Math.min(2000, this.getSameTypeNum(beginBatch, parameters)), batchSize);
            ParameterList[] subParameterList = Arrays.copyOfRange(parameters, beginBatch, beginBatch + subBatchSize);
            try {
                ack = this.sendBindExecutePacket(query, subParameterList);
            }
            catch (SQLException e) {
                String batchMsg = BatchError.converMsgToBatchMsg(e.getMessage());
                if (batchMsg == null) {
                    throw e;
                }
                BatchError batchError = new BatchError(e.getErrorCode(), batchMsg);
                if (totalResult == null) {
                    int[] emptyArray = new int[]{};
                    throw new YasBatchUpdateException(0, batchError, emptyArray);
                }
                int[] preDmlRows = totalResult.getBatchUpdateCounts();
                throw new YasBatchUpdateException(preDmlRows.length, batchError, preDmlRows);
            }
            if (ack.getCmd() == MsgType.CMD_DEBUG) {
                throw SQLError.createSQLException("Unexpected ack command type: CMD_DEBUG.", YasState.UNKNOWN_STATE);
            }
            try {
                YasResultSet resultSet = PacketProcessor.processExecuteAckInBatchMode(query, ack, this);
                if (totalResult == null) {
                    totalResult = resultSet;
                } else {
                    totalResult.appendResults(resultSet.getUpdateCount(), resultSet.getBatchUpdateCounts(), resultSet.getBatchErrors());
                }
            }
            catch (YasBatchUpdateException e) {
                if (totalResult == null) {
                    throw e;
                }
                int[] preDmlRows = totalResult.getBatchUpdateCounts();
                int[] curDmlRows = e.getUpdateCounts();
                int[] totalDmlRows = new int[preDmlRows.length + curDmlRows.length];
                System.arraycopy(preDmlRows, 0, totalDmlRows, 0, preDmlRows.length);
                System.arraycopy(curDmlRows, 0, totalDmlRows, preDmlRows.length, curDmlRows.length);
                throw new YasBatchUpdateException(preDmlRows.length + e.getRowNum(), e.getBatchError(), totalDmlRows);
            }
            batchSize -= subParameterList.length;
            beginBatch += subParameterList.length;
        }
        return totalResult;
    }

    private Packet sendBindExecutePacket(StatementImpl statement, ParameterList[] parameters) throws SQLException {
        Packet reqExecute = this.protocol.getSendPacket();
        PacketProcessor.writeReqExecute(statement, reqExecute, parameters, this.autoCommit, this.debugExecute);
        boolean isMore = false;
        for (ParameterList parameter : parameters) {
            SimpleParameterList params = (SimpleParameterList)parameter;
            for (int j = 1; j <= params.getParameterCount(); ++j) {
                if (reqExecute.getRemainSize() > params.getLength(j)) {
                    params.writeValue(j, reqExecute);
                    continue;
                }
                reqExecute.setHasMore(true);
                this.sendExecutePacketOnly(reqExecute, isMore);
                reqExecute.clean();
                reqExecute.setHasMore(false);
                params.writeValue(j, reqExecute);
                isMore = true;
            }
        }
        return this.sendExecutePacket(statement, reqExecute, isMore);
    }

    private Packet sendBindDirectExecutePacket(StatementImpl statement, String sql, ParameterList[] parameters) throws SQLException {
        Packet reqExecute = this.protocol.getSendPacket();
        PacketProcessor.writeReqDirectExecute(statement, reqExecute, parameters, this.autoCommit, this.debugExecute);
        boolean isMore = this.sendDirectExeWithPrepareSql(reqExecute, sql);
        PacketProcessor.writeReqExecuteParamType(statement, reqExecute, parameters);
        for (ParameterList parameter : parameters) {
            SimpleParameterList params = (SimpleParameterList)parameter;
            for (int j = 1; j <= params.getParameterCount(); ++j) {
                if (reqExecute.getRemainSize() > params.getLength(j)) {
                    params.writeValue(j, reqExecute);
                    continue;
                }
                reqExecute.setHasMore(true);
                this.sendDirectExecutePacketOnly(reqExecute, isMore);
                reqExecute.clean();
                reqExecute.setHasMore(false);
                params.writeValue(j, reqExecute);
                isMore = true;
            }
        }
        return this.sendDirectExecutePacket(statement, reqExecute, isMore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YasResultSet executeWithBind(StatementImpl query, ParameterList[] parameters) throws SQLException {
        try {
            this.preProcessLobBind(parameters);
            if (parameters.length > 2000 || this.getSameTypeNum(0, parameters) != parameters.length) {
                YasResultSet yasResultSet = this.executePartitionBinds(query, parameters);
                return yasResultSet;
            }
            Packet ack = this.sendBindExecutePacket(query, parameters);
            YasResultSet yasResultSet = PacketProcessor.processExecuteAck(query, ack, this);
            return yasResultSet;
        }
        finally {
            this.freeTempLobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YasResultSet directExecuteWithBind(StatementImpl query, String sql, ParameterList[] parameters) throws SQLException {
        try {
            this.preProcessLobBind(parameters);
            if (parameters.length > 2000 || this.getSameTypeNum(0, parameters) != parameters.length) {
                YasResultSet yasResultSet = this.prepareAndExecuteWithBind(query, sql, parameters);
                return yasResultSet;
            }
            Packet ack = this.sendBindDirectExecutePacket(query, sql, parameters);
            YasResultSet yasResultSet = PacketProcessor.processDirectExecuteAck(query, ack, this);
            return yasResultSet;
        }
        finally {
            this.freeTempLobs();
        }
    }

    private YasResultSet prepareAndExecuteWithBind(StatementImpl query, String sql, ParameterList[] parameters) throws SQLException {
        this.prepare(query, sql);
        return this.execute(query, parameters, 0, 0, 0);
    }

    private int getSameTypeNum(int startIndex, ParameterList[] parameters) {
        ParameterList first = parameters[startIndex];
        for (int i = startIndex + 1; i < parameters.length; ++i) {
            ParameterList tmpParameterList = parameters[i];
            for (int j = 0; j < tmpParameterList.getParameterCount(); ++j) {
                if (first.getParameters()[j].getType() == tmpParameterList.getParameters()[j].getType()) continue;
                return i - startIndex;
            }
        }
        return parameters.length;
    }

    private Packet sendExecutePacket(StatementImpl statement, Packet reqExecute, boolean isMore) throws SQLException {
        Packet ackPacket = isMore ? this.sendCommand(reqExecute, MsgType.CMD_MORE_DATA, 0) : this.sendCommand(reqExecute, MsgType.CMD_EXECUTE, 0);
        return PacketProcessor.processInteractPacket(statement, ackPacket, this);
    }

    private Packet sendDirectExecutePacket(StatementImpl statement, Packet reqExecute, boolean isMore) throws SQLException {
        Packet ackPacket = isMore ? this.sendCommand(reqExecute, MsgType.CMD_MORE_DATA, 0) : this.sendCommand(reqExecute, MsgType.CMD_DIRECT_EXECUTE, 0);
        return PacketProcessor.processInteractPacket(statement, ackPacket, this);
    }

    private void sendExecutePacketOnly(Packet reqExecute, boolean isMore) throws SQLException {
        if (isMore) {
            this.sendCommandOnly(reqExecute, MsgType.CMD_MORE_DATA, 0);
        } else {
            this.sendCommandOnly(reqExecute, MsgType.CMD_EXECUTE, 0);
        }
    }

    private void sendDirectExecutePacketOnly(Packet reqExecute, boolean isMore) throws SQLException {
        if (isMore) {
            this.sendCommandOnly(reqExecute, MsgType.CMD_MORE_DATA, 0);
        } else {
            this.sendCommandOnly(reqExecute, MsgType.CMD_DIRECT_EXECUTE, 0);
        }
    }

    private YasResultSet executeNoBind(StatementImpl statement) throws SQLException {
        Packet reqExecute = this.protocol.getSendPacket();
        PacketProcessor.writeReqExecute(statement, reqExecute, this.autoCommit);
        Packet ackPacket = this.sendCommand(reqExecute, MsgType.CMD_EXECUTE, 0);
        ackPacket = PacketProcessor.processInteractPacket(statement, ackPacket, this);
        return PacketProcessor.processExecuteAck(statement, ackPacket, this);
    }

    @Override
    public synchronized Packet fetch(YasStatement query, int fetchSize) throws SQLException {
        Packet reqFetch = this.protocol.getSendPacket();
        PacketProcessor.writeReqFetch(query, reqFetch);
        return this.sendCommand(reqFetch, MsgType.CMD_FETCH, 0);
    }

    @Override
    public synchronized Packet moreData() throws SQLException {
        Packet reqExecute = this.protocol.getSendPacket();
        try {
            return this.sendCommand(reqExecute, MsgType.CMD_MORE_DATA, 0);
        }
        catch (SQLException e) {
            if (YasState.IO_ERROR.getState().equals(e.getSQLState())) {
                this.closeSessionAndFailover(MsgType.CMD_MORE_DATA);
            }
            throw e;
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        Packet commit = this.protocol.getSendPacket();
        this.sendCommand(commit, MsgType.CMD_COMMIT, 0);
        this.setTransactionState(TransactionState.XACT_END);
        for (YasLargeObject largeObject : this.updatedKnlLobs) {
            largeObject.commit();
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public synchronized Packet continueExecute() throws SQLException {
        Packet commit = this.protocol.getSendPacket();
        return this.sendCommand(commit, MsgType.CMD_MORE_DATA, 0);
    }

    private Statement getStatement() throws SQLException {
        if (this.statement == null || this.statement.isClosed()) {
            this.statement = this.connection.createStatement();
        }
        return this.statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimaryHost() throws SQLException {
        boolean isPrimary = false;
        ResultSet resultSet = null;
        try {
            String hostRole;
            this.statement = this.connection.createStatement();
            resultSet = this.statement.executeQuery("select DATABASE_ROLE from v$database");
            if (resultSet.next() && (hostRole = resultSet.getString(1)).trim().equalsIgnoreCase("PRIMARY")) {
                isPrimary = true;
            }
            resultSet.close();
            this.statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
        }
        return isPrimary;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.failoverInTransaction = false;
        if (this.getTransactionState() == TransactionState.XACT_END) {
            LOGGER.debug("Rollback requested but no transaction in progress");
            return;
        }
        Packet packet = this.protocol.getSendPacket();
        this.sendCommand(packet, MsgType.CMD_ROLLBACK, 0);
        this.setTransactionState(TransactionState.XACT_END);
        for (YasLargeObject largeObject : this.updatedKnlLobs) {
            largeObject.rollback();
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public synchronized void setSchema(String schema) throws SQLException {
        Statement statement = this.getStatement();
        String sqlStr = "alter session set current_schema = " + schema;
        statement.execute(sqlStr);
        schema = !schema.contains("\"") ? schema.toUpperCase() : schema.substring(1, schema.length() - 1);
        this.schema = schema;
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        return this.schema;
    }

    @Override
    public void setSID(int sid) {
        this.sessionID = sid;
    }

    @Override
    public void setCharset(short charset) {
        this.charset = charset;
    }

    @Override
    public void setSessionKey(int key) {
        this.sessionKey = key;
    }

    @Override
    public int getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public String getDatabase() {
        return "";
    }

    @Override
    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.yasSocketConnection.setNetworkTimeout(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws IOException {
        return this.yasSocketConnection.getNetworkTimeout();
    }

    @Override
    public void abort(Executor executor) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                SessionImpl.this.doClose();
            }
        });
    }

    public void setProtocol(NativeProtocol protocol) {
        this.protocol = protocol;
    }

    public void setYasSocketConnection(YasSocketConnection yasSocketConnection) {
        this.yasSocketConnection = yasSocketConnection;
    }

    private void doClose() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
            this.doFreeLobs();
        }
        catch (SQLException exception) {
            LOGGER.error("Discarding SQLException on close: {}", (Object)exception.getMessage());
        }
        try {
            this.sendCloseMessage();
        }
        catch (SQLException sqlException) {
            LOGGER.error("Discarding SQLException on close: {}", (Object)sqlException.getMessage());
        }
        try {
            this.yasSocketConnection.flush();
            this.yasSocketConnection.close();
        }
        catch (IOException ioe) {
            LOGGER.error("Discarding IOException on close: {}", (Object)ioe.getMessage());
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        LOGGER.debug(" FE=> Terminate");
        this.doClose();
        this.closed = true;
        connectionManager.unRegister(this);
    }

    @Override
    public boolean processInvalid() {
        if (!this.heartbeatFlag) {
            return false;
        }
        LOGGER.error("The heartbeat check failed, will force close socket.");
        if (this.ioError) {
            return true;
        }
        this.ioError = true;
        this.closeStream(this.yasSocketConnection);
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void closeStmt(int stmtID) throws SQLException {
        Packet reqClose = this.protocol.getSendPacket();
        reqClose.writeShort(stmtID);
        reqClose.writeShort(0);
        Packet ack = this.sendCommand(reqClose, MsgType.CMD_FREE_STMT, 0);
    }

    @Override
    public synchronized void addWarning(SQLWarning newWarning) {
        if (this.warnings == null) {
            this.warnings = newWarning;
        } else {
            this.warnings.setNextWarning(newWarning);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        SQLWarning chain = this.warnings;
        this.warnings = null;
        return chain;
    }

    @Override
    public synchronized void setTransactionState(TransactionState state) {
        this.transactionState = state;
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        String isolationPara;
        Statement statement = this.getStatement();
        switch (level) {
            case 8: {
                isolationPara = "SERIALIZABLE";
                break;
            }
            default: {
                isolationPara = "READ COMMITTED";
            }
        }
        String sqlStr = "alter session set isolation_level = " + isolationPara;
        statement.execute(sqlStr);
    }

    @Override
    public int getSID() {
        return this.sessionID;
    }

    public synchronized void setStandardConformingStrings(boolean value) {
        this.standardConformingStrings = value;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    @Override
    public synchronized TransactionState getTransactionState() {
        return this.transactionState;
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        return Collections.unmodifiableMap(this.parameterStatuses);
    }

    @Override
    public final String getParameterStatus(String parameterName) {
        return this.parameterStatuses.get(parameterName);
    }

    protected synchronized void sendCloseMessage() throws SQLException {
        Packet logOut = this.protocol.getSendPacket();
        this.sendCommand(logOut, MsgType.CMD_LOGOUT, 0);
    }

    public void receiveParameterStatus() throws IOException, SQLException {
    }

    protected void onParameterStatus(String parameterName, String parameterStatus) {
        if (parameterName == null || parameterName.equals("")) {
            throw new IllegalStateException("attempt to set GUC_REPORT parameter with null or empty-string name");
        }
        this.parameterStatuses.put(parameterName, parameterStatus);
    }

    @Override
    public void cancel() throws SQLException {
        int connectTimeout = Utils.toMillisecond(YasProperty.CONNECT_TIMEOUT.getInt(this.info));
        try {
            YasSocketConnection dupConn = new YasSocketConnection(this.yasSocketConnection, connectTimeout, true);
            NativeProtocol tempProtocol = new NativeProtocol(this, dupConn);
            tempProtocol.cancel();
            this.closeStream(dupConn);
        }
        catch (IOException ioe) {
            throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }

    @Override
    public void connect() throws SQLException {
        String serverType = this.connection.getServerType();
        HostConnector connector = ConnectorFactory.generateConnector(this, this.hostSpecs, serverType);
        connector.checkConfigurations(this.info);
        connector.connect(this.getUser(), this.info);
        this.hostSpec = this.yasSocketConnection.getHostSpec();
        connectionManager.register(this);
    }

    protected void closeStream(YasSocketConnection newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        YasSavepoint savepoint = new YasSavepoint();
        Statement statement = this.getStatement();
        String sqlStr = "savepoint yas_autosvpt_" + savepoint.getSavepointId();
        statement.execute(sqlStr);
        return savepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        YasSavepoint savepoint = new YasSavepoint(name);
        Statement statement = this.getStatement();
        String sqlStr = "savepoint " + savepoint.getSavepointName();
        statement.execute(sqlStr);
        return savepoint;
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        String pointStr;
        this.failoverInTransaction = false;
        if (savepoint == null) {
            return;
        }
        Statement statement = this.getStatement();
        try {
            pointStr = savepoint.getSavepointName();
        }
        catch (SQLException sqlException) {
            pointStr = "yas_autosvpt_" + savepoint.getSavepointId();
        }
        statement.execute("rollback to " + pointStr);
        this.setTransactionState(TransactionState.XACT_END);
        for (YasLargeObject largeObject : this.updatedKnlLobs) {
            largeObject.rollback();
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public boolean isUserCaseSensitive() {
        return this.userCaseSensitive;
    }

    @Override
    public ConnectVersion getConnectVersion() {
        return this.connectVersion;
    }

    @Override
    public void setConnectVersion(ConnectVersion connectVersion) {
        this.connectVersion = connectVersion;
    }

    @Override
    public long trimLob(YasLobProcessor lobProcessor, long len) throws SQLException {
        Packet sendPacket = this.protocol.getSendPacket();
        PacketProcessor.writeReqLob(sendPacket, LobOperation.LOB_TRIM, lobProcessor, 0, len);
        Packet ackPacket = this.sendCommand(sendPacket, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobMetaDataAck(lobProcessor, ackPacket, LobOperation.LOB_TRIM);
    }

    @Override
    public void addUpdatedKnlLob(YasLargeObject yasLargeObject) {
        this.updatedKnlLobs.add(yasLargeObject);
    }

    @Override
    public void removeUpdatedKnlLob(YasLargeObject yasLargeObject) {
        this.updatedKnlLobs.remove(yasLargeObject);
    }

    @Override
    public YasClob preProcessReaderBinding(Reader reader, char[] readBuf, long maxLength) throws SQLException {
        YasClob clob = (YasClob)this.connection.createClob();
        StringBuilder stringBuilder = new StringBuilder(readBuf.length);
        stringBuilder.append(readBuf, 0, readBuf.length);
        int bufferSize = Math.min(readBuf.length, 2048);
        try {
            int nRead;
            long tempLength = maxLength - (long)readBuf.length;
            while (tempLength > 0L && (nRead = reader.read(readBuf, 0, (int)Math.min((long)bufferSize, tempLength))) >= 0) {
                if (nRead == 0) continue;
                stringBuilder.append(readBuf, 0, nRead);
                tempLength -= (long)nRead;
                if (stringBuilder.length() < 40000 - bufferSize) continue;
                clob.setString(clob.length() + 1L, stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            if (stringBuilder.length() > 0) {
                clob.setString(clob.length() + 1L, stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        catch (IOException ioe) {
            clob.free();
            throw SQLError.createSQLException(Messages.get("Access Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        this.tempLobList.add(clob);
        return clob;
    }

    @Override
    public synchronized YasResultSet pdbgExecute(YasDebugCallableStatement statement, ParameterList[] parameters) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        this.debugExecute = true;
        YasResultSet resultSet = parameters == null ? this.pdbgExecuteNoBind(statement) : this.pdbgExecuteWithBind(statement, parameters);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        this.debugExecute = false;
        return resultSet;
    }

    private YasResultSet pdbgExecuteWithBind(YasDebugCallableStatement statement, ParameterList[] parameters) throws SQLException {
        YasResultSet yasResultSet = null;
        try {
            this.preProcessLobBind(parameters);
            if (parameters.length > 2000 || this.getSameTypeNum(0, parameters) != parameters.length) {
                return this.executePartitionBinds(statement, parameters);
            }
            Packet ack = this.sendBindExecutePacket(statement, parameters);
            yasResultSet = PacketProcessor.processDebugExecutePacket(statement, ack, this, DebugOperation.DBG_START);
            if (yasResultSet != null) {
                this.freeTempLobs();
            }
            return yasResultSet;
        }
        catch (SQLException e) {
            this.freeTempLobs();
            throw e;
        }
    }

    private YasResultSet pdbgExecuteNoBind(YasDebugCallableStatement statement) throws SQLException {
        Packet reqExecute = this.protocol.getSendPacket();
        PacketProcessor.writeReqExecute(statement, reqExecute, this.autoCommit, this.debugExecute);
        Packet ackPacket = this.sendCommand(reqExecute, MsgType.CMD_EXECUTE, 0);
        ackPacket = PacketProcessor.processInteractPacket(statement, ackPacket, this);
        return PacketProcessor.processDebugExecutePacket(statement, ackPacket, this, DebugOperation.DBG_START);
    }

    @Override
    public synchronized void pdbgAbort(YasDebugCallableStatement statement) throws SQLException {
        Packet ackPacket;
        Packet reqDebug = this.protocol.getSendPacket();
        PacketProcessor.writeReqDebug(statement, reqDebug, DebugOperation.DBG_ABORT, 0);
        try {
            ackPacket = this.sendCommand(reqDebug, MsgType.CMD_DEBUG, 0);
        }
        catch (SQLException e) {
            this.setDebugOff();
            throw e;
        }
        ackPacket = PacketProcessor.processInteractPacket(statement, ackPacket, this);
        PacketProcessor.processDebugExecutePacket(statement, ackPacket, this, DebugOperation.DBG_ABORT);
    }

    @Override
    public synchronized void pdbgAddBreakpoint(YasDebugCallableStatement statement, List<DebugBreakpoint> debugBreakpointList) throws SQLException {
        for (DebugBreakpoint debugBreakpoint : debugBreakpointList) {
            Packet ackPacket;
            Packet reqDebug = this.protocol.getSendPacket();
            PacketProcessor.writeReqDebug(statement, reqDebug, DebugOperation.DBG_ADD_BP, 14);
            reqDebug.writeLong(debugBreakpoint.getObjectId());
            reqDebug.writeShort(debugBreakpoint.getSubprogramId());
            reqDebug.writeInt(debugBreakpoint.getLineNum());
            try {
                ackPacket = this.sendCommand(reqDebug, MsgType.CMD_DEBUG, 0);
            }
            catch (SQLException e) {
                this.setDebugOff();
                throw e;
            }
            int id = (Integer)PacketProcessor.processDebugMetaDataAck(this, statement, ackPacket, DebugOperation.DBG_ADD_BP);
            debugBreakpoint.setId(id);
        }
    }

    @Override
    public synchronized void pdbgDeleteBreakpoint(YasDebugCallableStatement statement, List<DebugBreakpoint> debugBreakpointList) throws SQLException {
        for (DebugBreakpoint debugBreakpoint : debugBreakpointList) {
            Packet ackPacket;
            Packet reqDebug = this.protocol.getSendPacket();
            PacketProcessor.writeReqDebug(statement, reqDebug, DebugOperation.DBG_DEL_BP, 4);
            reqDebug.writeInt(debugBreakpoint.getId());
            try {
                ackPacket = this.sendCommand(reqDebug, MsgType.CMD_DEBUG, 0);
            }
            catch (SQLException e) {
                this.setDebugOff();
                throw e;
            }
            PacketProcessor.processDebugMetaDataAck(this, statement, ackPacket, DebugOperation.DBG_ABORT);
        }
    }

    @Override
    public synchronized void pdbgCheckVersion(YasDebugCallableStatement statement, long objectId, int subprogramId, int version) throws SQLException {
        Packet ackPacket;
        Packet reqDebug = this.protocol.getSendPacket();
        PacketProcessor.writeReqDebug(statement, reqDebug, DebugOperation.DBG_CHECK_VERSION, 14);
        reqDebug.writeLong(objectId);
        reqDebug.writeShort(subprogramId);
        reqDebug.writeInt(version);
        try {
            ackPacket = this.sendCommand(reqDebug, MsgType.CMD_DEBUG, 0);
        }
        catch (SQLException e) {
            this.setDebugOff();
            throw e;
        }
        PacketProcessor.processDebugMetaDataAck(this, statement, ackPacket, DebugOperation.DBG_CHECK_VERSION);
    }

    @Override
    public synchronized YasResultSet pdbgStepDebug(YasDebugCallableStatement statement, DebugOperation dbgStepInto) throws SQLException {
        try {
            Packet ackPacket;
            Packet reqDebug = this.protocol.getSendPacket();
            PacketProcessor.writeReqDebug(statement, reqDebug, dbgStepInto, 0);
            try {
                ackPacket = this.sendCommand(reqDebug, MsgType.CMD_DEBUG, 0);
            }
            catch (SQLException e) {
                this.setDebugOff();
                throw e;
            }
            ackPacket = PacketProcessor.processInteractPacket(statement, ackPacket, this);
            YasResultSet yasResultSet = PacketProcessor.processDebugExecutePacket(statement, ackPacket, this, dbgStepInto);
            if (yasResultSet != null) {
                this.freeTempLobs();
            }
            return yasResultSet;
        }
        catch (SQLException e) {
            this.freeTempLobs();
            throw e;
        }
    }

    @Override
    public synchronized List<DebugVar> pdbgShowVars(YasDebugCallableStatement statement) throws SQLException {
        Packet ackPacket;
        Packet reqDebug = this.protocol.getSendPacket();
        PacketProcessor.writeReqDebug(statement, reqDebug, DebugOperation.DBG_SHOW_VARS, 0);
        try {
            ackPacket = this.sendCommand(reqDebug, MsgType.CMD_DEBUG, 0);
        }
        catch (SQLException e) {
            this.setDebugOff();
            throw e;
        }
        List result = (List)PacketProcessor.processDebugMetaDataAck(this, statement, ackPacket, DebugOperation.DBG_SHOW_VARS);
        return result;
    }

    @Override
    public synchronized List<DebugFrame> pdbgShowFrames(YasDebugCallableStatement statement) throws SQLException {
        Packet ackPacket;
        Packet reqDebug = this.protocol.getSendPacket();
        PacketProcessor.writeReqDebug(statement, reqDebug, DebugOperation.DBG_SHOW_FRAMES, 0);
        try {
            ackPacket = this.sendCommand(reqDebug, MsgType.CMD_DEBUG, 0);
        }
        catch (SQLException e) {
            this.setDebugOff();
            throw e;
        }
        List result = (List)PacketProcessor.processDebugMetaDataAck(this, statement, ackPacket, DebugOperation.DBG_SHOW_FRAMES);
        return result;
    }

    @Override
    public void abortDebug() throws SQLException {
        if (this.debugOn) {
            this.pdbgAbort(this.runningDebugStatement);
        }
    }

    public void updateDebugStatus(YasDebugCallableStatement statement, long objectId, int subprogramId, int lineNum) {
        if (!this.debugOn) {
            this.debugOn = true;
            this.runningDebugStatement = statement;
        }
        this.runningDebugStatement.setDebugStatus(1, objectId, subprogramId, lineNum);
    }

    public void setDebugOff() {
        if (!this.debugOn) {
            return;
        }
        this.runningDebugStatement.setDebugStatus(0, -1L, -1, -1);
        this.debugOn = false;
        this.runningDebugStatement = null;
    }

    public void processHeartBeat() {
        this.heartbeatFlag = true;
    }

    @Override
    public void initFailoverProcessor() throws SQLException {
        String failover = YasProperty.FAILOVER.get(this.info);
        String failoverType = YasProperty.FAILOVER_TYPE.get(this.info);
        if (failover != null && failover.equalsIgnoreCase("on") && failoverType != null && !failoverType.equalsIgnoreCase("none")) {
            this.yasFailoverProcessor = new YasFailoverProcessor(this, this.info, this.hostSpecs);
        }
    }

    private void closeSessionAndFailover(MsgType msgType) throws SQLException {
        if (this.isMonitorSession || msgType == MsgType.CMD_LOGIN || msgType == MsgType.CMD_LOGOUT) {
            return;
        }
        this.closeStream(this.yasSocketConnection);
        connectionManager.unRegister(this);
        if (this.yasFailoverProcessor == null) {
            this.ioError = true;
            return;
        }
        this.ioError = false;
        this.failoverSuccess = false;
        SQLException exception = null;
        try {
            this.yasFailoverProcessor.doTransparentAppFailover();
        }
        catch (SQLException e) {
            exception = e;
        }
        if (this.failoverSuccess) {
            boolean inTransaction = false;
            if (this.getTransactionState() != TransactionState.XACT_END) {
                inTransaction = true;
            }
            try {
                this.reset();
            }
            catch (SQLException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            this.failoverInTransaction = inTransaction;
        } else {
            this.ioError = true;
            this.connection.close();
        }
        if (exception != null) {
            throw exception;
        }
        if (this.yasFailoverProcessor.getFailoverType() != 2 || msgType == MsgType.CMD_MORE_DATA || msgType == MsgType.CMD_LOB) {
            throw SQLError.createSQLException("Cannot be safely called repeatedly.", YasState.QUERY_CANCELED);
        }
    }

    @Override
    public void addStatement(YasStatement statement) {
        if (this.yasFailoverProcessor == null) {
            return;
        }
        if (this.allStatements == null) {
            this.allStatements = new HashSet<YasStatement>();
        }
        this.allStatements.add(statement);
    }

    @Override
    public void removeStatement(YasStatement statement) {
        if (this.allStatements == null) {
            return;
        }
        this.allStatements.remove(statement);
    }

    private void reset() throws SQLException {
        try {
            this.connection.setTransactionIsolation(this.connection.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setSchema(this.schema);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.allStatements == null) {
            return;
        }
        for (YasStatement statement : this.allStatements) {
            statement.reset();
        }
    }

    private void checkSession() throws SQLException {
        if (this.ioError) {
            throw SQLError.createSQLException(Messages.get("This socket has been closed.", new Object[0]), YasState.IO_ERROR);
        }
        if (this.failoverInTransaction) {
            throw SQLError.createSQLException(Messages.get("The transaction must be rerun.", new Object[0]), YasState.INVALID_TRANSACTION_TERMINATION);
        }
    }

    @Override
    public void refreshAfterFailover(YasLinkInfo linkInfo) throws SQLException {
        this.setProtocol(linkInfo.getProtocol());
        this.setYasSocketConnection(linkInfo.getYasSocketConnection());
        this.ioError = false;
        this.hostSpec = this.yasSocketConnection.getHostSpec();
        connectionManager.register(this);
        this.failoverSuccess = true;
    }

    private Packet sendCommand(Packet packet, MsgType msgType, int flags) throws SQLException {
        try {
            this.checkSession();
            return this.protocol.sendCommand(packet, msgType, flags);
        }
        catch (SQLException e) {
            if (YasState.IO_ERROR.getState().equals(e.getSQLState())) {
                this.closeSessionAndFailover(msgType);
            }
            throw e;
        }
    }

    private void sendCommandOnly(Packet packet, MsgType msgType, int flags) throws SQLException {
        try {
            this.checkSession();
            this.protocol.sendCommandOnly(packet, msgType, flags);
        }
        catch (SQLException e) {
            if (YasState.IO_ERROR.getState().equals(e.getSQLState())) {
                this.closeSessionAndFailover(msgType);
            }
            throw e;
        }
    }

    @Override
    public synchronized void registerTAFCallback(YasFailover yasFailover, Object ctxt) throws SQLException {
        if (this.yasFailoverProcessor == null) {
            throw SQLError.createSQLException(Messages.get("Failover is not open.", new Object[0]), YasState.CHECK_VIOLATION);
        }
        this.yasFailoverProcessor.registerTAFCallback(yasFailover, ctxt);
    }
}

