/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.ParameterList;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.ParameterLittleEndianFactory;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.Packet;
import com.yashandb.util.ByteStreamWriter;
import com.yashandb.util.Messages;
import com.yashandb.util.StreamWrapper;
import com.yashandb.util.Utils;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public class SimpleParameterList
implements ParameterList,
Cloneable {
    private ParameterFactory parameterFactory = new ParameterLittleEndianFactory();
    private YasParameter[] yasParameters;
    private int pos = 0;
    private short charset = 0;
    private short nCharset = 0;

    public SimpleParameterList(int paramCount) {
        this.yasParameters = new YasParameter[paramCount];
    }

    @Override
    public void setCharset(short charset) {
        this.charset = charset;
    }

    @Override
    public void setnCharset(short nCharset) {
        this.nCharset = nCharset;
    }

    private boolean isToSetNullObject(int index, Object value, int type) {
        if (this.yasParameters[index] == null) {
            return false;
        }
        return type == 0 && value == ParameterFactory.getNullObject() && this.yasParameters[index].getType() != 0;
    }

    private void checkParameterIndex(int index) throws SQLException {
        if (index < 1 || index > this.yasParameters.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", index, this.yasParameters.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    private void bind(int index, Object value, int type) throws SQLException {
        this.checkParameterIndex(index);
        if (this.isToSetNullObject(--index, value, type)) {
            this.yasParameters[index].setValue(ParameterFactory.getNullObject());
            this.yasParameters[index].setInDirection();
            return;
        }
        if (this.yasParameters[index] == null || this.yasParameters[index].getType() != type) {
            YasParameter parameter;
            this.yasParameters[index] = parameter = this.parameterFactory.getParameter(type);
        }
        this.yasParameters[index].setValue(value);
        this.yasParameters[index].setInDirection();
        if (this.yasParameters[index].getType() == 27) {
            this.yasParameters[index].setCharset(this.nCharset);
        } else {
            this.yasParameters[index].setCharset(this.charset);
        }
        this.pos = index + 1;
    }

    @Override
    public int getParameterCount() {
        return this.yasParameters.length;
    }

    @Override
    public int getInParameterCount() {
        int count = 0;
        for (YasParameter yasParameter : this.yasParameters) {
            if (yasParameter.isOutParameter()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void replace(int index, YasParameter parameter) throws SQLException {
        if (index < 0 || index >= this.yasParameters.length) {
            throw SQLError.createSQLException(Messages.get("Invalid parameter index", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.yasParameters[index] = parameter;
    }

    @Override
    public void setIntParameter(int index, long value, int type) throws SQLException {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.bind(index, (int)value, type);
                break;
            }
            case 5: {
                this.bind(index, value, type);
                break;
            }
            default: {
                throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setIntParameter with type " + type);
            }
        }
    }

    @Override
    public void setDoubleParameter(int index, double value, int type) throws SQLException {
        this.bind(index, value, type);
    }

    @Override
    public void setFloatParameter(int index, float value, int type) throws SQLException {
        this.bind(index, Float.valueOf(value), type);
    }

    @Override
    public void setNumberParameter(int index, Number value, int type) throws SQLException {
        this.bind(index, value, type);
    }

    @Override
    public void setStringParameter(int index, String value) throws SQLException {
        this.bind(index, value, 26);
    }

    @Override
    public void setNStringParameter(int index, String value) throws SQLException {
        this.bind(index, value, 27);
    }

    @Override
    public void setDateParameter(int index, Date date, int type) throws SQLException {
        this.bind(index, date, type);
    }

    @Override
    public void setTimeStampParameter(int index, Timestamp timestamp, int type) throws SQLException {
        this.bind(index, timestamp, type);
    }

    @Override
    public void setTimeParameter(int index, Time time, int type) throws SQLException {
        this.bind(index, time, type);
    }

    @Override
    public void setDsIntervalParameter(int index, long interval, int type) throws SQLException {
        this.bind(index, interval, type);
    }

    @Override
    public void setYmIntervalParameter(int index, int interval, int type) throws SQLException {
        this.bind(index, interval, type);
    }

    @Override
    public void setClobParameter(int index, Clob clob, int type) throws SQLException {
        this.bind(index, clob, type);
    }

    @Override
    public void setBlobParameter(int index, Blob blob, int type) throws SQLException {
        this.bind(index, blob, type);
    }

    @Override
    public void setBinaryParameter(int index, byte[] value, int oid) throws SQLException {
        this.bind(index, value, oid);
    }

    @Override
    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 28);
    }

    @Override
    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 28);
    }

    @Override
    public void setBytea(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 28);
    }

    @Override
    public void setBytea(int index, ByteStreamWriter writer) throws SQLException {
        this.bind(index, writer, 28);
    }

    @Override
    public void setText(int index, InputStream stream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setText");
    }

    @Override
    public void setNull(int index, int oid) throws SQLException {
        this.bind(index, ParameterFactory.getNullObject(), oid);
    }

    @Override
    public void setRowIdParameter(int index, RowId value) throws SQLException {
        this.bind(index, value, 32);
    }

    @Override
    public void registerOutParameter(int index, int yashanDataType) throws SQLException {
        this.checkParameterIndex(index);
        if (this.yasParameters[--index] == null) {
            YasParameter parameter;
            this.yasParameters[index] = parameter = this.parameterFactory.getParameter(yashanDataType);
        }
        this.yasParameters[index].setType(yashanDataType);
        this.yasParameters[index].setOutDirection();
    }

    @Override
    public String toString(int index, boolean standardConformingStrings) {
        if (this.yasParameters[--index] == null) {
            return "?";
        }
        if (this.yasParameters[index].isValueNull()) {
            return "NULL";
        }
        String param = this.yasParameters[index].getValue().toString();
        StringBuilder p = new StringBuilder(3 + (param.length() + 10) / 10 * 11);
        p.append('\'');
        try {
            p = Utils.escapeLiteral(p, param, standardConformingStrings);
        }
        catch (SQLException sqle) {
            p.append(param);
        }
        p.append('\'');
        int paramType = this.yasParameters[index].getType();
        if (paramType == 16) {
            p.append("::timestamp");
        } else if (paramType == 17) {
            p.append("::timestamp with time zone");
        } else if (paramType == 13) {
            p.append("::date");
        } else if (paramType == 12) {
            p.append("::numeric");
        }
        return p.toString();
    }

    public int getLength(int index) throws SQLException {
        return this.yasParameters[--index].getLength();
    }

    int writeValue(int index, Packet packet) throws SQLException {
        return this.yasParameters[--index].writeValue(packet);
    }

    public SimpleParameterList clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        SimpleParameterList cloneParameterList = (SimpleParameterList)clone;
        if (this.yasParameters != null) {
            cloneParameterList.yasParameters = (YasParameter[])this.yasParameters.clone();
            for (int i = 0; i < this.yasParameters.length; ++i) {
                cloneParameterList.yasParameters[i] = this.yasParameters[i].clone();
            }
        }
        return cloneParameterList;
    }

    private void checkParameterList() throws SQLException {
        if (this.yasParameters == null) {
            return;
        }
        for (int i = 0; i < this.yasParameters.length; ++i) {
            if (this.yasParameters[i] != null) continue;
            throw SQLError.createSQLException(Messages.get("Parameter is missing,index: {0}", i + 1), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public ParameterList copy() throws SQLException {
        this.checkParameterList();
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.yasParameters, null);
        this.pos = 0;
    }

    @Override
    public YasParameter[] getParameters() {
        return this.yasParameters;
    }

    @Override
    public void appendAll(ParameterList list) throws SQLException {
        if (list instanceof SimpleParameterList) {
            SimpleParameterList spl = (SimpleParameterList)list;
            int inParamCount = spl.getInParameterCount();
            if (this.pos + inParamCount > this.yasParameters.length) {
                throw SQLError.createSQLException(Messages.get("Added parameters index out of range: {0}, number of columns: {1}.", this.pos + inParamCount, this.yasParameters.length), YasState.INVALID_PARAMETER_VALUE);
            }
            try {
                for (YasParameter parameter : list.getParameters()) {
                    this.yasParameters[this.pos] = parameter.clone();
                    ++this.pos;
                }
            }
            catch (CloneNotSupportedException exception) {
                throw new SQLException(exception.getMessage());
            }
        }
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("<[");
        if (this.yasParameters.length > 0) {
            ts.append(this.toString(1, true));
            for (int c = 2; c <= this.yasParameters.length; ++c) {
                ts.append(" ,").append(this.toString(c, true));
            }
        }
        ts.append("]>");
        return ts.toString();
    }
}

