/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.conf;

import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.Messages;
import com.yashandb.util.URLCoder;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;

public class ConnectionUrl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUrl.class.getName());
    private final Properties props;
    private final String url;
    private final String serverType;

    public static boolean acceptsUrl(String connString) throws SQLException {
        if (connString == null) {
            throw new SQLException("url is null");
        }
        return ConnectionUrl.parseURL(connString, null) != null;
    }

    public static Properties parseURL(String url, Properties defaults) throws SQLException {
        String[] args;
        Properties urlProps = new Properties(defaults);
        String urlServer = url;
        String urlArgs = "";
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlServer = url.substring(0, qPos);
            urlArgs = url.substring(qPos + 1);
        }
        if (!urlServer.startsWith("jdbc:yasdb:")) {
            LOGGER.debug("JDBC URL must start with \"jdbc:yasdb:\" but was: {}", (Object)url);
            return null;
        }
        if ((urlServer = urlServer.substring("jdbc:yasdb:".length())).contains("://")) {
            int serverEndIndex = urlServer.indexOf(58);
            String serverType = urlServer.substring(0, serverEndIndex);
            urlProps.setProperty("SERVER_TYPE", serverType);
            urlServer = urlServer.substring(serverEndIndex + 1);
        }
        if (urlServer.startsWith("//")) {
            int slash = (urlServer = urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                LOGGER.warn("JDBC URL must contain a / at the end of the host or port: {}", (Object)url);
                return null;
            }
            urlProps.setProperty("DBNAME", URLCoder.decode(urlServer.substring(slash + 1)));
            String[] addresses = urlServer.substring(0, slash).split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                String portStr;
                int portIdx;
                block14: {
                    portIdx = address.lastIndexOf(58);
                    if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                        portStr = address.substring(portIdx + 1);
                        try {
                            int port = Integer.parseInt(portStr);
                            if (port < 1 || port > 65535) {
                                LOGGER.warn("JDBC URL port: {0} not valid (1:65535) ", (Object)portStr);
                                return null;
                            }
                            break block14;
                        }
                        catch (NumberFormatException ignore) {
                            LOGGER.warn("JDBC URL invalid port number: {0}", (Object)portStr);
                            return null;
                        }
                    }
                    LOGGER.error("JDBC URL has invalid port number");
                    throw SQLError.createSQLException(Messages.get("JDBC URL has invalid port number, url: {0}", url), YasState.INVALID_PARAMETER_VALUE);
                }
                ports.append(portStr);
                hosts.append(address.subSequence(0, portIdx));
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty("PORT", ports.toString());
            urlProps.setProperty("HOST", hosts.toString());
        } else if (defaults == null || !defaults.containsKey("DBNAME")) {
            urlProps.setProperty("DBNAME", URLCoder.decode(urlServer));
        }
        for (String token : args = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, pos), URLCoder.decode(token.substring(pos + 1)));
        }
        return urlProps;
    }

    public static ConnectionUrl getInstance(String url, Properties info) throws SQLException {
        Properties props = new Properties();
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw SQLError.createSQLException(Messages.get("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, YasState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if ((props = ConnectionUrl.parseURL(url, props)) == null) {
            return null;
        }
        String serverType = props.getProperty("SERVER_TYPE");
        if (serverType == null || serverType.isEmpty()) {
            serverType = "primary";
        }
        return new ConnectionUrl(url, props, serverType);
    }

    public Properties getProps() {
        return this.props;
    }

    public String getUrl() {
        return this.url;
    }

    public String getServerType() {
        return this.serverType;
    }

    private ConnectionUrl(String url, Properties props, String serverType) {
        this.props = props;
        this.url = url;
        this.serverType = serverType;
    }

    public HostSpec[] hostSpecs() {
        String hostsStr = this.props.getProperty("HOST");
        String portsStr = this.props.getProperty("PORT");
        if (hostsStr == null || portsStr == null) {
            return null;
        }
        String[] hosts = hostsStr.split(",");
        String[] ports = portsStr.split(",");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    public String user() {
        return this.props.getProperty("user", "");
    }

    public String database() {
        return this.props.getProperty("DBNAME", "");
    }
}

