/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.conf;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import java.sql.DriverPropertyInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public enum YasProperty {
    PASSWORD("password", null, "Password to use when authenticating.", false),
    USER("user", null, "Username to connect to the database as.", true),
    HOST("HOST", null, "Hostname of the YashanDB server (may be specified directly in the JDBC URL)", false),
    PORT("PORT", null, "Port of the YashanDB server (may be specified directly in the JDBC URL)"),
    PROGRAM_NAME("ProgramName", "YashanDB JDBC Driver", "The fully qualified path for the file that contains the specified module"),
    DEFAULT_ROW_FETCH_SIZE("defaultRowFetchSize", "10", "Positive number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration"),
    LOGGER_FILE("loggerFile", null, "File name output of the Logger"),
    LOGGER_LEVEL("loggerLevel", null, "Logger level of the driver", false, new String[]{"OFF", "DEBUG", "TRACE"}),
    LOG_SERVER_ERROR_DETAIL("logServerErrorDetail", "true", "Include full server error detail in exception messages. If disabled then only the error itself will be included."),
    LOG_UNCLOSED_CONNECTIONS("logUnclosedConnections", "false", "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source"),
    CANCEL_SIGNAL_TIMEOUT("cancelSignalTimeout", "10", "The timeout that is used for sending cancel command."),
    CONNECT_TIMEOUT("connectTimeout", "10", "The timeout value used for socket connect operations."),
    LOGIN_TIMEOUT("loginTimeout", "300", "Specify how long to wait for establishment of a database connection."),
    SOCKET_TIMEOUT("socketTimeout", "0", "The timeout value used for socket read operations."),
    SERVER_MODE("serverMode", "shared", "Dedicated or Shared server mode."),
    POOL_TIMEOUT("poolTimeout", "300", "The timeout value used for connect primary host using configured ips"),
    RECEIVE_BUFFER_SIZE("receiveBufferSize", "-1", "Socket read buffer size"),
    SEND_BUFFER_SIZE("sendBufferSize", "-1", "Socket write buffer size"),
    SSL_ROOT_CER("sslRootCer", "", "Certificate Root Path", false),
    TCP_KEEP_ALIVE("tcpKeepAlive", "true", "Enable or disable TCP keep-alive. The default is {@code true}."),
    FAILOVER("failover", "OFF", "Enable or disable Transpant Application Failover", false, new String[]{"ON", "OFF"}),
    FAILOVER_TYPE("failoverType", "NONE", "Transparent Application Failover type", false, new String[]{"NONE", "SELECT", "SESSION"}),
    FAILOVER_METHOD("failoverMethod", "BASIC", "Transparent Application Failover method", false, new String[]{"BASIC", "PRECONNECT"}),
    FAILOVER_RETRIES("failoverRetries", "5", "Transparent Application Failover number of reconnect attempts"),
    FAILOVER_DELAY("failoverDelay", "1", "Transparent Application Failover try reconnect interval"),
    CLIENT_PREPARE("clientPrepare", "false", "Enable or disable directExecute with bind parameters. The default is {@code false}.If disabled, the client will firstly send prepare sql, then send bind parameters, otherwise send them together to server.");

    private final String name;
    private final String defaultValue;
    private final boolean required;
    private final String description;
    private final String[] choices;
    private final boolean deprecated;
    private static final Map<String, YasProperty> PROPS_BY_NAME;

    private YasProperty(String name, String defaultValue, String description) {
        this(name, defaultValue, description, false);
    }

    private YasProperty(String name, String defaultValue, String description, boolean required) {
        this(name, defaultValue, description, required, null);
    }

    private YasProperty(String name, String defaultValue, String description, boolean required, String[] choices) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.required = required;
        this.description = description;
        this.choices = choices;
        try {
            this.deprecated = YasProperty.class.getField(this.name()).getAnnotation(Deprecated.class) != null;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String get(Properties properties) {
        return properties.getProperty(this.name, this.defaultValue);
    }

    public void set(Properties properties, String value) {
        if (value == null) {
            properties.remove(this.name);
        } else {
            properties.setProperty(this.name, value);
        }
    }

    public boolean getBoolean(Properties properties) {
        return Boolean.valueOf(this.get(properties));
    }

    public int getInt(Properties properties) throws YasException {
        String value = this.get(properties);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.get("{0} parameter value must be an integer but was: {1}", this.getName(), value), YasState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public void set(Properties properties, boolean value) {
        properties.setProperty(this.name, Boolean.toString(value));
    }

    public void set(Properties properties, int value) {
        properties.setProperty(this.name, Integer.toString(value));
    }

    public boolean isPresent(Properties properties) {
        return this.getSetString(properties) != null;
    }

    public DriverPropertyInfo toDriverPropertyInfo(Properties properties) {
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(this.name, this.get(properties));
        propertyInfo.required = this.required;
        propertyInfo.description = this.description;
        propertyInfo.choices = this.choices;
        return propertyInfo;
    }

    public String getSetString(Properties properties) {
        Object o = properties.get(this.name);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    static {
        PROPS_BY_NAME = new HashMap<String, YasProperty>();
        for (YasProperty prop : YasProperty.values()) {
            if (PROPS_BY_NAME.put(prop.getName(), prop) == null) continue;
            throw new IllegalStateException("Duplicate YasProperty name: " + prop.getName());
        }
    }
}

