/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.core;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DataType {
    public static final int UNKNOWN = 0;
    public static final int BOOLEAN = 1;
    public static final int TINYINT = 2;
    public static final int SMALLINT = 3;
    public static final int INTEGER = 4;
    public static final int BIGINT = 5;
    public static final int UTINYINT = 6;
    public static final int USMALLINT = 7;
    public static final int UINTEGER = 8;
    public static final int UBIGINT = 9;
    public static final int FLOAT = 10;
    public static final int DOUBLE = 11;
    public static final int NUMBER = 12;
    public static final int DATE = 13;
    public static final int SHORTDATE = 14;
    public static final int SHORTTIME = 15;
    public static final int TIMESTAMP = 16;
    public static final int TIMESTAMP_TZ = 17;
    public static final int TIMESTAMP_LTZ = 18;
    public static final int YM_INTERVAL = 19;
    public static final int DS_INTERVAL = 20;
    public static final int CHAR = 24;
    public static final int NCHAR = 25;
    public static final int VARCHAR = 26;
    public static final int NVARCHAR = 27;
    public static final int RAW = 28;
    public static final int CLOB = 29;
    public static final int BLOB = 30;
    public static final int BIT = 31;
    public static final int ROWID = 32;
    public static final int NCLOB = 33;
    public static final int CURSOR = 34;
    public static final int JSON = 35;
    public static final int RECORD = 247;
    private static final Map<Integer, String> TYPE_TO_NAME = new HashMap<Integer, String>(100);
    private static final Map<String, Integer> NAME_TO_TYPE = new HashMap<String, Integer>(100);

    public static String getTypeName(int oid) {
        String name = TYPE_TO_NAME.get(oid);
        if (name == null) {
            name = "<unknown:" + oid + ">";
        }
        return name;
    }

    public static int getTypeId(String type) throws YasException {
        if (type.length() > 0 && !Character.isDigit(type.charAt(0))) {
            Integer id = NAME_TO_TYPE.get(type);
            if (id == null) {
                id = NAME_TO_TYPE.get(type.toUpperCase());
            }
            if (id != null) {
                return id;
            }
        } else {
            try {
                return (int)Long.parseLong(type);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw SQLError.createSQLException(Messages.get("YashanDB type {0} not known and not a number", type), YasState.INVALID_PARAMETER_VALUE);
    }

    public static int getSQLType(int yasType) {
        return YasTypes.getSQLType(yasType);
    }

    static {
        for (Field field : DataType.class.getFields()) {
            try {
                int type = field.getInt(null);
                String name = field.getName().toUpperCase();
                TYPE_TO_NAME.put(type, name);
                NAME_TO_TYPE.put(name, type);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        TYPE_TO_NAME.put(15, "TIME");
        NAME_TO_TYPE.put("TIME", 15);
    }
}

