/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.core;

public enum SqlKind {
    SELECT(false, false, true, false, 1),
    INSERT(false, true, false, false, 2),
    UPDATE(false, true, false, false, 3),
    DELETE(false, true, false, false, 4),
    MERGE(false, true, false, false, 5),
    PLSQL_BLOCK(true, false, false, false, 7),
    CALL_BLOCK(true, false, false, false, 7),
    OTHER(false, false, false, true, -128),
    UNINITIALIZED(false, false, false, false, 0);

    private final boolean dml;
    private final boolean plsqlOrCall;
    private final boolean select;
    private final boolean other;
    private final byte kind;

    private SqlKind(boolean plsql, boolean dml, boolean select, boolean other, byte kind) {
        this.dml = dml;
        this.plsqlOrCall = plsql;
        this.select = select;
        this.other = other;
        this.kind = kind;
    }

    public static SqlKind valueOf(byte kind) {
        switch (kind) {
            case 1: {
                return SELECT;
            }
            case 2: {
                return INSERT;
            }
            case 3: {
                return UPDATE;
            }
            case 4: {
                return DELETE;
            }
            case 5: {
                return MERGE;
            }
            case 7: {
                return PLSQL_BLOCK;
            }
            case 0: {
                return UNINITIALIZED;
            }
        }
        return OTHER;
    }

    public boolean isPlsqlOrCall() {
        return this.plsqlOrCall;
    }

    public boolean isDML() {
        return this.dml;
    }

    public boolean isSELECT() {
        return this.select;
    }

    public boolean isOTHER() {
        return this.other;
    }

    public byte getKind() {
        return this.kind;
    }
}

