/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

public enum ConnectVersion {
    VER1("VER1", 0x1000001),
    VER2("VER2", 0x1000002),
    UNINITIALIZED("uninitialized", 0x1000000);

    private final String verName;
    private final int verNumber;

    private ConnectVersion(String verName, int verNumber) {
        this.verName = verName;
        this.verNumber = verNumber;
    }

    public static ConnectVersion valueOf(int versionNum) {
        switch (versionNum) {
            case 0x1000001: {
                return VER1;
            }
            case 0x1000002: {
                return VER2;
            }
        }
        return UNINITIALIZED;
    }

    public int getValue() {
        return this.verNumber;
    }

    public String getName() {
        return this.verName;
    }

    public static ConnectVersion getMaxConnectVersion() {
        return VER2;
    }
}

