/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.Session;
import com.yashandb.SessionImpl;
import com.yashandb.conf.ConnectionUrl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.PreparedStatementImpl;
import com.yashandb.jdbc.ReturnColumnResultSetMetaData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.TransactionState;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasCallableStatement;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasDatabaseMetaData;
import com.yashandb.jdbc.YasDebugCallableStatement;
import com.yashandb.jdbc.YasFailover;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.Messages;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.Executor;

public class ConnectionImpl
implements YasConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionImpl.class);
    private Session session;
    private int rsHoldability = 1;
    private boolean autoCommit = true;
    private SQLWarning firstWarning = null;
    protected DatabaseMetaData metadata;
    protected int defaultFetchSize;
    private final String creatingURL;
    private String serverType;
    private volatile Timer timer;
    protected Map<String, Class<?>> typemap = new HashMap();
    private static final SQLPermission SQL_PERMISSION_ABORT = new SQLPermission("callAbort");
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");
    private int isolationLevel = 2;
    private boolean readOnly = false;
    private boolean clientPrepare = false;

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public synchronized Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("YashanDB Connection Timer", true);
        }
        return this.timer;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
        LOGGER.debug(" setAutoCommit = {}", (Object)autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw SQLError.createSQLException(Messages.get("Cannot commit when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.session.getTransactionState() != TransactionState.XACT_END) {
            this.session.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw SQLError.createSQLException(Messages.get("Cannot rollback when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        this.session.rollback();
    }

    @Override
    public YasDebugCallableStatement createDebugStatement(String sql, long objectId, int subprogramId, int version) throws SQLException {
        this.checkClosed();
        if (sql == null || sql.trim().isEmpty()) {
            throw new SQLException("SQL String cannot be NULL or empty");
        }
        sql = sql.trim();
        return new YasDebugCallableStatement(this, sql, 1003, 1007, this.getHoldability(), objectId, subprogramId, version);
    }

    @Override
    public void close() throws SQLException {
        if (this.session == null || this.session.isClosed()) {
            return;
        }
        this.session.abortDebug();
        this.session.close();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.session.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new YasDatabaseMetaData(this);
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.getTransactionState() != TransactionState.IDLE && this.getTransactionState() != TransactionState.XACT_END) {
                throw SQLError.createSQLException(Messages.get("The readOnly cannot be changed during a transaction.", new Object[0]), YasState.ACTIVE_SQL_TRANSACTION);
            }
            this.readOnly = readOnly;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.session.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.session.getTransactionState() != TransactionState.XACT_END) {
            throw SQLError.createSQLException(Messages.get("Cannot change transaction isolation level in the middle of a transaction.", new Object[0]), YasState.ACTIVE_SQL_TRANSACTION);
        }
        if (level != 2 && level != 8) {
            throw SQLError.createSQLException(Messages.get("Only READ_COMMITTED and SERIALIZABLE are valid transaction isolation level", new Object[0]), YasState.DATA_ERROR);
        }
        this.session.setTransactionIsolation(level);
        LOGGER.debug("setTransactionIsolation = {}", (Object)level);
        this.isolationLevel = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.isolationLevel;
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        SQLWarning newWarnings = this.session.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.session.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        if (this.typemap == null) {
            this.typemap = new HashMap();
        }
        return this.typemap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        this.typemap = map;
        LOGGER.debug("setTypeMap = {}", (Object)map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 2: {
                this.rsHoldability = holdability;
                break;
            }
            case 1: {
                this.rsHoldability = holdability;
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Unknown ResultSet holdability setting: {0}.", holdability), YasState.INVALID_PARAMETER_VALUE);
            }
        }
        LOGGER.debug("setHoldability = {}", (Object)holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            LOGGER.error("Can not set savepoint when autoCommit is enabled.");
            throw SQLError.createSQLException(Messages.get("Can not set savepoint when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return this.session.setSavepoint();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            LOGGER.error("Can not set savepoint when autoCommit is enabled.");
            throw SQLError.createSQLException(Messages.get("Can not set savepoint when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return this.session.setSavepoint(name);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            LOGGER.error("Can not rollback savepoint when autoCommit is enabled.");
            throw SQLError.createSQLException(Messages.get("Can not rollback savepoint when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (savepoint == null) {
            return;
        }
        this.session.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "releaseSavepoint");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new StatementImpl(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        if (sql == null || sql.trim().isEmpty()) {
            throw new SQLException("SQL String cannot be NULL or empty");
        }
        sql = sql.trim();
        return new PreparedStatementImpl(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        if (sql == null || sql.trim().isEmpty()) {
            throw new SQLException("SQL String cannot be NULL or empty");
        }
        sql = sql.trim();
        return new YasCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        ReturnColumnResultSetMetaData autoKey = new ReturnColumnResultSetMetaData(sql);
        if (autoGeneratedKeys != 2 && autoKey.isInsert()) {
            if (autoGeneratedKeys == 1) {
                PreparedStatementImpl stmt = (PreparedStatementImpl)this.prepareStatement(autoKey.getNewSql());
                stmt.returnColRsMetaData = autoKey;
                stmt.autoGeneratedKeys = true;
                stmt.returnParamCount = 1;
                stmt.registerReturnParamsForAutoKey();
                return stmt;
            }
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        ReturnColumnResultSetMetaData autoKey = new ReturnColumnResultSetMetaData(sql, columnIndexes);
        if (!autoKey.isInsert()) {
            return this.prepareStatement(sql);
        }
        if (columnIndexes != null && columnIndexes.length != 0) {
            this.doDescribeTable(autoKey);
            PreparedStatementImpl stmt = (PreparedStatementImpl)this.prepareStatement(autoKey.getNewSql());
            stmt.returnColRsMetaData = autoKey;
            stmt.autoGeneratedKeys = true;
            stmt.returnParamCount = columnIndexes.length;
            stmt.registerReturnParamsForAutoKey();
            return stmt;
        }
        throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        ReturnColumnResultSetMetaData autoKey = new ReturnColumnResultSetMetaData(sql, columnNames);
        if (!autoKey.isInsert()) {
            return this.prepareStatement(sql);
        }
        if (columnNames != null && columnNames.length != 0) {
            this.doDescribeTable(autoKey);
            PreparedStatementImpl stmt = (PreparedStatementImpl)this.prepareStatement(autoKey.getNewSql());
            stmt.returnColRsMetaData = autoKey;
            stmt.autoGeneratedKeys = true;
            stmt.returnParamCount = columnNames.length;
            stmt.registerReturnParamsForAutoKey();
            return stmt;
        }
        throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public void doDescribeTable(ReturnColumnResultSetMetaData autoKeys) throws SQLException {
        String tableName = autoKeys.getTableName().trim();
        String[] nameList = tableName.split("\\.");
        if (nameList.length != 1 && nameList.length != 2) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Integer> lens = new ArrayList<Integer>();
        ArrayList<Boolean> nullables = new ArrayList<Boolean>();
        ArrayList<Integer> precs = new ArrayList<Integer>();
        ArrayList<Integer> scales = new ArrayList<Integer>();
        int colCount = 0;
        String sql = "select * from " + tableName + " where 1=0";
        try (Statement statement = this.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            Field[] fields = ((StatementImpl)statement).getFields();
            colCount = fields.length;
            for (int i = 0; i < fields.length; ++i) {
                names.add(fields[i].getName());
                types.add(fields[i].getYasType());
                lens.add(fields[i].getSize());
                nullables.add(fields[i].getNullable() == 1);
                precs.add(fields[i].getPrecision());
                scales.add(fields[i].getScale());
            }
            resultSet.close();
        }
        autoKeys.initDescribedData(colCount, names, types, lens, nullables, precs, scales);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        YasClob clob = this.session.createClob();
        return clob;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        YasBlob blob = this.session.createBlob();
        return blob;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "createSQLXML()");
    }

    private synchronized int checkConnectValid(int timeout) {
        try {
            try (Statement statement = this.createStatement();){
                statement.setQueryTimeout(timeout);
                statement.executeQuery("select 'x' from dual");
            }
            return 0;
        }
        catch (SQLException sqlException) {
            return -1;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("isValid timeout cannot be negative.");
        }
        if (this.isClosed()) {
            return false;
        }
        return this.checkConnectValid(timeout) == 0;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getClientInfo()");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getClientInfo()");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "createArrayOf()");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "createStruct(String, Object[])");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        if (schema == null || schema.isEmpty()) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        this.session.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.session.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("executor is null");
        }
        if (this.isClosed()) {
            return;
        }
        SQL_PERMISSION_ABORT.checkGuard(this);
        this.session.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        if (milliseconds < 0) {
            throw SQLError.createSQLException(Messages.get("Network timeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT);
        }
        try {
            this.session.setNetworkTimeout(milliseconds);
        }
        catch (IOException ioe) {
            throw SQLError.createSQLException(Messages.get("Unable to set network timeout.", new Object[0]), YasState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        try {
            return this.session.getNetworkTimeout();
        }
        catch (IOException ioe) {
            throw SQLError.createSQLException(Messages.get("Unable to get network timeout.", new Object[0]), YasState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Map<String, String> getParameterStatuses() {
        return this.session.getParameterStatuses();
    }

    @Override
    public String getParameterStatus(String parameterName) {
        return this.session.getParameterStatus(parameterName);
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.checkClosed();
        this.session.cancel();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        return str.getBytes();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.session.getStandardConformingStrings();
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public TransactionState getTransactionState() {
        return this.session.getTransactionState();
    }

    @Override
    public String getServerType() {
        return this.serverType;
    }

    @Override
    public boolean getClientPrepare() {
        return this.clientPrepare;
    }

    @Override
    public void setClientPrepare(boolean clientPrepare) {
        this.clientPrepare = clientPrepare;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public String getURL() {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.session.getUser();
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            throw SQLError.createSQLException(Messages.get("Fetch size must be a value greater to or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSize = fetchSize;
        LOGGER.debug("setDefaultFetchSize = {}", (Object)fetchSize);
    }

    private ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    private ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        YasStatement stat = (YasStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeInternal(s);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw SQLError.createSQLException(Messages.get("No results were returned by the query.", new Object[0]), YasState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    private ConnectionImpl(ConnectionUrl connectionUrl) throws SQLException {
        HostSpec[] hostSpecs = connectionUrl.hostSpecs();
        if (hostSpecs == null) {
            throw SQLError.createSQLException(Messages.get("Invalid JDBC URL: {0}", connectionUrl.getUrl()), YasState.INVALID_PARAMETER_VALUE);
        }
        String user = connectionUrl.user();
        String database = connectionUrl.database();
        Properties info = connectionUrl.getProps();
        LOGGER.debug("YashanDB JDBC Driver 1.4.12");
        this.creatingURL = connectionUrl.getUrl();
        this.serverType = connectionUrl.getServerType();
        this.setDefaultFetchSize(YasProperty.DEFAULT_ROW_FETCH_SIZE.getInt(info));
        try {
            this.clientPrepare = YasProperty.CLIENT_PREPARE.getBoolean(info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = new SessionImpl(this, hostSpecs, user, info);
        this.session.initFailoverProcessor();
        try {
            this.session.connect();
        }
        catch (SQLException e) {
            if (e.getMessage().contains("YAS-00410 protocol error, invalid login packet") && this.session.getConnectVersion() != ConnectVersion.VER1) {
                this.session.setConnectVersion(ConnectVersion.VER1);
                this.session.connect();
            }
            throw e;
        }
    }

    public Object cloneForMonitor() throws CloneNotSupportedException {
        ConnectionImpl cloneConnection = (ConnectionImpl)super.clone();
        cloneConnection.autoCommit = false;
        cloneConnection.session = (Session)((SessionImpl)this.session).cloneForMonitor();
        cloneConnection.session.setConnection(cloneConnection);
        return cloneConnection;
    }

    public static Connection getInstance(ConnectionUrl connectionUrl) throws SQLException {
        return new ConnectionImpl(connectionUrl);
    }

    @Override
    public synchronized void registerTAFCallback(YasFailover yasFailover, Object ctxt) throws SQLException {
        this.session.registerTAFCallback(yasFailover, ctxt);
    }
}

