/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.YasDriver;
import java.net.URL;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Driver
extends YasDriver
implements java.sql.Driver {
    private static Driver registeredDriver;

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (!Driver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    public static void main(String[] args) {
        URL url = Driver.class.getResource("/com/yashandb/jdbc/Driver.class");
        System.out.printf("%n%s%n", "YashanDB JDBC Driver 1.4.12");
        System.out.printf("Found in: %s%n%n", url);
        System.out.printf("The YashanDB driver is not an executable Java program.%n%nYou must install it according to the JDBC driver installation instructions for your application / container / appserver, then use it by specifying a JDBC URL of the form %n    jdbc:yasdb:@%nor using an application specific method.%n%nThis command has had no effect.%n", new Object[0]);
        System.exit(1);
    }

    static {
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

