/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.CancelQueryTask;
import com.yashandb.ParameterList;
import com.yashandb.SimpleParameterList;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasParameterMetaData;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.TypeConverter;
import com.yashandb.util.ByteStreamWriter;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import com.yashandb.util.YasEscapeProcessor;
import com.yashandb.util.YasSQL;
import com.yashandb.util.YasTime;
import com.yashandb.util.YasTimestamp;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement {
    private YasParameterMetaData parameterMetaData;
    protected String preparedSQL;
    private boolean clientPrepare = false;

    PreparedStatementImpl(ConnectionImpl connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, rsType, rsConcurrency, rsHoldability);
        this.setPoolable(true);
        this.preparedSQL = YasEscapeProcessor.process(sql);
        if (this.resultsetConcurrency == 1008 || this.resultsetType == 1005) {
            this.yasSQL = this.buildYasSQL(this.preparedSQL);
            if (this.yasSQL.canUpdatable() || this.yasSQL.canScrollSensitive()) {
                this.preparedSQL = this.yasSQL.getRowIDAppendSQL();
            }
        }
        this.clientPrepare = this.connection.getClientPrepare();
        if (this.clientPrepare && !(this instanceof CallableStatement)) {
            this.hasPrepared = false;
            this.clientPrepare();
            return;
        }
        this.serverPrepare(this.preparedSQL);
    }

    void clientPrepare() throws SQLException {
        int parameterCount;
        YasSQL tempYasSql = this.yasSQL;
        if (tempYasSql == null) {
            tempYasSql = new YasSQL(this.preparedSQL);
        }
        if ((parameterCount = tempYasSql.getParameterCount()) <= 0) {
            return;
        }
        if (parameterCount >= 32000) {
            throw SQLError.createSQLException("bind param count size exceeding limit 32000", YasState.UNKNOWN_STATE);
        }
        this.preparedParameters = new SimpleParameterList(parameterCount);
        this.preparedParameters.setCharset(this.getSession().getCharset());
        this.preparedParameters.setnCharset(this.getSession().getnCharset());
    }

    protected void serverPrepare(String sql) throws SQLException {
        this.connection.getSession().prepare(this, sql);
        this.hasPrepared = true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal(0);
        return this.getQueryResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeInternal(4);
        return this.getExecuteUpdateResult();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal(4);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(int flags) throws SQLException {
        ParameterList[] parameterLists = null;
        if (this.preparedParameters != null) {
            parameterLists = new ParameterList[]{this.preparedParameters};
        }
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.checkClosed();
            this.closeForNextExecution();
            if (this.timeout > 0L) {
                CancelQueryTask cancelQueryTask = null;
                try {
                    cancelQueryTask = this.startTimer();
                    if (!this.hasPrepared) {
                        this.currentResultSet = this.connection.getSession().directExecute(this, this.preparedSQL, parameterLists);
                        this.hasPrepared = true;
                    }
                    this.currentResultSet = this.connection.getSession().execute(this, parameterLists, 0, 0, 0);
                }
                finally {
                    this.killTimerTask(cancelQueryTask);
                }
            } else if (!this.hasPrepared) {
                this.currentResultSet = this.connection.getSession().directExecute(this, this.preparedSQL, parameterLists);
                this.hasPrepared = true;
            } else {
                this.currentResultSet = this.connection.getSession().execute(this, parameterLists, 0, 0, 0);
            }
            return this.currentResultSet.reallyResult();
        }
    }

    @Override
    protected void checkIfBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            throw SQLError.createSQLException("batch must be either executed or cleared", YasState.UNEXPECTED_ERROR);
        }
        super.checkIfBatchExists();
    }

    public int getBatchSize() {
        if (this.batchParameters == null) {
            return 0;
        }
        return this.batchParameters.size();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.getParameters().getParameterCount()) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.getParameters().getParameterCount()), YasState.INVALID_PARAMETER_VALUE);
        }
        int yashanType = YasTypes.getYasType(sqlType);
        this.getParameters().setNull(parameterIndex, yashanType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(parameterIndex, x ? 1L : 0L, 1);
    }

    public void setBit(int parameterIndex, Object x) throws SQLException {
        block7: {
            this.checkClosed();
            try {
                if (x == null) {
                    this.setNull(parameterIndex, -7);
                    break block7;
                }
                if (x instanceof Boolean) {
                    byte[] bits = new byte[]{(byte)((Boolean)x != false ? 1 : 0)};
                    this.getParameters().setBinaryParameter(parameterIndex, bits, 31);
                    break block7;
                }
                if (x instanceof byte[]) {
                    this.getParameters().setBinaryParameter(parameterIndex, (byte[])x, 31);
                    break block7;
                }
                if (x instanceof String) {
                    this.setLong(parameterIndex, Long.parseLong((String)x));
                    break block7;
                }
                if (x instanceof Number) {
                    this.setLong(parameterIndex, ((Number)x).longValue());
                    break block7;
                }
                throw SQLError.TransformException(x.getClass().getName(), "Bit");
            }
            catch (Exception e) {
                throw SQLError.TransformException(x.getClass().getName(), "Bit", e);
            }
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(parameterIndex, x, 2);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(parameterIndex, x, 3);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(parameterIndex, x, 4);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(parameterIndex, x, 5);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.getParameters().setFloatParameter(parameterIndex, x, 10);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.getParameters().setDoubleParameter(parameterIndex, x, 11);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setNumber(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.getParameters().setNull(parameterIndex, 26);
        } else {
            this.bindString(parameterIndex, x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (null == x || x.length == 0) {
            this.getParameters().setNull(parameterIndex, 28);
            return;
        }
        byte[] copy = new byte[x.length];
        System.arraycopy(x, 0, copy, 0, x.length);
        this.getParameters().setBytea(parameterIndex, copy, 0, x.length);
    }

    private void setByteStreamWriter(int parameterIndex, ByteStreamWriter x) throws SQLException {
        this.getParameters().setBytea(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getParameters().setDateParameter(parameterIndex, x, 13);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getParameters().setTimeParameter(parameterIndex, x, 15);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getParameters().setTimeStampParameter(parameterIndex, x, 16);
    }

    private void setDsInterval(int parameterIndex, long interval) throws SQLException {
        this.getParameters().setDsIntervalParameter(parameterIndex, interval, 20);
    }

    private void setYmInterval(int parameterIndex, int interval) throws SQLException {
        this.getParameters().setYmIntervalParameter(parameterIndex, interval, 19);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream()");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setUnicodeStream()");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.checkClosed();
        if (length < 0) {
            throw SQLError.createSQLException(Messages.get("Invalid stream length {0}.", length), YasState.INVALID_PARAMETER_VALUE);
        }
        if (inputStream == null || length == 0) {
            this.getParameters().setNull(parameterIndex, 28);
            return;
        }
        this.getParameters().setBytea(parameterIndex, inputStream, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        if (this.preparedParameters != null) {
            this.preparedParameters.clear();
        }
        if (this.autoGeneratedKeys) {
            this.registerReturnParamsForAutoKey();
        }
    }

    private void setMap(int parameterIndex, Map<?, ?> x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setMap");
    }

    private void setNumber(int parameterIndex, Number x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.getParameters().setNumberParameter(parameterIndex, x, 12);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -6: 
            case 4: 
            case 5: {
                this.setInt(parameterIndex, TypeConverter.castToInt(in, targetSqlType));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, TypeConverter.castToLong(in, targetSqlType));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, TypeConverter.castToFloat(in, targetSqlType));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, TypeConverter.castToDouble(in, targetSqlType));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, TypeConverter.castToBigDecimal(in, scale, targetSqlType));
                break;
            }
            case 16: {
                this.setBoolean(parameterIndex, TypeConverter.castToBoolean(in));
                break;
            }
            case -7: {
                this.setBit(parameterIndex, in);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 3009: {
                this.setString(parameterIndex, TypeConverter.castToString(in, targetSqlType, scale));
                break;
            }
            case 91: {
                this.setDate(parameterIndex, TypeConverter.castToDate(in));
                break;
            }
            case 92: {
                this.setTime(parameterIndex, TypeConverter.castToTime(in));
                break;
            }
            case 2013: {
                this.setTimeWithTimezone(parameterIndex, in);
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, TypeConverter.castToTimeStamp(in));
                break;
            }
            case 2014: {
                this.setTimestampWithTimezone(parameterIndex, in);
                break;
            }
            case 3002: {
                this.setDsInterval(parameterIndex, TypeConverter.castToDsInterval(in));
                break;
            }
            case 3001: {
                this.setYmInterval(parameterIndex, TypeConverter.castToYmInterval(in));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBinary(parameterIndex, in, targetSqlType, scale);
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                this.setNString(parameterIndex, (String)in);
                break;
            }
            case 2004: {
                this.setBlob(parameterIndex, in);
                break;
            }
            case 2005: {
                this.setClob(parameterIndex, in);
                break;
            }
            case 2003: {
                this.setArray(parameterIndex, in);
                break;
            }
            case 2006: {
                this.setRef(parameterIndex, in);
                break;
            }
            case 70: {
                this.setURL(parameterIndex, in);
                break;
            }
            case 2011: {
                this.setNClob(parameterIndex, in);
                break;
            }
            case 2009: {
                this.setSQLXML(parameterIndex, in);
                break;
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString());
                break;
            }
            case -8: {
                this.setRowId(parameterIndex, in);
                break;
            }
            case 1111: {
                if (in instanceof Map) {
                    this.setMap(parameterIndex, (Map)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString());
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Unsupported Types value: {0}", targetSqlType), YasState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof ByteStreamWriter) {
            this.setByteStreamWriter(parameterIndex, (ByteStreamWriter)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        } else if (x instanceof LocalDate) {
            this.setDate(parameterIndex, (LocalDate)x);
        } else if (x instanceof LocalTime) {
            this.setTime(parameterIndex, (LocalTime)x);
        } else if (x instanceof LocalDateTime) {
            this.setTimestamp(parameterIndex, (LocalDateTime)x);
        } else if (x instanceof OffsetDateTime) {
            this.setTimestamp(parameterIndex, (OffsetDateTime)x);
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else if (x instanceof Number) {
            this.setNumber(parameterIndex, (Number)x);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof RowId) {
            this.setRowId(parameterIndex, (RowId)x);
        } else if (x instanceof Ref) {
            this.setRef(parameterIndex, (Ref)x);
        } else {
            throw SQLError.createSQLException(Messages.get("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), YasState.INVALID_PARAMETER_TYPE);
        }
    }

    public String toString() {
        return super.toString();
    }

    private void bindString(int paramIndex, String s) throws SQLException {
        this.getParameters().setStringParameter(paramIndex, s);
    }

    private void bindNString(int paramIndex, String s) throws SQLException {
        this.getParameters().setNStringParameter(paramIndex, s);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLException(Messages.get("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), YasState.WRONG_OBJECT_TYPE);
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        if (this.batchParameters.size() >= Short.MAX_VALUE) {
            throw SQLError.createSQLException("Can not add batch more than 32767", YasState.WRONG_OBJECT_TYPE);
        }
        if (this.preparedParameters != null) {
            this.batchParameters.add(this.getParameters().copy());
        } else {
            super.addBatch(this.preparedSQL);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getMetaData");
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setArray()");
    }

    public void setArray(int i, Object x) throws SQLException {
        if (!(x instanceof Array)) {
            throw SQLError.TransformException(x.getClass().getName(), "ARRAY");
        }
        this.setArray(i, (Array)x);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        this.getParameters().setBlobParameter(i, x, 30);
    }

    private void setBlob(int parameterIndex, Object in) throws SQLException {
        if (in instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)in);
        } else if (in instanceof InputStream) {
            this.setBlob(parameterIndex, (InputStream)in);
        } else {
            throw SQLError.TransformException(in.getClass().getName(), "BLOB");
        }
    }

    private String readerToString(Reader value, int maxLength) throws SQLException {
        try {
            int bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(bufferSize);
            char[] buf = new char[bufferSize];
            int nRead = 0;
            while (nRead > -1 && v.length() < maxLength) {
                nRead = value.read(buf, 0, Math.min(bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                v.append(buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            throw SQLError.createSQLException(Messages.get("Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (length < 0) {
            throw SQLError.createSQLException(Messages.get("Invalid stream length {0}.", length), YasState.INVALID_PARAMETER_VALUE);
        }
        this.setString(i, this.readerToString(x, length));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        this.getParameters().setClobParameter(i, x, 29);
    }

    private void setClob(int i, Object x) throws SQLException {
        if (x instanceof Clob) {
            this.setClob(i, (Clob)x);
        } else if (x instanceof Reader) {
            this.setClob(i, (Reader)x);
        } else {
            throw SQLError.TransformException(x.getClass().getName(), "CLOB");
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNull()");
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setRef(int,Ref)");
    }

    public void setRef(int parameterIndex, Object in) throws SQLException {
        if (!(in instanceof Ref)) {
            throw SQLError.TransformException(in.getClass().getName(), "REF");
        }
        this.setRef(parameterIndex, (Ref)in);
    }

    public void setURL(int parameterIndex, Object in) throws SQLException {
        if (!(in instanceof Ref)) {
            throw SQLError.TransformException(in.getClass().getName(), "DATALINK");
        }
        this.setURL(parameterIndex, (URL)in);
    }

    public void setNClob(int parameterIndex, Object in) throws SQLException {
        if (!(in instanceof NClob)) {
            throw SQLError.TransformException(in.getClass().getName(), "NCLOB");
        }
        this.setNClob(parameterIndex, (NClob)in);
    }

    public void setSQLXML(int parameterIndex, Object in) throws SQLException {
        if (!(in instanceof SQLXML)) {
            throw SQLError.TransformException(in.getClass().getName(), "SQLXML");
        }
        this.setSQLXML(parameterIndex, (SQLXML)in);
    }

    public void setRowId(int parameterIndex, Object in) throws SQLException {
        if (!(in instanceof RowId)) {
            throw SQLError.TransformException(in.getClass().getName(), "ROWID");
        }
        this.setRowId(parameterIndex, (RowId)in);
    }

    @Override
    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        this.setDate(i, d);
    }

    @Override
    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.setTime(i, t);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.setTimestamp(i, t);
    }

    private void setDate(int i, LocalDate localDate) throws SQLException {
        if (localDate == null) {
            this.getParameters().setNull(i, 13);
        } else {
            this.setDate(i, Date.valueOf(localDate));
        }
    }

    private void setTime(int i, LocalTime localTime) throws SQLException {
        if (localTime == null) {
            this.getParameters().setNull(i, 15);
        } else {
            this.setTime(i, YasTime.valueOf(localTime));
        }
    }

    private void setTimestamp(int i, LocalDateTime localDateTime) throws SQLException {
        if (localDateTime == null) {
            this.getParameters().setNull(i, 16);
        } else {
            this.setTimestamp(i, Timestamp.valueOf(localDateTime));
        }
    }

    private void setTimestamp(int i, OffsetDateTime offsetDateTime) throws SQLException {
        if (offsetDateTime == null) {
            this.getParameters().setNull(i, 16);
        } else {
            this.setTimestamp(i, Timestamp.valueOf(offsetDateTime.toLocalDateTime()));
        }
    }

    private YasParameterMetaData createParameterMetaData() throws SQLException {
        return new YasParameterMetaData(this.connection, this.parameterFields);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.getParameters().setNull(parameterIndex, 32);
            return;
        }
        this.getParameters().setRowIdParameter(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkClosed();
        if (value == null) {
            this.getParameters().setNull(parameterIndex, 27);
            return;
        }
        if (value.length() < 32000) {
            this.bindNString(parameterIndex, value);
            return;
        }
        this.setCharacterStream(parameterIndex, (Reader)new StringReader(value), value.length());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw SQLError.createSQLException(Messages.get("Stream is too large to send over the protocol.", new Object[0]), YasState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        String s = value != null ? this.readerToString(value, (int)length) : null;
        this.setString(parameterIndex, s);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        String s = value != null ? this.readerToString(value, Integer.MAX_VALUE) : null;
        this.setString(parameterIndex, s);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        this.checkClosed();
        if (length > Integer.MAX_VALUE) {
            throw SQLError.createSQLException(Messages.get("Stream is too large to send over the protocol.", new Object[0]), YasState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        this.setBinaryStream(parameterIndex, value, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        this.checkClosed();
        if (value == null) {
            this.getParameters().setNull(parameterIndex, 28);
            return;
        }
        this.getParameters().setBytea(parameterIndex, value);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        int nRead;
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(int, Reader, long)");
        }
        this.checkClosed();
        if (length < 0L) {
            throw SQLError.createSQLException(Messages.get("Invalid stream length {0}.", length), YasState.INVALID_PARAMETER_VALUE);
        }
        if (reader == null || length == 0L) {
            this.getParameters().setNull(parameterIndex, 29);
            return;
        }
        int buffSize = (int)Math.min(2048L, length);
        char[] tempCharBuf = new char[buffSize];
        try {
            nRead = reader.read(tempCharBuf);
        }
        catch (IOException ioe) {
            throw SQLError.createSQLException(Messages.get("Access Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        if (nRead == -1) {
            throw SQLError.createSQLException(length + " character of CLOB data can not be read", YasState.DATA_ERROR);
        }
        if (nRead == 2048) {
            YasClob clob = this.connection.getSession().preProcessReaderBinding(reader, tempCharBuf, length);
            long clobLength = clob.length();
            if (length > clobLength) {
                clob.free();
                throw SQLError.createSQLException(length - clobLength + " character of CLOB data can not be read", YasState.DATA_ERROR);
            }
            this.setClob(parameterIndex, clob);
            return;
        }
        if (length > (long)nRead) {
            throw SQLError.createSQLException(length - (long)nRead + " character of CLOB data can not be read", YasState.DATA_ERROR);
        }
        this.setString(parameterIndex, String.valueOf(tempCharBuf, 0, nRead));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        int nRead;
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(int, Reader)");
        }
        this.checkClosed();
        if (reader == null) {
            this.getParameters().setNull(parameterIndex, 29);
            return;
        }
        char[] tempCharBuf = new char[2048];
        try {
            nRead = reader.read(tempCharBuf);
        }
        catch (IOException ioe) {
            throw SQLError.createSQLException(Messages.get("Access Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        if (nRead == -1) {
            this.getParameters().setNull(parameterIndex, 29);
            return;
        }
        if (nRead == 2048) {
            YasClob clob = this.connection.getSession().preProcessReaderBinding(reader, tempCharBuf, Long.MAX_VALUE);
            this.setClob(parameterIndex, clob);
            return;
        }
        this.setString(parameterIndex, String.valueOf(tempCharBuf, 0, nRead));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (length < 0L) {
            throw SQLError.createSQLException(Messages.get("Invalid stream length {0}.", length), YasState.INVALID_PARAMETER_VALUE);
        }
        if (inputStream == null || length == 0L) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(int, Reader)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setSQLXML(int, SQLXML)");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setURL(int,URL)");
    }

    private long[] executeLargeBatchWithAutoKey() throws SQLException {
        this.generatedKeysResults = null;
        this.returnColRsMetaData.withBatchInsert = true;
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[0]);
        long[] ret = new long[parameterLists.length];
        for (int i = 0; i < parameterLists.length; ++i) {
            this.getParameters().clear();
            this.getParameters().appendAll(parameterLists[i].copy());
            this.executeInternal(4);
            ret[i] = this.getExecuteLargeUpdateResult();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        if (this.preparedParameters != null) {
            if (this.batchParameters == null || this.batchParameters.isEmpty()) {
                return new long[0];
            }
            if (this.batchParameters.size() > 1 && this.autoGeneratedKeys) {
                try {
                    long[] lArray = this.executeLargeBatchWithAutoKey();
                    return lArray;
                }
                finally {
                    this.clearBatch();
                }
            }
            try {
                int[] iret;
                ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[0]);
                this.executeInternal(parameterLists, true);
                long[] ret = parameterLists.length > 1 ? ((iret = this.currentResultSet.getBatchUpdateCounts()) != null ? Utils.toLongArray(iret) : new long[]{this.currentResultSet.getUpdateCount()}) : new long[]{this.currentResultSet.getUpdateCount()};
                long[] lArray = ret;
                return lArray;
            }
            finally {
                this.clearBatch();
            }
        }
        return super.executeLargeBatch();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (!this.hasPrepared) {
            this.serverPrepare(this.preparedSQL);
        }
        if (this.parameterMetaData == null) {
            this.parameterMetaData = this.createParameterMetaData();
        }
        if (this.autoGeneratedKeys) {
            this.parameterMetaData.setThrowUnsupported(true);
        }
        return this.parameterMetaData;
    }

    @Override
    public void setParameters(Field[] parameterFields) throws SQLException {
        this.parameterFields = parameterFields;
        if (this.preparedParameters == null || this.preparedParameters.getParameterCount() != parameterFields.length) {
            this.preparedParameters = new SimpleParameterList(parameterFields.length);
            this.preparedParameters.setCharset(this.getSession().getCharset());
            this.preparedParameters.setnCharset(this.getSession().getnCharset());
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.batchParameters != null) {
            this.batchParameters.clear();
        }
        super.clearBatch();
    }

    protected ParameterList getParameters() throws SQLException {
        if (this.preparedParameters == null) {
            throw SQLError.createSQLException("Invalid column index.", YasState.INVALID_PARAMETER_VALUE);
        }
        return this.preparedParameters;
    }

    void registerReturnParamsForAutoKey() throws SQLException {
        if (!this.hasPrepared) {
            this.preparedParameters = null;
            this.serverPrepare(this.preparedSQL);
        }
        int[] returnTypes = this.returnColRsMetaData.returnTypes;
        int count = returnTypes.length;
        int start = this.preparedParameters.getParameterCount() - count;
        start = start < 0 ? 0 : start;
        for (int i = 0; i < count; ++i) {
            int pos = start + i;
            this.registerReturnParameterInternal(pos, returnTypes[i]);
        }
    }

    private void setBinary(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        if (in instanceof String) {
            this.setString(parameterIndex, (String)in);
        } else if (in instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])in);
        } else if (in instanceof InputStream) {
            this.setBytes(parameterIndex, TypeConverter.getBytesByInputStream((InputStream)in, scale));
        } else {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetSqlType).getName());
        }
    }

    private void setTimeWithTimezone(int parameterIndex, Object in) throws SQLException {
        if (in instanceof OffsetDateTime) {
            this.setTime(parameterIndex, Time.valueOf(((OffsetDateTime)in).toLocalDateTime().toLocalTime()));
        } else if (in instanceof OffsetTime) {
            this.setTime(parameterIndex, Time.valueOf(((OffsetTime)in).toLocalTime()));
        } else {
            throw SQLError.TransformException(in.getClass().getName(), "TIME_WITH_TIMEZONE");
        }
    }

    private void setTimestampWithTimezone(int parameterIndex, Object in) throws SQLException {
        if (in instanceof OffsetDateTime) {
            this.setTimestamp(parameterIndex, (OffsetDateTime)in);
        } else if (in instanceof YasTimestamp) {
            this.setObject(parameterIndex, in);
        } else {
            throw SQLError.TransformException(in.getClass().getName(), "TIMESTAMP_WITH_TIMEZONE");
        }
    }

    @Override
    public void reset() throws SQLException {
        super.reset();
        this.serverPrepare(this.preparedSQL);
    }

    @Override
    protected String getSql() {
        return this.preparedSQL;
    }
}

