/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasResultSet;
import com.yashandb.jdbc.CachedResultSet;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.ScrollableSensitiveResultSet;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.UpdatableResultSet;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.YasSQL;
import java.sql.SQLException;

public class ResultSetFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetFactory.class);

    public static YasResultSet createCachedResultSet(StatementImpl creatorStmt, Field[] fields, RowData rowData) throws SQLException {
        int resultSetType = creatorStmt.getResultSetType();
        int resultSetConcurrency = creatorStmt.getResultSetConcurrency();
        int maxRows = creatorStmt.getMaxRows();
        int maxFieldSize = creatorStmt.getMaxFieldSize();
        int rsHoldability = creatorStmt.getResultSetHoldability();
        return new CachedResultSet(creatorStmt, fields, rowData, maxRows, maxFieldSize, resultSetType, resultSetConcurrency, rsHoldability);
    }

    public static YasResultSet createResultSet(StatementImpl creatorStmt, Field[] fields, RowData rowData, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        ResultSetImpl newResult = null;
        int resultSetType = rsType;
        int resultSetConcurrency = rsConcurrency;
        if (creatorStmt.yasSQL != null && (rsType == 1005 || rsConcurrency == 1008)) {
            YasSQL yasSQL = creatorStmt.yasSQL;
            creatorStmt.yasSQL = null;
            if (!yasSQL.canScrollSensitive() && rsType == 1005) {
                if (!yasSQL.canScrollInSensitive()) {
                    resultSetType = 1003;
                    LOGGER.debug("Downgrade the ResultSet to TYPE_FORWARD_ONLY:" + yasSQL.getSQL());
                } else {
                    resultSetType = 1004;
                    LOGGER.debug("Downgrade the ResultSet to TYPE_SCROLL_INSENSITIVE:" + yasSQL.getSQL());
                }
            }
            if (!yasSQL.canUpdatable() && rsConcurrency == 1008) {
                resultSetConcurrency = 1007;
                LOGGER.debug("Downgrade the ResultSet to CONCUR_READ_ONLY:" + yasSQL.getSQL());
            }
            if (yasSQL.canRowID() && yasSQL.canScrollSensitive() && resultSetType == 1005) {
                newResult = new ScrollableSensitiveResultSet(creatorStmt, fields, rowData, maxRows, maxFieldSize, resultSetType, resultSetConcurrency, rsHoldability, yasSQL);
            } else if (yasSQL.canRowID() && yasSQL.canUpdatable() && resultSetConcurrency == 1008) {
                newResult = new UpdatableResultSet(creatorStmt, fields, rowData, maxRows, maxFieldSize, resultSetType, resultSetConcurrency, rsHoldability, yasSQL);
            }
        }
        if (newResult == null) {
            newResult = new ResultSetImpl(creatorStmt, fields, rowData, maxRows, maxFieldSize, resultSetType, resultSetConcurrency, rsHoldability);
            newResult.setFetchSize(creatorStmt.getFetchSize());
            newResult.setFetchDirection(creatorStmt.getFetchDirection());
        }
        return newResult;
    }
}

