/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasResultSet;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.NotUpdatable;
import com.yashandb.jdbc.ResultSetMetaDataImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.util.Messages;
import com.yashandb.util.YasByte;
import com.yashandb.util.YasObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ResultSetImpl
implements YasResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetImpl.class);
    protected final YasConnection connection;
    protected final YasStatement owningStatement;
    private long updateCount;
    private final boolean reallyResult;
    private boolean stmtQueryResult = false;
    private boolean isClosed;
    protected boolean updatable = false;
    protected boolean doingUpdates = false;
    protected HashMap<String, Object> updateValues = null;
    protected HashMap<String, SQLType> updateSQLTypes = null;
    protected HashMap<String, Integer> updateScales = null;
    private List<PrimaryKey> primaryKeys;
    private boolean singleTable = false;
    private String tableName = null;
    private final int resultsetType;
    private final int resultsetConcurrency;
    private int fetchDirection = 1000;
    protected Field[] fields;
    protected Accessor[] accessors;
    protected long maxRows;
    protected final int maxFieldSize;
    protected long currentRow = -1L;
    protected int rowOffset;
    protected Row thisRow;
    protected SQLWarning warnings = null;
    protected Boolean wasNullFlag;
    protected boolean onInsertRow = false;
    private Row rowBuffer = null;
    protected int fetchSize;
    private Map<String, Integer> columnNameIndexMap;
    private ResultSetMetaData rsMetaData;
    protected RowData rowData;
    private int[] dmlRows = null;
    private HashMap<Integer, BatchError> batchErrors = null;
    private ArrayList<Integer> dmlRowList = null;

    protected ResultSetMetaData createMetaData() throws SQLException {
        return new ResultSetMetaDataImpl(this.connection, this.fields);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.rsMetaData == null) {
            this.rsMetaData = this.createMetaData();
        }
        return this.rsMetaData;
    }

    ResultSetImpl(StatementImpl creatorStmt, Field[] fields, RowData rows, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        if (rows == null) {
            throw new NullPointerException("packet must be non-null");
        }
        if (fields == null) {
            throw new NullPointerException("fields must be non-null");
        }
        this.owningStatement = creatorStmt;
        this.connection = (YasConnection)creatorStmt.getConnection();
        this.fields = fields;
        this.rowData = rows;
        this.isClosed = false;
        this.accessors = AccessorFactory.generateAccessors(fields, this.connection.getSession());
        this.maxRows = maxRows;
        this.maxFieldSize = maxFieldSize;
        this.resultsetType = rsType;
        this.resultsetConcurrency = rsConcurrency;
        this.updateCount = 0L;
        this.reallyResult = true;
    }

    public ResultSetImpl(YasConnection conn, YasStatement creatorStmt) {
        this.updateCount = 0L;
        this.reallyResult = true;
        this.owningStatement = creatorStmt;
        this.resultsetType = 1003;
        this.resultsetConcurrency = 1007;
        this.connection = conn;
        this.rowData = null;
        this.isClosed = false;
        this.fields = null;
        this.accessors = null;
        this.maxRows = 0L;
        this.maxFieldSize = 0;
    }

    public ResultSetImpl(long updateCount, YasConnection conn, YasStatement creatorStmt) {
        this.updateCount = updateCount;
        this.reallyResult = false;
        this.owningStatement = creatorStmt;
        this.resultsetType = 1003;
        this.resultsetConcurrency = 1007;
        this.connection = conn;
        this.rowData = null;
        this.isClosed = false;
        this.fields = null;
        this.accessors = null;
        this.maxRows = 0L;
        this.maxFieldSize = 0;
    }

    public ResultSetImpl(long updateCount, YasConnection conn, YasStatement creatorStmt, int[] dmlRows, HashMap<Integer, BatchError> batchErrors) {
        this.updateCount = updateCount;
        this.reallyResult = false;
        this.owningStatement = creatorStmt;
        this.resultsetType = 1003;
        this.resultsetConcurrency = 1007;
        this.connection = conn;
        this.rowData = null;
        this.isClosed = false;
        this.fields = null;
        this.accessors = null;
        this.maxRows = 0L;
        this.maxFieldSize = 0;
        this.dmlRows = dmlRows;
        this.batchErrors = batchErrors;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        LOGGER.debug("getURL columnIndex: {}", (Object)columnIndex);
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getURL(int)");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    protected Object internalGetObject(int columnIndex, Field field) throws SQLException {
        switch (this.getSQLType(columnIndex)) {
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case -7: {
                if (field.getSize() == 1) {
                    return this.getBoolean(columnIndex);
                }
                return this.getBytes(columnIndex);
            }
            case 2009: {
                return this.getSQLXML(columnIndex);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex, field.getScale());
            }
            case 7: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return this.getDouble(columnIndex);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 3009: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 3001: 
            case 3002: {
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2005: 
            case 2011: {
                return this.getClob(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
            case -8: {
                return this.getRowId(columnIndex);
            }
        }
        return null;
    }

    protected void checkScrollable() throws SQLException {
        this.checkClosed();
        if (this.resultsetType == 1003) {
            throw SQLError.createSQLException(Messages.get("Operation requires a scrollable ResultSet, but this ResultSet is FORWARD_ONLY.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int index) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkScrollable();
            this.prepareMove();
            if (index == 0) {
                this.rowData.beforeFirst();
                this.thisRow = null;
                this.currentRow = this.rowData.getPosition();
                return false;
            }
            if (index < 0) {
                this.rowData.afterLast();
                long rowIndex = this.rowData.getPosition();
                rowIndex = this.maxRows > 0L && rowIndex > this.maxRows ? this.maxRows + (long)index : (rowIndex += (long)index);
                if (rowIndex < 0L) {
                    this.rowData.beforeFirst();
                    this.thisRow = null;
                    this.currentRow = this.rowData.getPosition();
                    return false;
                }
                this.rowData.setCurrentRow(rowIndex);
                this.currentRow = this.rowData.getPosition();
                this.thisRow = this.rowData.getAt(this.currentRow);
            } else {
                if (this.maxRows > 0L && this.maxRows < (long)index) {
                    index = (int)this.maxRows;
                }
                this.rowData.setCurrentRow(index - 1);
                long rowIndex = this.rowData.getPosition();
                if ((long)(index - 1) > rowIndex || (long)(index - 1) == rowIndex && !this.rowData.hasNext()) {
                    this.thisRow = null;
                    this.currentRow = this.rowData.getPosition();
                    return false;
                }
                this.currentRow = this.rowData.getPosition();
                this.thisRow = this.rowData.getAt(this.currentRow);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkScrollable();
            this.rowData.afterLast();
            this.thisRow = null;
            this.currentRow = this.rowData.getPosition();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        LOGGER.debug("getBigDecimal columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        this.owningStatement.closeStream(columnIndex);
        int col = columnIndex - 1;
        return this.accessors[col].getBigDecimal(this.thisRow.get(col));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = i - 1;
        return this.accessors[col].getBlob(this.thisRow.get(col), this.connection.getSession());
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        StringReader reader;
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        int type = this.fields[col].getYasType();
        switch (type) {
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                reader = new StringReader(this.getString(columnIndex));
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("getCharacterStream not implemented for type {0}", this.fields[col].getTypeName()), YasState.WRONG_OBJECT_TYPE);
            }
        }
        return reader;
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = i - 1;
        return this.accessors[col].getClob(this.thisRow.get(col), this.connection.getSession());
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetConcurrency;
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        LOGGER.debug("getDate columnIndex: {}", (Object)i);
        this.checkResultSet(i);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = i - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getDate(this.thisRow.get(col), cal);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        LOGGER.debug("getTime columnIndex: {}", (Object)i);
        this.checkResultSet(i);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = i - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getTime(this.thisRow.get(col), cal);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        LOGGER.debug("getTimestamp columnIndex: {}", (Object)i);
        this.checkResultSet(i);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = i - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getTimestamp(this.thisRow.get(col), cal);
    }

    @Override
    public Date getDate(String c, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(c), cal);
    }

    @Override
    public Time getTime(String c, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(c), cal);
    }

    @Override
    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    public Object getObjectImpl(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(this.findColumn(columnName), map);
    }

    public Object getObjectImpl(int i, Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRef(int)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            if (this.currentRow == this.rowData.getFetchedRowCount() || this.maxRows > 0L && this.currentRow == this.maxRows) {
                return 0;
            }
            return (int)(this.currentRow + 1L);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.owningStatement;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.resultsetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.rowData.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.rowData.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.currentRow == 0L;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkScrollable();
            return this.rowData.isLast();
        }
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.currentRow == -1L) {
            return false;
        }
        return this.absolute((int)this.currentRow);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.currentRow + 1L + (long)rows < 0L) {
            this.beforeFirst();
            return false;
        }
        return this.absolute((int)this.currentRow + 1 + rows);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                this.checkScrollable();
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Invalid fetch direction constant: {0}.", direction), YasState.INVALID_PARAMETER_VALUE);
            }
        }
        this.fetchDirection = direction;
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        throw new NotUpdatable();
    }

    protected synchronized void clearRowBuffer(boolean copyCurrentRow) throws SQLException {
        this.rowBuffer = copyCurrentRow && this.thisRow != null ? this.thisRow.updateableCopy() : new Row(this.fields.length);
        if (this.updateValues != null) {
            this.updateValues.clear();
            this.updateSQLTypes.clear();
            this.updateScales.clear();
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateAsciiStream()");
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBinaryStream()");
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateValue(columnIndex, String.valueOf(x));
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateCharacterStream()");
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateValue(columnIndex, Float.valueOf(x));
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateObject(columnIndex, x, 0);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateValue(columnIndex, x, scale);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "refreshRow");
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    boolean isUpdatable() throws SQLException {
        this.checkClosed();
        if (this.resultsetConcurrency == 1007) {
            throw SQLError.createSQLException(Messages.get("ResultSets with concurrency CONCUR_READ_ONLY cannot be updated.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        return this.updatable;
    }

    private void setRowBufferColumn(int columnIndex, Object valueObject) throws SQLException {
        if (valueObject instanceof YasObject) {
            String value = ((YasObject)valueObject).getValue();
            this.rowBuffer.set(columnIndex, value == null ? null : this.connection.encodeString(value));
        } else {
            switch (this.getSQLType(columnIndex + 1)) {
                case -7: 
                case 16: {
                    this.rowBuffer.set(columnIndex, this.connection.encodeString((Boolean)valueObject != false ? "t" : "f"));
                    break;
                }
                case 91: {
                    break;
                }
                case 92: {
                    break;
                }
                case 93: {
                    break;
                }
                case 0: {
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    try {
                        this.rowBuffer.set(columnIndex, YasByte.toYasString((byte[])valueObject).getBytes("ISO-8859-1"));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw SQLError.createSQLException(Messages.get("The JVM claims not to support the encoding: {0}", "ISO-8859-1"), YasState.UNEXPECTED_ERROR, (Throwable)e);
                    }
                }
                default: {
                    this.rowBuffer.set(columnIndex, this.connection.encodeString(String.valueOf(valueObject)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRowBuffer(PreparedStatement insertStatement) throws SQLException {
        for (Map.Entry<String, Object> entry : this.updateValues.entrySet()) {
            int columnIndex = this.findColumn(entry.getKey()) - 1;
            Object valueObject = entry.getValue();
            this.setRowBufferColumn(columnIndex, valueObject);
        }
        if (insertStatement == null) {
            return;
        }
        try (ResultSet generatedKeys = insertStatement.getGeneratedKeys();){
            generatedKeys.next();
            int numKeys = this.primaryKeys.size();
            for (int i = 0; i < numKeys; ++i) {
                PrimaryKey key = this.primaryKeys.get(i);
                int columnIndex = key.index - 1;
                Object valueObject = generatedKeys.getObject(key.name);
                this.setRowBufferColumn(columnIndex, valueObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            if (rows < 0) {
                throw SQLError.createSQLException(Messages.get("Fetch size must be a value greater to or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
            }
            this.fetchSize = rows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.fetchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            boolean hasNext;
            this.checkClosed();
            if (this.onInsertRow) {
                this.onInsertRow = false;
            }
            if (this.doingUpdates) {
                this.doingUpdates = false;
            }
            if (!this.reallyResult()) {
                throw SQLError.createSQLException("ResultSet is from update", YasState.NO_DATA);
            }
            this.owningStatement.drainStream();
            if (this.maxRows > 0L && this.currentRow >= this.maxRows - 1L) {
                this.currentRow = this.maxRows;
                return false;
            }
            if (this.rowData == null) {
                return false;
            }
            if (!this.rowData.hasNext()) {
                hasNext = false;
            } else {
                this.thisRow = this.rowData.next();
                ++this.currentRow;
                if (this.thisRow == null) {
                    hasNext = false;
                } else {
                    this.clearWarnings();
                    hasNext = true;
                }
            }
            if (!hasNext) {
                this.currentRow = this.rowData.getFetchedRowCount();
            }
            return hasNext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            if (!this.isClosed) {
                this.closeInternally();
            }
        }
    }

    protected void closeInternally() throws SQLException {
        this.rowData = null;
        this.isClosed = true;
        if (this.stmtQueryResult && !this.owningStatement.isClosed() && this.owningStatement.isCloseOnCompletion()) {
            this.owningStatement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        if (this.wasNullFlag == null) {
            throw new SQLException("No Data Read");
        }
        return this.wasNullFlag;
    }

    private boolean isLobType(int sqlType) {
        return sqlType == 2005 || sqlType == 2004 || sqlType == 2011;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        if (this.isLobType(this.fields[col].getSQLType())) {
            return this.accessors[col].getString(this.thisRow.get(col));
        }
        return this.accessors[col].getString(this.truncBytes(columnIndex, this.thisRow.get(col)));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return false;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getBoolean(this.thisRow.get(col));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return 0;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getByte(this.thisRow.get(col));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        LOGGER.debug("getShort columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return 0;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getShort(this.thisRow.get(col));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return 0;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getInt(this.thisRow.get(col));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        LOGGER.debug("getLong columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return 0L;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getLong(this.thisRow.get(col));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        LOGGER.debug("getFloat columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return 0.0f;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getFloat(this.thisRow.get(col));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        LOGGER.debug("getDouble columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return 0.0;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getDouble(this.thisRow.get(col));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        LOGGER.debug("getBigDecimal columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getBigDecimal(this.thisRow.get(col));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        LOGGER.debug("getBytes columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        if (this.isLobType(this.fields[col].getSQLType())) {
            return this.accessors[col].getBytes(this.thisRow.get(col));
        }
        return this.accessors[col].getBytes(this.truncBytes(columnIndex, this.thisRow.get(col)));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        LOGGER.debug("getTime columnIndex: {}", (Object)columnIndex);
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ByteArrayInputStream inputStream;
        LOGGER.debug("getAsciiStream columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        int type = this.fields[col].getYasType();
        switch (type) {
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                inputStream = new ByteArrayInputStream(this.getString(columnIndex).getBytes(StandardCharsets.US_ASCII));
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("getAsciiStream not implemented for type {0}", this.fields[col].getTypeName()), YasState.WRONG_OBJECT_TYPE);
            }
        }
        return inputStream;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getUnicodeStream(int)");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream inputStream;
        LOGGER.debug("getBinaryStream columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        int type = this.fields[col].getYasType();
        switch (type) {
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                inputStream = new ByteArrayInputStream(this.getBytes(columnIndex));
                break;
            }
            case 30: {
                inputStream = this.getBlob(columnIndex).getBinaryStream();
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("getBinaryStream not implemented for type {0}", this.fields[col].getTypeName()), YasState.WRONG_OBJECT_TYPE);
            }
        }
        return inputStream;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName), null);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    protected void addWarning(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        LOGGER.debug("getObject columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        Object result = this.internalGetObject(columnIndex, field);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkClosed();
        int col = this.findColumnIndex(columnName);
        if (col == 0) {
            throw SQLError.createSQLException(Messages.get("The column name {0} was not found in this ResultSet.", columnName), YasState.UNDEFINED_COLUMN);
        }
        return col;
    }

    public static Map<String, Integer> createColumnNameIndexMap(Field[] fields) {
        HashMap<String, Integer> columnNameIndexMap = new HashMap<String, Integer>(fields.length * 2);
        for (int i = fields.length - 1; i >= 0; --i) {
            String columnName = fields[i].getName();
            columnNameIndexMap.put(columnName.toLowerCase(Locale.US), i + 1);
        }
        return columnNameIndexMap;
    }

    private int findColumnIndex(String columnName) {
        Integer index;
        if (this.columnNameIndexMap == null) {
            if (this.owningStatement != null) {
                this.columnNameIndexMap = this.owningStatement.getResultSetColumnNameIndexMap();
            }
            if (this.columnNameIndexMap == null) {
                this.columnNameIndexMap = ResultSetImpl.createColumnNameIndexMap(this.fields);
            }
        }
        if ((index = this.columnNameIndexMap.get(columnName)) != null) {
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toLowerCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toUpperCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        return 0;
    }

    protected int getSQLType(int column) throws SQLException {
        Field field = this.fields[column - 1];
        return field.getSQLType();
    }

    protected void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdatable()) {
            throw SQLError.createSQLException(Messages.get("ResultSet is not updateable. The query that generated this result set must select only one table, and not have aggregate function. See the JDBC 2.1 API Specification, section 5.6 for more details.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues == null) {
            this.updateValues = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
            this.updateSQLTypes = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
            this.updateScales = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw SQLError.createSQLException(Messages.get("This ResultSet is closed.", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
        }
    }

    protected void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", column, this.fields.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkResultSet(int column) throws SQLException {
        this.checkClosed();
        if (this.thisRow == null) {
            throw SQLError.createSQLException(Messages.get("ResultSet not positioned properly, perhaps you need to call next.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(column);
        this.wasNullFlag = this.thisRow.get(column - 1) == null;
    }

    private boolean isColumnTrimmable(int columnIndex) throws SQLException {
        switch (this.getSQLType(columnIndex)) {
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] truncBytes(int columnIndex, byte[] bytes) throws SQLException {
        int bytesLen = bytes.length;
        if (this.maxFieldSize > 0 && bytesLen > this.maxFieldSize && this.isColumnTrimmable(columnIndex)) {
            bytesLen = this.maxFieldSize;
        }
        byte[] newBytes = new byte[bytesLen];
        System.arraycopy(bytes, 0, newBytes, 0, bytesLen);
        return newBytes;
    }

    protected void updateValue(int columnIndex, Object value) throws SQLException {
        this.updateValue(columnIndex, value, 0);
    }

    protected void updateValue(int columnIndex, Object value, int scaleOrLength) throws SQLException {
        this.updateValue(columnIndex, value, null, scaleOrLength);
    }

    protected void updateValue(int columnIndex, Object value, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateRef(int,Ref)");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateRef(String,Ref)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(int,Blob)");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(String,Blob)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(int,Clob)");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(String,Clob)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Invalid Parameter, Class Type is null");
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(col);
        return this.accessors[col].getObject(this.thisRow.get(col), type, this.connection);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateValue(columnIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(columnIndex, x, targetSqlType, 0);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, targetSqlType);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        LOGGER.debug("getRowId columnIndex: {}", (Object)columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag.booleanValue()) {
            return null;
        }
        int col = columnIndex - 1;
        this.owningStatement.closeStream(columnIndex);
        return this.accessors[col].getRowId(this.thisRow.get(col));
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnName), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getHoldability()");
    }

    @Override
    public boolean reallyResult() {
        if (this.rowData != null) {
            return true;
        }
        return this.reallyResult;
    }

    @Override
    public void setStmtQueryResult(boolean stmtQuery) {
        this.stmtQueryResult = stmtQuery;
    }

    @Override
    public String getServerInfo() {
        return null;
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public long getUpdateID() {
        return 0L;
    }

    @Override
    public void realClose(boolean calledExplicitly) throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setFirstCharOfQuery(char firstCharUpperCase) {
    }

    @Override
    public void setOwningStatement(StatementImpl owningStatement) {
    }

    @Override
    public char getFirstCharOfQuery() {
        return '\u0000';
    }

    @Override
    public void clearNextResult() {
    }

    @Override
    public void appendResults(long updateCount, int[] dmlRows, Map<Integer, BatchError> batchErrors) {
        this.updateCount += updateCount;
        if (this.dmlRowList == null) {
            this.dmlRowList = new ArrayList();
            if (this.dmlRows != null) {
                for (int affectedRows : this.dmlRows) {
                    this.dmlRowList.add(affectedRows);
                }
            }
        }
        int preDmlRows = this.dmlRowList.size();
        if (dmlRows != null) {
            for (int affectedRows : dmlRows) {
                this.dmlRowList.add(affectedRows);
            }
        } else {
            this.dmlRowList.add((int)updateCount);
        }
        if (batchErrors == null) {
            return;
        }
        if (this.batchErrors == null) {
            this.batchErrors = new HashMap();
        }
        for (Map.Entry<Integer, BatchError> entry : batchErrors.entrySet()) {
            int errorRowNum = entry.getKey() + preDmlRows;
            BatchError batchError = entry.getValue();
            this.batchErrors.put(errorRowNum, batchError);
        }
    }

    @Override
    public YasResultSet getNextResultSet() {
        return null;
    }

    @Override
    public void buildIndexMapping() throws SQLException {
    }

    @Override
    public void initializeWithMetadata() throws SQLException {
    }

    @Override
    public void redefineFieldsForDBMD(Field[] metadataFields) {
    }

    @Override
    public int getBytesSize() throws SQLException {
        return 0;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNString(int, String)");
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnName), nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(int, NClob)");
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnName), nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(int, Reader)");
    }

    @Override
    public void updateNClob(String columnName, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnName), reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(int, Reader, long)");
    }

    @Override
    public void updateNClob(String columnName, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnName), reader, length);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        LOGGER.debug("getNClob columnIndex: {}", (Object)columnIndex);
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        return this.getNClob(this.findColumn(columnName));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(int, InputStream, long)");
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(int, InputStream)");
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(int, Reader, long)");
    }

    @Override
    public void updateClob(String columnName, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(int, Reader)");
    }

    @Override
    public void updateClob(String columnName, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnName), reader);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getSQLXML(int, Reader)");
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.updateValue(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnName), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        LOGGER.debug("getNCharacterStream columnIndex: {}", (Object)columnIndex);
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnName));
    }

    public void updateNCharacterStream() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNCharacterStream(int, Reader, int)");
    }

    public void updateNCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNCharacterStream(int, Reader)");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNCharacterStream(int, Reader, long)");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateCharaceterStream(int, Reader, long)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateCharaceterStream(int, Reader)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBinaryStream(int, InputStream, long)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBinaryStream(int, InputStream)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), inputStream);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateAsciiStream(int, InputStream, long)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateAsciiStream(int, InputStream)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), inputStream);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    protected void prepareMove() throws SQLException {
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.owningStatement.drainStream();
        if (!this.reallyResult()) {
            throw SQLError.createSQLException("ResultSet is from update", YasState.NO_DATA);
        }
    }

    @Override
    public long getFetchedRowCount() throws SQLException {
        if (this.reallyResult && this.rowData != null) {
            return this.rowData.getFetchedRowCount();
        }
        return -1L;
    }

    @Override
    public int[] getBatchUpdateCounts() {
        if (this.dmlRowList == null) {
            return this.dmlRows;
        }
        int[] updateCounts = new int[this.dmlRowList.size()];
        for (int i = 0; i < this.dmlRowList.size(); ++i) {
            updateCounts[i] = this.dmlRowList.get(i);
        }
        return updateCounts;
    }

    @Override
    public Map<Integer, BatchError> getBatchErrors() {
        return this.batchErrors;
    }

    @Override
    public String getBatchError(int batchIndex) {
        BatchError be;
        if (this.batchErrors != null && (be = this.batchErrors.get(batchIndex)) != null) {
            return be.toString();
        }
        return null;
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int index, String name) {
            this.index = index;
            this.name = name;
        }

        Object getValue() throws SQLException {
            return ResultSetImpl.this.getObject(this.index);
        }
    }
}

