/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasConstants;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetMetaDataImpl
implements ResultSetMetaData {
    YasConnection connection;
    Field[] fields;
    private boolean fieldInfoFetched;

    public ResultSetMetaDataImpl() {
    }

    public ResultSetMetaDataImpl(YasConnection connection, Field[] fields) {
        this.connection = connection;
        this.fields = fields;
        this.fieldInfoFetched = false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type == 1 || type == 12 || type == -15 || type == -9 || type == 2005;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type != -4 && type != -1 && type != 2004 && type != 2005 && type != 2011 && type != 2002 && type != 2003 && type != 2006 && type != 2012;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type == 2;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        Field field = this.getField(column);
        return field == null ? 1 : (field.getNullable() == 1 ? 1 : 0);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        int precision = field.getPrecision();
        int scale = field.getScale();
        switch (sqlType) {
            case 16: {
                return YasConstants.MAX_SIZE_BOOL;
            }
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case -8: {
                return 42;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 24;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return 64;
            }
            case -15: 
            case -9: 
            case -7: 
            case 1: 
            case 12: {
                return field.getSize();
            }
            case 2: {
                if (scale > 0) {
                    if (precision > scale) {
                        return precision + 2;
                    }
                    return scale + 2;
                }
                if (scale == -128) {
                    return 128;
                }
                return precision - scale + 1;
            }
            case 3002: {
                return precision + 11 + scale;
            }
            case 3001: {
                return precision + 4;
            }
        }
        return 20;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        Field field1 = this.getField(column);
        return field1.getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        switch (sqlType) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case -15: 
            case -9: 
            case -7: 
            case 1: 
            case 12: {
                return field.getSize();
            }
            case 2: 
            case 3001: 
            case 3002: {
                return field.getPrecision();
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        int scale = field.getScale();
        if (scale < 0 && sqlType != 2) {
            return 0;
        }
        return scale;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getSQLType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", columnIndex, this.fields.length), YasState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        return this.fields[columnIndex - 1].getSQLType();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Field field = this.getField(column);
        if (field.getYasType() == 31 && field.getSize() == 1) {
            return Boolean.class.getName();
        }
        return YasTypes.getTypeClassName(field.getYasType());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

