/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.core.SqlKind;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetMetaDataImpl;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import com.yashandb.util.YasSQL;
import java.sql.SQLException;
import java.util.List;

public class ReturnColumnResultSetMetaData
extends ResultSetMetaDataImpl {
    int[] colIndexes;
    String[] colNames;
    String originalSql;
    String newSql;
    YasSQL parser = null;
    SqlKind sqlKind = SqlKind.UNINITIALIZED;
    int autoKeyType;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    int[] tablePrecisions;
    int[] tableScales;
    int[] returnTypes;
    String tableName;
    Field[] autoKeyFields;
    Boolean withBatchInsert = false;
    public static final int RETURN_ROW_ID = 0;
    public static final int RETURN_COLS_BY_INDEX = 1;
    public static final int RETURN_COLS_BY_NAME = 2;

    public ReturnColumnResultSetMetaData(String sql) {
        this.originalSql = sql;
        this.autoKeyType = 0;
    }

    public ReturnColumnResultSetMetaData(String sql, int[] cols) {
        this.originalSql = sql;
        this.autoKeyType = 1;
        this.colIndexes = cols;
    }

    public ReturnColumnResultSetMetaData(String sql, String[] colNames) {
        this.originalSql = sql;
        this.colNames = colNames;
        this.autoKeyType = 2;
    }

    public String getNewSql() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        switch (this.autoKeyType) {
            case 0: {
                this.newSql = this.originalSql + " RETURNING ROWID INTO " + '?';
                this.returnTypes = new int[1];
                this.returnTypes[0] = 32;
                this.autoKeyFields = new Field[1];
                this.autoKeyFields[0] = new Field(0, "ROWID", 32, 20, 0, 0, 0);
                break;
            }
            case 1: {
                this.autoKeyFields = new Field[this.colIndexes.length];
                this.getNewSqlByIndex();
                break;
            }
            case 2: {
                this.autoKeyFields = new Field[this.colNames.length];
                this.getNewSqlByNames();
            }
        }
        return this.newSql;
    }

    private int getReturnParamTypeCode(int index, String name, int[] colIndexes) throws SQLException {
        for (int i = 0; i < this.tableColumnNames.length; ++i) {
            if (!name.equalsIgnoreCase(this.tableColumnNames[i])) continue;
            colIndexes[index] = i + 1;
            return this.tableColumnTypes[i];
        }
        throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
    }

    private void getNewSqlByNames() throws SQLException {
        int i;
        if (this.tableColumnNames.length == 0) {
            throw SQLError.createSQLException(Messages.get("Table does not exist.", new Object[0]), YasState.UNDEFINED_TABLE);
        }
        this.returnTypes = new int[this.colNames.length];
        this.colIndexes = new int[this.colNames.length];
        StringBuilder stringBuilder = new StringBuilder(this.originalSql);
        stringBuilder.append(" RETURNING ");
        for (i = 0; i < this.colNames.length; ++i) {
            int columnType;
            this.returnTypes[i] = columnType = this.getReturnParamTypeCode(i, this.colNames[i], this.colIndexes);
            stringBuilder.append(this.colNames[i]);
            if (i < this.colNames.length - 1) {
                stringBuilder.append(", ");
            }
            int pos = this.colIndexes[i] - 1;
            this.autoKeyFields[i] = new Field(i, this.tableColumnNames[pos], this.tableColumnTypes[pos], this.tableMaxLengths[pos], this.tableNullables[pos] ? 1 : 0, this.tablePrecisions[pos], this.tableScales[pos]);
        }
        stringBuilder.append(" INTO ");
        for (i = 0; i < this.colNames.length - 1; ++i) {
            stringBuilder.append("?, ");
        }
        stringBuilder.append('?');
        this.newSql = new String(stringBuilder);
    }

    private void getNewSqlByIndex() throws YasException {
        int i;
        if (this.tableColumnNames.length == 0) {
            throw SQLError.createSQLException(Messages.get("Table does not exist.", new Object[0]), YasState.UNDEFINED_TABLE);
        }
        this.returnTypes = new int[this.colIndexes.length];
        StringBuilder stringBuilder = new StringBuilder(this.originalSql);
        stringBuilder.append(" RETURNING ");
        for (i = 0; i < this.colIndexes.length; ++i) {
            int pos = this.colIndexes[i] - 1;
            if (pos < 0 || pos >= this.tableColumnNames.length) {
                throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
            }
            int columnType = this.tableColumnTypes[pos];
            String columnName = this.tableColumnNames[pos];
            this.returnTypes[i] = columnType;
            stringBuilder.append(columnName.contains(" ") ? String.format("\"%s\"", columnName) : columnName);
            if (i < this.colIndexes.length - 1) {
                stringBuilder.append(", ");
            }
            this.autoKeyFields[i] = new Field(i, this.tableColumnNames[pos], this.tableColumnTypes[pos], this.tableMaxLengths[pos], this.tableNullables[pos] ? 1 : 0, this.tablePrecisions[pos], this.tableScales[pos]);
        }
        stringBuilder.append(" INTO ");
        for (i = 0; i < this.colIndexes.length - 1; ++i) {
            stringBuilder.append("?, ");
        }
        stringBuilder.append("?");
        this.newSql = new String(stringBuilder);
    }

    public boolean isInsert() throws YasException {
        if (this.sqlKind == SqlKind.UNINITIALIZED) {
            this.parseSQL();
        }
        return this.sqlKind == SqlKind.INSERT;
    }

    private void parseSQL() throws YasException {
        if (this.originalSql == null) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        if (this.parser == null) {
            this.parser = new YasSQL(this.originalSql);
        } else {
            this.parser.parseSQL(this.originalSql);
        }
        this.sqlKind = this.parser.getSqlKind();
    }

    public void initDescribedData(int count, List<String> colName, List<Integer> colType, List<Integer> maxLen, List<Boolean> nullable, List<Integer> precision, List<Integer> scale) throws SQLException {
        this.allocateSpaceForDescribedData(count);
        for (int i = 0; i < count; ++i) {
            this.fillDescribedData(i, colName.get(i), colType.get(i), maxLen.get(i), nullable.get(i), precision.get(i), scale.get(i));
        }
    }

    void allocateSpaceForDescribedData(int var1) throws SQLException {
        this.numColumns = var1;
        this.tableColumnNames = new String[var1];
        this.tableColumnTypes = new int[var1];
        this.tableMaxLengths = new int[var1];
        this.tableNullables = new boolean[var1];
        this.tablePrecisions = new int[var1];
        this.tableScales = new int[var1];
    }

    void fillDescribedData(int index, String name, int type, int len, boolean nullable, int precisions, int scale) throws SQLException {
        this.tableColumnNames[index] = name;
        this.tableColumnTypes[index] = type;
        this.tableMaxLengths[index] = len;
        this.tableNullables[index] = nullable;
        this.tablePrecisions[index] = precisions;
        this.tableScales[index] = scale;
    }

    String getTableName() throws SQLException {
        int end;
        int start;
        if (this.tableName != null) {
            return this.tableName;
        }
        String upperCase = this.originalSql.trim().toUpperCase();
        int pos = upperCase.indexOf("INSERT");
        if ((pos = upperCase.indexOf("INTO", pos)) < 0) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        int length = upperCase.length();
        for (start = pos + 5; start < length && upperCase.charAt(start) == ' '; ++start) {
        }
        if (start >= length) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        if (upperCase.charAt(start) == '\"') {
            int end2 = upperCase.indexOf(34, start + 1);
            if (start == end2) {
                throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
            }
            return this.originalSql.trim().substring(start, end2 + 1);
        }
        for (end = start; end < length && upperCase.charAt(end) != ' ' && upperCase.charAt(end) != '('; ++end) {
        }
        if (start >= end) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.tableName = upperCase.substring(start, end);
        return this.tableName;
    }
}

