/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.Field;

public class Row {
    final boolean forUpdate;
    byte[][] data;
    protected Field[] metadata;

    public Row(int length) {
        this(new byte[length][], true);
    }

    public Row(byte[][] data) {
        this(data, false);
    }

    private Row(byte[][] data, boolean forUpdate) {
        this.data = data;
        this.forUpdate = forUpdate;
    }

    public byte[] get(int index) {
        return this.data[index];
    }

    public Row updateableCopy() {
        return this.copy(true);
    }

    public Row readOnlyCopy() {
        return this.copy(false);
    }

    private Row copy(boolean forUpdate) {
        byte[][] dataCopy = new byte[this.data.length][];
        System.arraycopy(this.data, 0, dataCopy, 0, this.data.length);
        return new Row(dataCopy, forUpdate);
    }

    public void set(int index, byte[] fieldData) {
        if (!this.forUpdate) {
            throw new IllegalArgumentException("Attempted to write to readonly tuple");
        }
        this.data[index] = fieldData;
    }

    public void set(byte[][] data) {
        this.data = data;
    }

    public byte[][] get() {
        return this.data;
    }
}

