/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.Session;
import com.yashandb.SessionImpl;
import com.yashandb.YasResultSet;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.UpdatableRow;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.protocol.ExecuteResult;
import com.yashandb.protocol.Packet;
import java.sql.SQLException;
import java.util.ArrayList;

public class RowDataImpl
implements RowData {
    protected Session session;
    protected YasStatement stmt;
    protected Packet fromServer;
    protected long currRows;
    protected boolean hasMore;
    protected boolean hasRowID = false;
    protected long batchRows;
    protected int marginColumns;
    protected ArrayList<Row> rows;
    protected byte[][] marginRow;
    protected long fetchedRowCount = 0L;
    protected long maxRows = 0L;
    protected int arrayRowsSize = 0;
    protected boolean isReuse = false;

    public RowDataImpl(SessionImpl session, YasStatement stmt, Packet ack, ExecuteResult result) {
        this.session = session;
        this.stmt = stmt;
        this.fromServer = ack;
        this.batchRows = result.getBatchRows();
        this.marginColumns = result.getMarginColumns();
        this.hasMore = result.isHasMoreRows();
        this.currRows = -1L;
        this.rows = new ArrayList();
        this.marginRow = null;
        this.fetchedRowCount = this.batchRows;
    }

    @Override
    public void addRow(Row row) throws SQLException {
        this.rows.add(row);
        ++this.arrayRowsSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(byte[][] rowData) throws SQLException {
        ArrayList<Row> arrayList = this.rows;
        synchronized (arrayList) {
            if (this.isReuse && this.rows.size() > this.arrayRowsSize) {
                this.rows.get(this.arrayRowsSize).set(rowData);
                ++this.arrayRowsSize;
            } else if (this.hasRowID) {
                this.addRow(new UpdatableRow(rowData));
            } else {
                this.addRow(new Row(rowData));
            }
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void close() throws SQLException {
        this.session = null;
        this.stmt = null;
        this.fromServer = null;
    }

    @Override
    public Row getAt(long index) throws SQLException {
        if (index > Integer.MAX_VALUE) {
            throw SQLError.createSQLException("Not support resultsize greater than 2147483647", YasState.INVALID_PARAMETER_VALUE);
        }
        return this.rows.get((int)index);
    }

    @Override
    public long getFetchedRowCount() throws SQLException {
        return this.fetchedRowCount;
    }

    @Override
    public YasResultSet getOwner() {
        return null;
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.currRows < this.batchRows) {
            return true;
        }
        return this.currRows == this.batchRows && this.hasMore;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isDynamic() throws SQLException {
        return true;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        return this.isBeforeFirst() && this.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public void moveRowRelative(long rows) throws SQLException {
    }

    @Override
    public void absolute(long index) throws SQLException {
    }

    @Override
    public Row next() throws SQLException {
        if (this.currRows + 1L < this.batchRows) {
            return this.getAt(++this.currRows);
        }
        if (this.hasMore) {
            this.fetchMore();
            if (this.batchRows == 0L) {
                return null;
            }
            return this.getAt(++this.currRows);
        }
        return null;
    }

    protected void fetchMore() throws SQLException {
        this.currRows = -1L;
        this.arrayRowsSize = 0;
        this.isReuse = true;
        this.fetchMoreWithoutClear();
        this.isReuse = false;
    }

    protected void fetchMoreWithoutClear() throws SQLException {
        int lastMargin;
        block1: {
            Packet ack;
            while (true) {
                lastMargin = this.marginColumns;
                ack = this.session.fetch(this.stmt, this.stmt.getFetchSize());
                ExecuteResult result = new ExecuteResult(ack);
                result.getDMLError(ack);
                this.batchRows = result.getBatchRows();
                this.marginColumns = result.getMarginColumns();
                this.hasMore = result.isHasMoreRows();
                this.session.setTransactionState(result.getXactStatus());
                this.fromServer = ack;
                if (lastMargin <= 0) break block1;
                if (this.batchRows != 0L) break;
                this.fetchFromPacket(this.marginRow, ack, lastMargin, this.marginColumns);
            }
            this.fetchFromPacket(this.marginRow, ack, lastMargin, this.stmt.getColumnCount());
            this.addRow(this.marginRow);
            this.marginRow = null;
        }
        this.decodeRows(lastMargin > 0 ? 1 : 0);
        this.fetchedRowCount += this.batchRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRow(long index) throws SQLException {
        if (index >= 0L && index < (long)this.rows.size()) {
            ArrayList<Row> arrayList = this.rows;
            synchronized (arrayList) {
                this.rows.remove((int)index);
                --this.batchRows;
                --this.fetchedRowCount;
                --this.currRows;
                --this.arrayRowsSize;
            }
        }
    }

    @Override
    public void setCurrentRow(long rowNumber) throws SQLException {
        this.notSupported();
    }

    @Override
    public void setOwner(ResultSetImpl rs) {
    }

    @Override
    public long size() throws SQLException {
        return -1L;
    }

    @Override
    public void setMetadata(Field[] metadata) {
    }

    @Override
    public void decodeRows(int start) throws SQLException {
        int i = start;
        while ((long)i < this.batchRows) {
            byte[][] rowData = this.getReuseRowData();
            this.fetchFromPacket(rowData, this.fromServer, 0, this.stmt.getColumnCount());
            this.addRow(rowData);
            ++i;
        }
        if (this.marginColumns > 0) {
            byte[][] rowData = new byte[this.stmt.getColumnCount()][];
            this.fetchFromPacket(rowData, this.fromServer, 0, this.marginColumns);
            this.marginRow = rowData;
        }
    }

    private void notSupported() throws SQLException {
        throw new YasException("Operation not supported for streaming result sets", YasState.UNKNOWN_STATE);
    }

    private void fetchFromPacket(byte[][] row, Packet fetchFrom, int start, int end) {
        for (int i = start; i < end; ++i) {
            int len = fetchFrom.getRowSize();
            row[i] = (byte[])(len == 0 ? null : (this.isReuse && row[i] != null && row[i].length == len ? fetchFrom.getBytes(len, row[i]) : fetchFrom.getBytes(len)));
        }
    }

    @Override
    public long getPosition() {
        return this.currRows;
    }

    @Override
    public void setMaxRows(long maxRows) {
        this.maxRows = maxRows;
    }

    public void setHasRowID(boolean hasRowID) {
        this.hasRowID = hasRowID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow(Row row, long index) {
        ArrayList<Row> arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.set((int)index, row);
        }
    }

    @Override
    public void cacheAllRows() throws SQLException {
        while (this.hasMore) {
            this.fetchMoreWithoutClear();
        }
        this.batchRows = this.fetchedRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getReuseRowData() {
        ArrayList<Row> arrayList = this.rows;
        synchronized (arrayList) {
            if (this.isReuse && this.rows.size() > this.arrayRowsSize) {
                return this.rows.get(this.arrayRowsSize).get();
            }
            return new byte[this.stmt.getColumnCount()][];
        }
    }
}

