/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.CancelQueryTask;
import com.yashandb.CancelQueryTaskImpl;
import com.yashandb.ParameterList;
import com.yashandb.Query;
import com.yashandb.Session;
import com.yashandb.SimpleParameterList;
import com.yashandb.YasResultSet;
import com.yashandb.core.SqlKind;
import com.yashandb.exception.DatabaseError;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetFactory;
import com.yashandb.jdbc.ReturnColumnResultSetMetaData;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.RowDataFactory;
import com.yashandb.jdbc.StatementCancelState;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasInputStream;
import com.yashandb.jdbc.YasReturnColumnResultSet;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import com.yashandb.util.YasSQL;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;

public class StatementImpl
implements YasStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementImpl.class);
    private volatile boolean isClosed = false;
    protected int maxFieldSize = 0;
    protected long maxRows = 0L;
    protected boolean replaceProcessingEnabled = true;
    protected long timeout = 0L;
    protected volatile DatabaseError warnings = null;
    protected int fetchSize = 0;
    protected ArrayList<ParameterList> batchParameters = null;
    protected final int resultsetType;
    protected final int resultsetConcurrency;
    private final int rsHoldability;
    private boolean poolable;
    private boolean closeOnCompletion = false;
    protected int fetchdirection = 1000;
    protected final YasConnection connection;
    protected boolean autoGeneratedKeys = false;
    protected boolean hasPrepared = false;
    public boolean wantsGeneratedKeysAlways = false;
    private volatile StatementCancelState statementState = StatementCancelState.IDLE;
    private final Object cancelLock = new Object();
    private short stmtID = (short)-1;
    private String nativeSql;
    protected YasResultSet currentResultSet = null;
    private ArrayList<YasResultSet> implicitResultSets = null;
    private int curImplicitResultPos = -1;
    protected YasResultSet generatedKeysResults = null;
    protected ReturnColumnResultSetMetaData returnColRsMetaData;
    protected long updateCount = -1L;
    protected long lastInsertId = -1L;
    protected short columnCount;
    private Field[] resultFields;
    private YasInputStream statementStream;
    protected YasSQL yasSQL = null;
    protected Vector<String> batchSQLs;
    protected boolean isBatchError = false;
    protected Field[] parameterFields;
    protected ParameterList preparedParameters;
    protected Map<Integer, Field> outFieldsMap = null;
    protected Accessor[] accessors = null;
    protected Row outParameters = null;
    SqlKind sqlKind = SqlKind.UNINITIALIZED;
    int returnParamCount;

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeInternal(sql);
        return this.getQueryResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.cleanUpBeforeExecute();
        this.executeInternal(sql);
        return this.getExecuteUpdateResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        if (this.connection.isClosed()) {
            return;
        }
        this.connection.getSession().removeStatement(this);
        if (this.stmtID != -1) {
            this.connection.getSession().closeStmt(this.stmtID);
        }
        this.closeForNextExecution();
    }

    private void internalCloseStream() throws SQLException {
        try {
            this.statementStream.close();
        }
        catch (IOException exception) {
            throw SQLError.createSQLException("close stream fail ", YasState.IO_ERROR, (Throwable)exception);
        }
    }

    @Override
    public void addImplicitResultSet(YasResultSet resultSet) {
        if (this.implicitResultSets == null) {
            this.implicitResultSets = new ArrayList();
        }
        this.implicitResultSets.add(resultSet);
    }

    @Override
    public void reset() throws SQLException {
        this.stmtID = (short)-1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStream(YasInputStream stream) throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.statementStream == null) {
                return;
            }
            this.internalCloseStream();
            this.statementStream = stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drainStream() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.statementStream == null) {
                return;
            }
            this.internalCloseStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStream(int columnIndex) throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.statementStream == null || this.statementStream.getColumnIndex() >= columnIndex) {
                return;
            }
            this.internalCloseStream();
        }
    }

    @Override
    public int getID() {
        return this.stmtID;
    }

    @Override
    public Session getSession() {
        return this.connection.getSession();
    }

    @Override
    public void closeQuery() {
    }

    @Override
    public boolean isStatementDescribed() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Map<String, Integer> getResultSetColumnNameIndexMap() {
        return null;
    }

    @Override
    public Query[] getSubqueries() {
        return new Query[0];
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw SQLError.createSQLException(Messages.get("The maximum field size must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        long seconds = this.timeout / 1000L;
        if (seconds >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.setQueryTimeoutMs((long)seconds * 1000L);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        DatabaseError warnWrap = this.warnings;
        return warnWrap != null ? warnWrap.getFirstWarning() : null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.cleanUpBeforeExecute();
        return this.executeInternal(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.currentResultSet != null && this.currentResultSet.reallyResult()) {
                return this.currentResultSet;
            }
            if (this.implicitResultSets != null) {
                throw SQLError.createSQLException("No ResultSet is Available", YasState.DATA_ERROR);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            return (int)this.getLargeUpdateCount();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = direction;
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Invalid fetch direction constant: {0}.", direction), YasState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchdirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw SQLError.createSQLException(Messages.get("Fetch size must be a value greater to or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultsetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.addBatchSQL(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.clearBatchSQL();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return Utils.toIntArray(this.executeLargeBatch());
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            switch (current) {
                case 1: {
                    if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                    this.currentResultSet.close();
                    break;
                }
                case 2: {
                    if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                    this.currentResultSet.setKept(true);
                    this.currentResultSet = null;
                    break;
                }
                case 3: {
                    if (this.implicitResultSets == null) break;
                    for (int i = 0; i < this.curImplicitResultPos; ++i) {
                        YasResultSet resultSet = this.implicitResultSets.get(i);
                        if (resultSet.isClosed() || !resultSet.isKept()) continue;
                        resultSet.close();
                    }
                    break;
                }
                default: {
                    throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
                }
            }
            if (this.implicitResultSets == null) {
                return false;
            }
            ++this.curImplicitResultPos;
            if (this.curImplicitResultPos >= this.implicitResultSets.size()) {
                return false;
            }
            this.currentResultSet = this.implicitResultSets.get(this.curImplicitResultPos);
            return this.currentResultSet != null && this.currentResultSet.reallyResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.generatedKeysResults != null) {
                return this.generatedKeysResults;
            }
            this.generatedKeysResults = new YasReturnColumnResultSet(this);
            return this.generatedKeysResults;
        }
    }

    private void cleanUpBeforeExecute() throws SQLException {
        this.returnColRsMetaData = null;
        this.autoGeneratedKeys = false;
        this.returnParamCount = 0;
        this.generatedKeysResults = null;
        this.hasPrepared = false;
        this.preparedParameters = null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (int)this.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public void createParameterResult(Row outParameters) throws SQLException {
        this.outParameters = outParameters;
        this.accessors = AccessorFactory.generateAccessors(this.returnColRsMetaData.autoKeyFields, this.getSession());
        if (this.autoGeneratedKeys) {
            if (!this.returnColRsMetaData.withBatchInsert.booleanValue()) {
                RowData rowData = RowDataFactory.createStaticRow(outParameters);
                this.generatedKeysResults = new YasReturnColumnResultSet(this, this.returnColRsMetaData.autoKeyFields, rowData);
            } else {
                RowData rowData = RowDataFactory.createDynamicRow(outParameters);
                if (this.generatedKeysResults != null) {
                    YasReturnColumnResultSet tempResult = (YasReturnColumnResultSet)this.generatedKeysResults;
                    tempResult.addRow(outParameters);
                    this.generatedKeysResults = tempResult;
                } else {
                    this.generatedKeysResults = new YasReturnColumnResultSet(this, this.returnColRsMetaData.autoKeyFields, rowData);
                }
            }
        }
    }

    void autoKeyRegistParam() throws SQLException {
        for (int i = 0; i < this.returnParamCount; ++i) {
            int type = this.returnColRsMetaData.returnTypes[i];
            this.registerReturnParameterInternal(i, type);
        }
    }

    void registerReturnParameterInternal(int index, int returnType) throws SQLException {
        this.preparedParameters.registerOutParameter(index + 1, returnType);
    }

    private void autoKeyPrepare() throws SQLException {
        this.autoGeneratedKeys = true;
        this.connection.doDescribeTable(this.returnColRsMetaData);
        String newSql = this.returnColRsMetaData.getNewSql();
        switch (this.returnColRsMetaData.autoKeyType) {
            case 0: {
                this.returnParamCount = 1;
                break;
            }
            case 1: {
                this.returnParamCount = this.returnColRsMetaData.colIndexes.length;
                break;
            }
            case 2: {
                this.returnParamCount = this.returnColRsMetaData.colNames.length;
            }
        }
        this.connection.getSession().prepare(this, newSql);
        this.hasPrepared = true;
        this.autoKeyRegistParam();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        this.cleanUpBeforeExecute();
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(sql);
        if (autoGeneratedKeys == 2 || !this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            return this.execute(sql);
        }
        this.autoKeyPrepare();
        ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterLists);
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        this.cleanUpBeforeExecute();
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(sql, columnIndexes);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            return this.execute(sql);
        }
        this.autoKeyPrepare();
        ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterLists);
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        this.cleanUpBeforeExecute();
        if (columnNames == null || columnNames.length == 0) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(sql, columnNames);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            return this.execute(sql);
        }
        this.autoKeyPrepare();
        ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterLists);
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.currentResultSet == null) {
                return -1L;
            }
            if (this.currentResultSet.reallyResult() || this.currentResultSet.isClosed()) {
                return -1L;
            }
            return this.currentResultSet.getUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (max < 0L) {
                throw SQLError.createSQLException(Messages.get("Maximum number of rows must be a value grater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
            }
            this.maxRows = max;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.closeForNextExecution();
            int batchItemSize = this.getBatchSQLSize();
            LOGGER.debug("batchItemSize is " + batchItemSize);
            if (batchItemSize <= 0) {
                return new long[0];
            }
            long[] result = new long[batchItemSize];
            YasSQL tmpYasSQL = null;
            long rowCount = -1L;
            try {
                for (int i = 0; i < batchItemSize; ++i) {
                    String sql = this.getBatchSQL(i);
                    if (tmpYasSQL == null) {
                        tmpYasSQL = new YasSQL(sql);
                    } else {
                        tmpYasSQL.parseSQL(sql);
                    }
                    if (tmpYasSQL.isSELECT()) {
                        throw SQLError.createSQLException("invalid SELECT batch command " + i + ":" + sql, YasState.UNKNOWN_STATE);
                    }
                    try {
                        this.executeInternal(sql, true);
                        rowCount = this.currentResultSet.getUpdateCount();
                    }
                    catch (Exception e) {
                        int[] batchUpdateResult = new int[i];
                        for (int batchCnt = 0; batchCnt < i; ++batchCnt) {
                            batchUpdateResult[batchCnt] = (int)result[batchCnt];
                        }
                        throw new BatchUpdateException("Execute failed at batch command " + i + ":" + sql + " :" + e.getMessage(), batchUpdateResult);
                    }
                    result[i] = rowCount;
                }
            }
            finally {
                this.clearBatchSQL();
            }
            return result;
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.cleanUpBeforeExecute();
        this.executeInternal(sql);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.cleanUpBeforeExecute();
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(sql);
        if (autoGeneratedKeys == 2 || !this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            this.executeInternal(sql);
            return this.getExecuteLargeUpdateResult();
        }
        this.autoKeyPrepare();
        ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterLists);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.cleanUpBeforeExecute();
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(sql, columnIndexes);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            this.executeInternal(sql);
            return this.getExecuteLargeUpdateResult();
        }
        this.autoKeyPrepare();
        ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterLists);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.cleanUpBeforeExecute();
        if (columnNames == null || columnNames.length == 0) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(sql, columnNames);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            this.executeInternal(sql);
            return this.getExecuteLargeUpdateResult();
        }
        this.autoKeyPrepare();
        ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterLists);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean executeInternal(String sql) throws SQLException {
        return this.executeInternal(sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeInternal(String sql, boolean isBatch) throws SQLException {
        if (sql == null || sql.trim().isEmpty()) {
            throw SQLError.createSQLException("SQL String cannot be NULL or empty", YasState.INVALID_PARAMETER_TYPE);
        }
        this.nativeSql = sql = sql.trim();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.closeForNextExecution();
            if (!isBatch) {
                this.checkIfBatchExists();
            }
            if (this.resultsetConcurrency == 1008 || this.resultsetType == 1005) {
                this.yasSQL = this.buildYasSQL(sql);
                if (this.yasSQL.canUpdatable() || this.yasSQL.canScrollSensitive()) {
                    this.nativeSql = sql = this.yasSQL.getRowIDAppendSQL();
                }
            }
            if (this.timeout > 0L) {
                CancelQueryTask cancelQueryTask = null;
                try {
                    cancelQueryTask = this.startTimer();
                    if (this.preparedParameters != null) {
                        ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
                        this.currentResultSet = this.connection.getSession().directExecute(this, sql, parameterLists);
                    }
                    this.currentResultSet = this.connection.getSession().directExecute(this, sql);
                }
                finally {
                    this.killTimerTask(cancelQueryTask);
                }
            } else if (this.preparedParameters != null) {
                ParameterList[] parameterLists = new ParameterList[]{this.preparedParameters};
                this.currentResultSet = this.connection.getSession().directExecute(this, sql, parameterLists);
            } else {
                this.currentResultSet = this.connection.getSession().directExecute(this, sql);
            }
        }
        if (this.preparedParameters != null) {
            this.preparedParameters.clear();
            this.preparedParameters = null;
        }
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        Object object = this.cancelLock;
        synchronized (object) {
            this.connection.cancelQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet getQueryResultSet() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.currentResultSet.getNextResultSet() != null) {
                throw SQLError.createSQLException(Messages.get("Multiple ResultSets were returned by the query.", new Object[0]), YasState.TOO_MANY_RESULTS);
            }
            this.currentResultSet.setStmtQueryResult(true);
            return this.currentResultSet;
        }
    }

    StatementImpl(ConnectionImpl c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.connection = c;
        this.resultsetType = rsType;
        this.resultsetConcurrency = rsConcurrency;
        this.setFetchSize(c.getDefaultFetchSize());
        this.rsHoldability = rsHoldability;
        this.connection.getSession().addStatement(this);
    }

    @Override
    public YasResultSet createResultSet(RowData rowData) throws SQLException {
        int resultSetType = this.getResultSetType();
        int resultSetConcurrency = this.getResultSetConcurrency();
        return ResultSetFactory.createResultSet(this, this.resultFields, rowData, this.getMaxRows(), this.getMaxFieldSize(), resultSetType, resultSetConcurrency, this.getResultSetHoldability());
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This Statement has been closed.", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
        }
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("The Connection of this Statement has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeForNextExecution() throws SQLException {
        this.clearWarnings();
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            if (this.currentResultSet != null && !this.currentResultSet.isClosed()) {
                boolean isRealResult = this.currentResultSet.reallyResult();
                this.currentResultSet.close();
                if (this.closeOnCompletion && isRealResult) {
                    throw SQLError.createSQLException(Messages.get("this statement has been closed", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
                }
            }
            if (this.implicitResultSets != null) {
                for (YasResultSet resultSet : this.implicitResultSets) {
                    if (resultSet.isClosed()) continue;
                    resultSet.close();
                }
            }
            this.implicitResultSets = null;
            this.curImplicitResultPos = -1;
        }
    }

    private void setQueryTimeoutMs(long millis) throws SQLException {
        this.checkClosed();
        if (millis < 0L) {
            throw SQLError.createSQLException(Messages.get("Query timeout must be a value greater than or equals to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = millis;
    }

    protected void executeInternal(ParameterList[] queryParameters) throws SQLException {
        this.executeInternal(queryParameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(ParameterList[] queryParameters, boolean isBatch) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.closeForNextExecution();
            if (!isBatch) {
                this.checkIfBatchExists();
            }
            if (this.timeout > 0L) {
                CancelQueryTask cancelQueryTask = null;
                try {
                    cancelQueryTask = this.startTimer();
                    if (this.hasPrepared) {
                        this.currentResultSet = this.connection.getSession().execute(this, queryParameters, 0, 0, 0);
                    }
                    this.currentResultSet = this.connection.getSession().directExecute(this, this.getSql(), queryParameters);
                }
                finally {
                    this.killTimerTask(cancelQueryTask);
                }
            } else {
                this.currentResultSet = this.hasPrepared ? this.connection.getSession().execute(this, queryParameters, 0, 0, 0) : this.connection.getSession().directExecute(this, this.getSql(), queryParameters);
            }
            this.hasPrepared = true;
        }
    }

    protected void checkIfBatchExists() throws SQLException {
        if (this.getBatchSQLSize() > 0) {
            throw SQLError.createSQLException("batch must be either executed or cleared", YasState.UNEXPECTED_ERROR);
        }
    }

    protected CancelQueryTask startTimer() {
        if (this.timeout == 0L) {
            return null;
        }
        CancelQueryTaskImpl cancelTask = new CancelQueryTaskImpl(this);
        this.connection.getTimer().schedule((TimerTask)cancelTask, this.timeout);
        return cancelTask;
    }

    protected void killTimerTask(CancelQueryTask task) {
        if (task != null) {
            task.cancel();
        }
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsetType != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }

    protected ResultSet query() throws SQLException {
        this.executeInternal(this.nativeSql);
        return this.currentResultSet;
    }

    public void setStmtID(short stmtID, byte sqlKind) {
        this.stmtID = stmtID;
        this.sqlKind = SqlKind.valueOf(sqlKind);
    }

    public void setFields(Field[] fields) {
        this.columnCount = fields == null ? (short)0 : (short)fields.length;
        this.resultFields = fields;
    }

    protected Field[] getFields() {
        return this.resultFields;
    }

    @Override
    public void setParameters(Field[] parameterFields) throws SQLException {
        this.parameterFields = parameterFields;
        if (this.preparedParameters == null || this.preparedParameters.getParameterCount() != parameterFields.length) {
            this.preparedParameters = new SimpleParameterList(parameterFields.length);
            this.preparedParameters.setCharset(this.getSession().getCharset());
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    protected YasSQL buildYasSQL(String originalSql) {
        if (this.resultsetType == 1005 || this.resultsetConcurrency == 1008) {
            return new YasSQL(originalSql);
        }
        return null;
    }

    protected YasSQL getYasSQL() {
        return this.yasSQL;
    }

    protected int getExecuteUpdateResult() throws SQLException {
        this.checkClosed();
        long updateCount = this.getExecuteLargeUpdateResult();
        return updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)updateCount;
    }

    protected long getExecuteLargeUpdateResult() throws SQLException {
        this.checkClosed();
        if (this.currentResultSet != null && this.currentResultSet.reallyResult()) {
            return this.currentResultSet.getFetchedRowCount();
        }
        return (int)this.getLargeUpdateCount();
    }

    protected void addBatchSQL(String sql) {
        if (this.batchSQLs == null) {
            this.batchSQLs = new Vector();
        }
        this.batchSQLs.add(sql);
    }

    protected int getBatchSQLSize() {
        if (this.batchSQLs == null) {
            return 0;
        }
        return this.batchSQLs.size();
    }

    String getBatchSQL(int index) {
        if (this.batchSQLs == null) {
            return null;
        }
        return this.batchSQLs.elementAt(index);
    }

    void clearBatchSQL() {
        if (this.batchSQLs != null) {
            this.batchSQLs.removeAllElements();
        }
    }

    @Override
    public boolean getIsBatchError() {
        return this.isBatchError;
    }

    @Override
    public void setIsBatchError(boolean batchError) {
        this.isBatchError = batchError;
    }

    @Override
    public String getBatchError(int batchIndex) {
        if (this.currentResultSet != null) {
            return this.currentResultSet.getBatchError(batchIndex);
        }
        return null;
    }

    protected String getSql() {
        return this.nativeSql;
    }
}

