/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasResultSet;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.exception.SQLError;
import java.sql.SQLException;

public class StaticRowData
implements RowData {
    Row staticRow;
    int curr;
    int rowCount;

    StaticRowData(Row row) {
        this.staticRow = row;
        this.curr = -1;
        this.rowCount = 1;
    }

    @Override
    public void addRow(Row row) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "addRow");
    }

    @Override
    public void afterLast() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "afterLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "beforeFirst");
    }

    @Override
    public void beforeLast() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "beforeLast");
    }

    @Override
    public void close() throws SQLException {
        this.staticRow = null;
    }

    @Override
    public Row getAt(long index) throws SQLException {
        if (index == 1L) {
            return this.staticRow;
        }
        return null;
    }

    @Override
    public long getFetchedRowCount() throws SQLException {
        return 1L;
    }

    @Override
    public YasResultSet getOwner() {
        return null;
    }

    @Override
    public boolean hasNext() throws SQLException {
        return this.curr + 1 < this.rowCount;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isDynamic() throws SQLException {
        return false;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public void moveRowRelative(long rows) throws SQLException {
    }

    @Override
    public Row next() throws SQLException {
        if (this.curr >= this.rowCount) {
            return null;
        }
        ++this.curr;
        return this.staticRow;
    }

    @Override
    public void removeRow(long index) throws SQLException {
    }

    @Override
    public void setCurrentRow(long rowNumber) throws SQLException {
    }

    @Override
    public void setOwner(ResultSetImpl rs) {
    }

    @Override
    public long size() throws SQLException {
        return this.rowCount;
    }

    @Override
    public void setMetadata(Field[] metadata) {
    }

    @Override
    public void decodeRows(int start) throws SQLException {
    }

    @Override
    public long getPosition() {
        return this.curr;
    }

    @Override
    public void setMaxRows(long maxRows) {
    }

    @Override
    public void absolute(long index) throws SQLException {
    }

    @Override
    public void refreshRow(Row row, long index) {
    }
}

