/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.UpdatableRow;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasRowID;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.Messages;
import com.yashandb.util.YasSQL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;

public class UpdatableResultSet
extends ResultSetImpl {
    protected YasSQL yasSQL = null;
    protected PreparedStatement updatePreparedStatement = null;
    protected PreparedStatement insertPreparedStatement = null;
    protected PreparedStatement deletePreparedStatement = null;
    protected PreparedStatement refreshPreparedStatement = null;
    protected Field[] originalfields;
    protected Row savedCurrentRow;
    ResultSetMetaData resultSetmetaData = null;
    protected int updateCount = 0;
    protected int deleteCount = 0;
    protected int insertCount = 0;

    public UpdatableResultSet(StatementImpl originalQuery, Field[] fields, RowData rows, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability, YasSQL yasSQL) throws SQLException {
        super(originalQuery, fields, rows, maxRows, maxFieldSize, rsType, rsConcurrency, rsHoldability);
        this.yasSQL = yasSQL;
        this.updatable = true;
        this.originalfields = this.fields;
        this.fields = this.detachRowIDFromFields(this.fields);
        this.accessors = this.detachRowIDFromAccessors(this.accessors);
        this.resultSetmetaData = this.getMetaData();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
        this.onInsertRow = true;
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.savedCurrentRow = this.thisRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClosed();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            if (this.onInsertRow) {
                this.onInsertRow = false;
                this.thisRow = this.savedCurrentRow;
            }
            if (this.thisRow == null && this.currentRow > -1L) {
                this.thisRow = this.rowData.getAt(this.currentRow);
            }
        }
    }

    @Override
    protected void checkUpdatable() throws SQLException {
        super.checkUpdatable();
        if (!this.onInsertRow && !this.doingUpdates) {
            this.doingUpdates = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkUpdatable();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            if (!this.onInsertRow) {
                throw SQLError.createSQLException("Please move to insert row first", YasState.UNKNOWN_STATE);
            }
            if (this.updateValues.size() == 0) {
                throw SQLError.createSQLException("No data to insert", YasState.UNKNOWN_STATE);
            }
            boolean[] updateColumn = new boolean[this.resultSetmetaData.getColumnCount()];
            for (int i = 0; i < this.resultSetmetaData.getColumnCount(); ++i) {
                updateColumn[i] = this.updateValues.containsKey(this.resultSetmetaData.getColumnName(i + 1));
            }
            if (this.insertPreparedStatement != null) {
                this.insertPreparedStatement.close();
            }
            String insertSql = this.yasSQL.getInsertSQL(this.resultSetmetaData, updateColumn);
            this.insertPreparedStatement = this.connection.prepareStatement(insertSql);
            int setCount = 1;
            for (int i = 0; i < this.resultSetmetaData.getColumnCount(); ++i) {
                int scaleLength;
                if (!updateColumn[i]) continue;
                String columnName = this.resultSetmetaData.getColumnName(i + 1);
                int n = scaleLength = this.updateScales.get(columnName) == null ? -1 : (Integer)this.updateScales.get(columnName);
                if (this.updateSQLTypes.containsKey(columnName)) {
                    this.insertPreparedStatement.setObject(setCount++, this.updateValues.get(columnName), (SQLType)this.updateSQLTypes.get(columnName), scaleLength);
                    continue;
                }
                this.insertPreparedStatement.setObject(setCount++, this.updateValues.get(columnName), this.resultSetmetaData.getColumnType(i + 1), scaleLength);
            }
            this.insertCount = this.insertPreparedStatement.executeUpdate();
            this.insertPreparedStatement.close();
            this.insertPreparedStatement = null;
            this.clearRowBuffer(false);
            this.onInsertRow = false;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.refreshRow(((UpdatableRow)this.thisRow).getRowID());
        if (this.thisRow != null) {
            this.rowData.refreshRow(this.thisRow, this.currentRow);
        }
    }

    public void refreshRow(byte[] rowID) throws SQLException {
        if (this.refreshPreparedStatement == null) {
            String refreshSql = this.yasSQL.getRefreshSQL(this.resultSetmetaData);
            this.refreshPreparedStatement = this.connection.prepareStatement(refreshSql);
        }
        this.refreshPreparedStatement.setString(1, new YasRowID(rowID).toString());
        ResultSet rs = this.refreshPreparedStatement.executeQuery();
        if (rs.next()) {
            if (this.thisRow == null) {
                this.thisRow = this.savedCurrentRow;
            }
            for (int i = 1; i < this.thisRow.data.length; ++i) {
                this.thisRow.data[i] = rs.getBytes(i + 1);
            }
        } else {
            throw SQLError.createSQLException("Can't refresh the row data,may be the row is deleted", YasState.UNKNOWN_STATE);
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkUpdatable();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.doUpdate();
            if (this.updateCount > 0) {
                this.refreshRow();
            }
        }
    }

    public void doUpdate() throws SQLException {
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw SQLError.createSQLException("On insert row", YasState.UNKNOWN_STATE);
        }
        if (!this.doingUpdates) {
            throw SQLError.createSQLException("No update data", YasState.UNKNOWN_STATE);
        }
        if (this.thisRow == null) {
            throw SQLError.createSQLException("Current row is invalid", YasState.UNKNOWN_STATE);
        }
        if (this.updateValues.size() == 0) {
            return;
        }
        boolean[] updateColumn = new boolean[this.resultSetmetaData.getColumnCount()];
        for (int i = 0; i < this.resultSetmetaData.getColumnCount(); ++i) {
            updateColumn[i] = this.updateValues.containsKey(this.resultSetmetaData.getColumnName(i + 1));
        }
        if (this.updatePreparedStatement != null) {
            this.updatePreparedStatement.close();
        }
        String updateSql = this.yasSQL.getUpdateSQL(this.resultSetmetaData, updateColumn);
        this.updatePreparedStatement = this.connection.prepareStatement(updateSql);
        int setCount = 1;
        for (int i = 0; i < this.resultSetmetaData.getColumnCount(); ++i) {
            int scaleLength;
            if (!updateColumn[i]) continue;
            String columnName = this.resultSetmetaData.getColumnName(i + 1);
            int n = scaleLength = this.updateScales.get(columnName) == null ? -1 : (Integer)this.updateScales.get(columnName);
            if (this.updateSQLTypes.containsKey(columnName)) {
                this.updatePreparedStatement.setObject(setCount++, this.updateValues.get(columnName), (SQLType)this.updateSQLTypes.get(columnName), scaleLength);
                continue;
            }
            this.updatePreparedStatement.setObject(setCount++, this.updateValues.get(columnName), this.resultSetmetaData.getColumnType(i + 1), scaleLength);
        }
        this.updatePreparedStatement.setString(setCount, new YasRowID(((UpdatableRow)this.thisRow).getRowID()).toString());
        this.updateCount = this.updatePreparedStatement.executeUpdate();
        this.updatePreparedStatement.close();
        this.updatePreparedStatement = null;
        this.doingUpdates = false;
        this.clearRowBuffer(false);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable();
        this.updateValues.put(this.resultSetmetaData.getColumnName(columnIndex), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkUpdatable();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.doDelete();
            if (this.deleteCount > 0) {
                this.thisRow = null;
                this.rowData.removeRow(this.currentRow);
                --this.currentRow;
            }
        }
    }

    public void doDelete() throws SQLException {
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw SQLError.createSQLException("On insert row", YasState.UNKNOWN_STATE);
        }
        if (this.rowDeleted() || this.thisRow == null) {
            throw SQLError.createSQLException("Current row is invalid", YasState.UNKNOWN_STATE);
        }
        if (this.deletePreparedStatement == null) {
            String deleteSql = this.yasSQL.getDeleteSQL();
            this.deletePreparedStatement = this.connection.prepareStatement(deleteSql);
        }
        this.deletePreparedStatement.setString(1, new YasRowID(((UpdatableRow)this.thisRow).getRowID()).toString());
        this.deleteCount = this.deletePreparedStatement.executeUpdate();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw SQLError.createSQLException(Messages.get("Cannot call cancelRowUpdates() when on the insert row.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer(true);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return this.deleteCount > 0;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return this.insertCount > 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.updateCount > 0;
    }

    @Override
    protected void closeInternally() throws SQLException {
        super.closeInternally();
        if (this.updatePreparedStatement != null) {
            this.updatePreparedStatement.close();
        }
        if (this.insertPreparedStatement != null) {
            this.insertPreparedStatement.close();
        }
        if (this.deletePreparedStatement != null) {
            this.deletePreparedStatement.close();
        }
        if (this.refreshPreparedStatement != null) {
            this.refreshPreparedStatement.close();
        }
    }

    Field[] detachRowIDFromFields(Field[] fields) {
        Field[] tempFields = new Field[fields.length - 1];
        System.arraycopy(fields, 1, tempFields, 0, fields.length - 1);
        return tempFields;
    }

    Accessor[] detachRowIDFromAccessors(Accessor[] accessors) {
        Accessor[] tempAccessors = new Accessor[accessors.length - 1];
        System.arraycopy(accessors, 1, tempAccessors, 0, accessors.length - 1);
        return tempAccessors;
    }

    private void clearUpdateCount() {
        this.updateCount = 0;
        this.insertCount = 0;
        this.deleteCount = 0;
    }

    @Override
    public boolean next() throws SQLException {
        this.clearUpdateCount();
        this.clearRowBuffer(false);
        this.onInsertRow = false;
        this.doingUpdates = false;
        return super.next();
    }

    @Override
    protected void prepareMove() throws SQLException {
        super.prepareMove();
        this.clearUpdateCount();
        this.clearRowBuffer(false);
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            boolean isDeleted = this.rowDeleted();
            if (isDeleted) {
                this.checkScrollable();
                this.prepareMove();
                this.currentRow = this.rowData.getPosition();
                if (this.currentRow <= -1L) {
                    return false;
                }
            } else {
                return super.previous();
            }
            this.thisRow = this.rowData.getAt(this.currentRow);
            return true;
        }
    }

    @Override
    protected void updateValue(int columnIndex, Object value, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkUpdatable();
        if (!this.onInsertRow && (this.isBeforeFirst() || this.isAfterLast() || this.rowData.isEmpty())) {
            throw SQLError.createSQLException(Messages.get("Cannot update the ResultSet because it is either before the start or after the end of the results.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(columnIndex);
        this.doingUpdates = !this.onInsertRow;
        ResultSetMetaData md = this.resultSetmetaData;
        if (value == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateValues.put(md.getColumnName(columnIndex), value);
        }
        if (targetSqlType != null) {
            this.updateSQLTypes.put(md.getColumnName(columnIndex), targetSqlType);
        } else {
            this.updateSQLTypes.remove(md.getColumnName(columnIndex));
        }
        if (scaleOrLength != 0) {
            this.updateScales.put(md.getColumnName(columnIndex), scaleOrLength);
        } else {
            this.updateScales.remove(md.getColumnName(columnIndex));
        }
    }
}

