/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.YasBlobOutputStream;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.YasLobInputStream;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class YasBlob
implements Blob,
YasLargeObject {
    private YasLobProcessor lobProcessor = null;
    private YasConnection connection = null;
    private boolean isTempLob = false;
    private boolean isFree = false;
    private boolean inValid = false;

    public YasBlob(boolean isTempLob) {
        this.isTempLob = isTempLob;
    }

    public void setLobProcessor(YasLobProcessor processor) {
        this.lobProcessor = processor;
        this.lobProcessor.setLobType(30);
        this.lobProcessor.setYasLob(this);
    }

    public YasLobProcessor getLobProcessor() {
        return this.lobProcessor;
    }

    private void checkClosed() throws SQLException {
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (this.isFree) {
            throw SQLError.createSQLException("the lob has been freed", YasState.DATA_ERROR);
        }
        if (this.inValid) {
            throw SQLError.createSQLException("the lob is inValid", YasState.DATA_ERROR);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getLobLength();
    }

    @Override
    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getBytes(pos, length);
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        return new YasLobInputStream(this);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(byte[] pattern, long start)");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(Blob pattern, long start)");
    }

    private void checkPos(long pos) throws SQLException {
        if (pos < 1L) {
            throw SQLError.createSQLException("invalid parameter, ''pos'' should not be < 1", YasState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            if (pos != this.length() + 1L) {
                throw SQLError.createSQLException("temp lob write only support append mode, ''pos'' should be lob length + 1", YasState.INVALID_PARAMETER_VALUE);
            }
        } else if (pos > this.length() + 1L) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be > lob length + 1", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkClosed();
        this.checkPos(pos);
        if (bytes == null) {
            return 0;
        }
        this.preProcessTempInRowLob();
        return this.lobProcessor.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkClosed();
        this.checkPos(pos);
        if (bytes == null) {
            return 0;
        }
        if (offset < 0 || offset >= bytes.length || len <= 0 || offset + len > bytes.length) {
            throw SQLError.createSQLException("parameter ''offset'' or ''len'' is invalid", YasState.INVALID_PARAMETER_VALUE);
        }
        if (!this.supportUpdateKnlLob()) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBytes(long pos, byte[] bytes, int offset, int len)");
        }
        this.preProcessTempInRowLob();
        return this.lobProcessor.setBytes(pos, bytes, offset, len);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkClosed();
        this.checkPos(pos);
        return new YasBlobOutputStream(this, pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "truncate(long len)");
        }
        this.checkClosed();
        if (len < 0L || len > this.length()) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should be between 0 and lob length", YasState.INVALID_PARAMETER_VALUE);
        }
        this.preProcessTempInRowLob();
        this.lobProcessor.truncate(len);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (!this.isFree) {
            if (this.isTempLob) {
                this.lobProcessor.free();
            } else {
                this.connection.getSession().removeUpdatedKnlLob(this);
            }
            this.isFree = true;
        }
    }

    @Override
    public void setConnection(YasConnection connection) {
        this.connection = connection;
    }

    @Override
    public void freeTemp() throws SQLException {
        this.free();
    }

    @Override
    public int getStepSize() throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getStepSize();
    }

    @Override
    public synchronized int getBytes(long lobOffset, byte[] data) throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getBytes(lobOffset, data);
    }

    @Override
    public long getLobLength() throws SQLException {
        return this.length();
    }

    private void checkStreamParameters(long pos, long length) throws SQLException {
        long lobLength = this.getLobLength();
        if (pos < 1L || pos > lobLength || length < 0L || pos + length - 1L > lobLength) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkClosed();
        this.checkStreamParameters(pos, length);
        return new YasLobInputStream(this, pos, length);
    }

    @Override
    public int writeBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return this.setBytes(pos, bytes, offset, len);
    }

    private void preProcessTempInRowLob() throws SQLException {
        if (this.lobProcessor.getInnerLobType() != 4) {
            return;
        }
        YasBlob tempBlob = (YasBlob)this.connection.createBlob();
        tempBlob.setBytes(1L, this.getBytes(1L, (int)this.length()));
        this.setLobProcessor(tempBlob.getLobProcessor());
        this.isTempLob = true;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.inValid = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.lobProcessor.setUpdated(false);
        }
    }

    public byte[] getLobLocator() {
        return this.lobProcessor.getLobLocator();
    }

    private boolean supportUpdateKnlLob() {
        return this.isTempLob || this.connection.getSession().getConnectVersion() != ConnectVersion.VER1;
    }
}

