/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.PreparedStatementImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.protocol.accessor.LobAccessor;
import com.yashandb.util.Messages;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class YasCallableStatement
extends PreparedStatementImpl
implements CallableStatement {
    private boolean wasNullFlag = false;

    YasCallableStatement(ConnectionImpl connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, rsType, rsConcurrency, rsHoldability);
        if (!this.hasPrepared) {
            this.serverPrepare(this.preparedSQL);
        }
        this.outFieldsMap = new TreeMap();
    }

    @Override
    public void createParameterResult(Row outParameters) throws SQLException {
        if (this.autoGeneratedKeys) {
            super.createParameterResult(outParameters);
            return;
        }
        Field[] outFields = new Field[this.outFieldsMap.size()];
        Iterator iterator = this.outFieldsMap.entrySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((Field)entry.getValue()).setId(index);
            outFields[index] = (Field)entry.getValue();
            ++index;
        }
        this.outParameters = outParameters;
        this.accessors = AccessorFactory.generateAccessors(outFields, this.getSession());
    }

    private void checkOutParamIndex(int outIndex) throws SQLException {
        if (this.outFieldsMap == null || !this.outFieldsMap.containsKey(outIndex)) {
            throw SQLError.createSQLException("invalid parameter index", YasState.DATA_ERROR);
        }
    }

    private void checkColumnIndex(int column) throws SQLException {
        if (this.parameterFields == null) {
            throw SQLError.createSQLException("no parameters", YasState.INVALID_PARAMETER_VALUE);
        }
        if (column < 1 || column > this.parameterFields.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", column, this.parameterFields.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(parameterIndex);
        int yashanType = YasTypes.getYasType(sqlType);
        int internalIndex = parameterIndex - 1;
        this.parameterFields[internalIndex].setYasType(yashanType);
        this.preparedParameters.registerOutParameter(parameterIndex, yashanType);
        this.outFieldsMap.put(parameterIndex, this.parameterFields[internalIndex]);
    }

    @Override
    public void clearParameters() throws SQLException {
        super.clearParameters();
        this.outFieldsMap.clear();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    private void checkResult(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(parameterIndex);
        this.checkOutParamIndex(parameterIndex);
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        if (this.outParameters == null) {
            throw SQLError.createSQLException("invalid parameter index", YasState.DATA_ERROR);
        }
        this.wasNullFlag = this.outParameters.get(index) == null;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        byte[] bytes = this.outParameters.get(index);
        if (this.accessors[index] instanceof LobAccessor) {
            return this.accessors[index].getString(bytes);
        }
        return this.accessors[index].getString(this.truncBytes(bytes));
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return false;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getBoolean(this.outParameters.get(index));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getByte(this.outParameters.get(index));
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getShort(this.outParameters.get(index));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getInt(this.outParameters.get(index));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return 0L;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getLong(this.outParameters.get(index));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return 0.0f;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getFloat(this.outParameters.get(index));
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return 0.0;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getDouble(this.outParameters.get(index));
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getBigDecimal(this.outParameters.get(index));
    }

    private byte[] truncBytes(byte[] bytes) throws SQLException {
        int bytesLen = bytes.length;
        if (this.maxFieldSize > 0 && bytesLen > this.maxFieldSize) {
            bytesLen = this.maxFieldSize;
        }
        byte[] newBytes = new byte[bytesLen];
        System.arraycopy(bytes, 0, newBytes, 0, bytesLen);
        return newBytes;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getBytes(this.truncBytes(this.outParameters.get(index)));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getDate(this.outParameters.get(index), null);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getTime(this.outParameters.get(index), null);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getTimestamp(this.outParameters.get(index), null);
    }

    private Object internalGetObject(int columnIndex) throws SQLException {
        Field field = (Field)this.outFieldsMap.get(columnIndex);
        int sqlType = field.getSQLType();
        switch (sqlType) {
            case -7: 
            case 16: {
                int index = ((Field)this.outFieldsMap.get(columnIndex)).getId();
                if (this.outParameters.get(index).length > 1) {
                    return this.getBytes(columnIndex);
                }
                return this.getBoolean(columnIndex);
            }
            case 2009: {
                return this.getSQLXML(columnIndex);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex, field.getScale());
            }
            case 7: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return this.getDouble(columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 3001: 
            case 3002: {
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
            case -8: {
                return this.getRowId(columnIndex);
            }
            case 2012: 
            case 3008: {
                return this.getCursor(columnIndex);
            }
        }
        return null;
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return this.internalGetObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getBigDecimal(this.outParameters.get(index));
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(int parameterIndex, Map<String, Class<?>> map)");
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRef(int parameterIndex)");
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getBlob(this.outParameters.get(index), this.getSession());
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getClob(this.outParameters.get(index), this.getSession());
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getArray(int parameterIndex)");
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getDate(this.outParameters.get(index), cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getTime(this.outParameters.get(index), cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getTimestamp(this.outParameters.get(index), cal);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(int parameterIndex, int sqlType, String typeName)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(String parameterName, int sqlType)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(String parameterName, int sqlType, int scale)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(String parameterName, int sqlType, String typeName)");
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getURL(int parameterIndex)");
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setURL(String parameterName, URL val)");
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNull(String parameterName, int sqlType)");
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBoolean(String parameterName, boolean x)");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setByte(String parameterName, byte x)");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setShort(String parameterName, short x)");
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setInt(String parameterName, int x)");
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setLong(String parameterName, long x)");
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setFloat(String parameterName, float x)");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setDouble(String parameterName, double x)");
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBigDecimal(String parameterName, BigDecimal x)");
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setString(String parameterName, String x)");
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBytes(String parameterName, byte[] x)");
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setDate(String parameterName, Date x)");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTime(String parameterName, Time x)");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTimestamp(String parameterName, Timestamp x)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(String parameterName, InputStream x, int length)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBinaryStream(String parameterName, InputStream x, int length)");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setObject(String parameterName, Object x, int targetSqlType, int scale)");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setObject(String parameterName, Object x, int targetSqlType)");
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setObject(String parameterName, Object x)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setCharacterStream(String parameterName, Reader reader, int length)");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setDate(String parameterName, Date x, Calendar cal)");
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTime(String parameterName, Time x, Calendar cal)");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTimestamp(String parameterName, Timestamp x, Calendar cal)");
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNull(String parameterName, int sqlType, String typeName)");
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getString(String parameterName)");
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBoolean(String parameterName)");
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getByte(String parameterName)");
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getShort(String parameterName)");
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getInt(String parameterName)");
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getLong(String parameterName)");
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getFloat(String parameterName)");
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getDouble(String parameterName)");
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBytes(String parameterName)");
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getDate(String parameterName)");
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTime(String parameterName)");
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTimestamp(String parameterName)");
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(String parameterName)");
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBigDecimal(String parameterName)");
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(String parameterName, Map<String, Class<?>> map)");
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRef(String parameterName) ");
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBlob(String parameterName)");
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getClob(String parameterName)");
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getArray(String parameterName)");
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getDate(String parameterName, Calendar cal)");
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTime(String parameterName, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTimestamp(String parameterName, Calendar cal)");
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getURL(String parameterName)");
    }

    private ResultSet getCursor(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getCursor(this.outParameters.get(index), (YasConnection)this.getConnection());
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        this.checkResult(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int index = ((Field)this.outFieldsMap.get(parameterIndex)).getId();
        return this.accessors[index].getRowId(this.outParameters.get(index));
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRowId(String parameterName)");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setRowId(String parameterName, RowId x)");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNString(String parameterName, String value)");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNCharacterStream(String parameterName, Reader value, long length)");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(String parameterName, NClob value)");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(String parameterName, Reader reader, long length)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBlob(String parameterName, InputStream inputStream, long length)");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(String parameterName, Reader reader, long length)");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNClob(int parameterIndex)");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNClob(String parameterName)");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setSQLXML(String parameterName, SQLXML xmlObject)");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getSQLXML(int parameterIndex)");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getSQLXML(String parameterName)");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNString(int parameterIndex)");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNString(String parameterName)");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNCharacterStream(int parameterIndex)");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNCharacterStream(String parameterName)");
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getCharacterStream(int parameterIndex)");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getCharacterStream(String parameterName)");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBlob(String parameterName, Blob x)");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(String parameterName, Clob x)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(String parameterName, InputStream x, long length)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBinaryStream(String parameterName, InputStream x, long length)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setCharacterStream(String parameterName, Reader reader, long length)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(String parameterName, InputStream x)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBinaryStream(String parameterName, InputStream x)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setCharacterStream(String parameterName, Reader reader)");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNCharacterStream(String parameterName, Reader value)");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(String parameterName, Reader reader)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBlob(String parameterName, InputStream inputStream)");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(String parameterName, Reader reader)");
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(int parameterIndex, Class<T> type)");
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(String parameterName, Class<T> type)");
    }
}

