/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.Session;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.YasClobOutputStream;
import com.yashandb.jdbc.YasClobReader;
import com.yashandb.jdbc.YasClobWriter;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.YasLobInputStream;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class YasClob
implements Clob,
YasLargeObject {
    private YasLobProcessor lobProcessor = null;
    private YasConnection connection = null;
    private boolean isTempLob = false;
    private boolean isFree = false;
    private boolean inValid = false;

    public YasClob(boolean isTempLob) {
        this.isTempLob = isTempLob;
    }

    public void setLobProcessor(YasLobProcessor processor) throws SQLException {
        this.lobProcessor = processor;
        this.lobProcessor.setYasLob(this);
        if (this.lobProcessor.getLobLength() > 0L) {
            this.lobProcessor.getCharLength();
        }
    }

    @Override
    public int getStepSize() throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getStepSize();
    }

    @Override
    public synchronized int getBytes(long lobOffset, byte[] data) throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getBytes(lobOffset, data);
    }

    public void setSession(Session session) {
        this.lobProcessor.setSession(session);
    }

    public void setEndPos(long endPos) {
        this.lobProcessor.setEndPos(endPos);
    }

    public void setLobLocator(byte[] lobLocator) {
        this.lobProcessor.setLobLocator(lobLocator);
    }

    public byte[] getLobLocator() {
        return this.lobProcessor.getLobLocator();
    }

    public void setDataLen(long dataLen) {
        this.lobProcessor.setLobLength(dataLen);
    }

    public void setChunkSize(int chunkSize) {
        this.lobProcessor.setChunkSize(chunkSize);
    }

    @Override
    public void setConnection(YasConnection connection) {
        this.connection = connection;
    }

    private void checkClosed() throws SQLException {
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (this.isFree) {
            throw SQLError.createSQLException("the lob has been freed", YasState.DATA_ERROR);
        }
        if (this.inValid) {
            throw SQLError.createSQLException("the lob is inValid", YasState.DATA_ERROR);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getCharLength();
    }

    @Override
    public synchronized String getSubString(long pos, int length) throws SQLException {
        this.checkClosed();
        return this.lobProcessor.getSubString(pos, length);
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        return new YasClobReader(this);
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkClosed();
        return new YasLobInputStream(this);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(String searchstr, long start)");
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(Clob searchstr, long start)");
    }

    private void checkPos(long pos) throws SQLException {
        if (pos < 1L) {
            throw SQLError.createSQLException("invalid parameter, ''pos'' should not be < 1", YasState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            if (pos != this.length() + 1L) {
                throw SQLError.createSQLException("temp lob write only support append mode, ''pos'' should be lob length + 1", YasState.INVALID_PARAMETER_VALUE);
            }
        } else if (pos > this.length() + 1L) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be > lob length + 1", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public synchronized int setString(long pos, String str) throws SQLException {
        this.checkClosed();
        this.checkPos(pos);
        if (str == null) {
            return 0;
        }
        if (!this.supportUpdateKnlLob()) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setString(long pos, String str)");
        }
        this.preProcessTempInRowLob();
        if (pos == this.length() + 1L && this.isTempLob) {
            return this.lobProcessor.appendString(str);
        }
        return this.lobProcessor.setString(pos, str);
    }

    @Override
    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkClosed();
        this.checkPos(pos);
        if (str == null) {
            return 0;
        }
        if (offset < 0 || offset >= str.length() || len <= 0 || offset + len > str.length()) {
            throw SQLError.createSQLException("parameter ''offset'' or ''len'' is invalid", YasState.INVALID_PARAMETER_VALUE);
        }
        return this.setString(pos, str.substring(offset, offset + len));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkClosed();
        this.checkPos(pos);
        return new YasClobOutputStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkClosed();
        this.checkPos(pos);
        return new YasClobWriter(this, pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "truncate(long len)");
        }
        this.checkClosed();
        if (len < 0L) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be < 0", YasState.INVALID_PARAMETER_VALUE);
        }
        if (len > this.length()) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be > lob length", YasState.INVALID_PARAMETER_VALUE);
        }
        this.preProcessTempInRowLob();
        this.lobProcessor.truncate(len);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (!this.isFree) {
            if (this.isTempLob) {
                this.lobProcessor.free();
            } else {
                this.connection.getSession().removeUpdatedKnlLob(this);
            }
            this.isFree = true;
        }
    }

    private void checkStreamParameters(long pos, long length) throws SQLException {
        long lobLength = this.getLobLength();
        if (pos < 1L || pos > lobLength || length < 0L || pos + length - 1L > lobLength) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkClosed();
        this.checkStreamParameters(pos, length);
        return new YasClobReader(this, pos, length);
    }

    @Override
    public void freeTemp() throws SQLException {
        this.free();
    }

    @Override
    public long getLobLength() throws SQLException {
        return this.length();
    }

    @Override
    public String getString(long lobOffset, int length) throws SQLException {
        return this.getSubString(lobOffset, length);
    }

    @Override
    public int writeString(long pos, String str) throws SQLException {
        return this.setString(pos, str);
    }

    public YasLobProcessor getLobProcessor() {
        return this.lobProcessor;
    }

    private void preProcessTempInRowLob() throws SQLException {
        if (this.lobProcessor.getInnerLobType() != 4) {
            return;
        }
        YasClob clob = (YasClob)this.connection.createClob();
        clob.setString(1L, this.getSubString(1L, (int)this.length()));
        this.setLobProcessor(clob.getLobProcessor());
        this.isTempLob = true;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.inValid = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.lobProcessor.setUpdated(false);
        }
    }

    private boolean supportUpdateKnlLob() {
        return this.isTempLob || this.connection.getSession().getConnectVersion() != ConnectVersion.VER1;
    }
}

