/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.YasLargeObject;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class YasClobOutputStream
extends OutputStream {
    private YasLargeObject largeObject = null;
    private long lobPos = 0L;
    private StringBuilder stringBuilder = null;
    private boolean isClosed = false;
    private final Object lock = new Object();

    YasClobOutputStream(YasLargeObject largeObject, long lobPos) throws SQLException {
        this.largeObject = largeObject;
        this.lobPos = lobPos;
        int stepSize = largeObject.getStepSize();
        this.stringBuilder = stepSize > 0 ? new StringBuilder(stepSize) : new StringBuilder(32000);
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.stringBuilder.length() > 0) {
                try {
                    this.largeObject.writeString(this.largeObject.getLobLength() + 1L, this.stringBuilder.toString());
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
                this.stringBuilder.delete(0, this.stringBuilder.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.stringBuilder.length() >= this.stringBuilder.capacity()) {
                this.flush();
            }
            this.stringBuilder.append((char)b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.flush();
            super.close();
            this.isClosed = true;
        }
    }
}

