/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.exception.SQLError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class YasClobReader
extends Reader {
    private YasLargeObject largeObject;
    private int charPos = 0;
    private int cacheCharacterLen = 0;
    private long lobOffset = 1L;
    private long steamLobRemainSize = 0L;
    private StringBuilder stringBuilder;
    private boolean isClosed = false;

    public YasClobReader(YasLargeObject largeObject) throws SQLException {
        this.largeObject = largeObject;
        this.steamLobRemainSize = largeObject.getLobLength();
        int cacheSize = largeObject.getStepSize();
        if (cacheSize <= 0) {
            cacheSize = (int)largeObject.getLobLength();
        }
        this.stringBuilder = new StringBuilder(cacheSize);
        String clobStr = largeObject.getString(1L, cacheSize);
        this.stringBuilder.append(clobStr);
        this.cacheCharacterLen = clobStr.length();
    }

    public YasClobReader(YasLargeObject largeObject, long pos, long length) throws SQLException {
        if (pos < 1L || length < 0L) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
        long start = pos - 1L;
        long lobLength = largeObject.getLobLength();
        if (length == 0L || lobLength == 0L || start >= lobLength) {
            return;
        }
        this.largeObject = largeObject;
        long readLobLen = Math.min(length, lobLength);
        if (start + readLobLen > lobLength) {
            readLobLen = lobLength - start;
        }
        this.steamLobRemainSize = readLobLen;
        int cacheSize = largeObject.getStepSize();
        if (cacheSize <= 0) {
            cacheSize = (int)largeObject.getLobLength();
        }
        this.stringBuilder = new StringBuilder(cacheSize);
        this.lobOffset = pos;
        String clobStr = this.largeObject.getString(pos, this.stringBuilder.capacity());
        this.stringBuilder.append(clobStr);
        this.cacheCharacterLen = clobStr.length();
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("reader closed");
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.steamLobRemainSize <= 0L) {
            return -1;
        }
        int charLen = Math.min(len, cbuf.length - off);
        if (charLen <= 0) {
            throw new IOException("invalid parameter");
        }
        if ((long)(charLen = Math.min(charLen, this.cacheCharacterLen - this.charPos)) > this.steamLobRemainSize) {
            charLen = (int)this.steamLobRemainSize;
        }
        this.stringBuilder.getChars(this.charPos, this.charPos + charLen, cbuf, off);
        this.charPos += charLen;
        this.steamLobRemainSize -= (long)charLen;
        if (this.charPos >= this.cacheCharacterLen && this.steamLobRemainSize > 0L) {
            this.lobOffset += (long)this.cacheCharacterLen;
            try {
                this.stringBuilder.delete(0, this.stringBuilder.length());
                String clobStr = this.largeObject.getString(this.lobOffset, this.stringBuilder.capacity());
                this.stringBuilder.append(clobStr);
                this.charPos = 0;
                this.cacheCharacterLen = clobStr.length();
            }
            catch (SQLException sqlException) {
                throw new IOException(sqlException.getMessage());
            }
        }
        return charLen;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }
}

