/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.YasLargeObject;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class YasClobWriter
extends Writer {
    private YasLargeObject largeObject = null;
    private StringBuilder stringBuilder = null;
    private long lobPos = 0L;
    private boolean isClosed = false;

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("writer closed");
        }
    }

    YasClobWriter(YasLargeObject yasLargeObject, long lobPos) throws SQLException {
        this.largeObject = yasLargeObject;
        this.lobPos = lobPos;
        int stepSize = this.largeObject.getStepSize();
        this.stringBuilder = stepSize > 0 ? new StringBuilder(stepSize) : new StringBuilder(32000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.stringBuilder.length() >= this.stringBuilder.capacity()) {
                this.flush();
            }
            this.stringBuilder.append(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.stringBuilder.length() > 0) {
                try {
                    String strValue = this.stringBuilder.toString();
                    this.largeObject.writeString(this.largeObject.getLobLength() + 1L, strValue);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
                this.stringBuilder.delete(0, this.stringBuilder.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.flush();
            this.isClosed = true;
        }
    }
}

