/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasDriver;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.log.LoggerFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class YasDataSource
implements DataSource,
Referenceable,
Serializable {
    private static final com.yashandb.log.Logger LOGGER = LoggerFactory.getLogger(YasDataSource.class);
    private static final long serialVersionUID = 7624091928606233036L;
    YasDriver yasDriver = new YasDriver();
    protected PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    protected String databaseName = null;
    protected String serviceName = null;
    protected String dataSourceName = "YasDataSource";
    protected String description = "YashanDB Connector/J Data Source";
    protected String networkProtocol = "tcp";
    protected int portNumber = Integer.valueOf("1688");
    protected String user = null;
    protected String password = null;
    protected String serverName = null;
    protected String url = null;
    protected String sslRootCer = null;
    protected Properties connectionProperties = null;

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.yashandb.jdbc.YasDataSourceFactory", null);
        this.addRefProperties(ref);
        return ref;
    }

    protected void addRefProperties(Reference ref) {
        if (this.url != null) {
            ref.add(new StringRefAddr("url", this.url));
        }
        if (this.user != null) {
            ref.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr("password", this.password));
        }
        if (this.description != null) {
            ref.add(new StringRefAddr("description", this.description));
        }
        if (this.serverName != null) {
            ref.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.databaseName != null) {
            ref.add(new StringRefAddr("databasename", this.databaseName));
        }
        if (this.networkProtocol != null) {
            ref.add(new StringRefAddr("networkProtocol", this.networkProtocol));
        }
        if (this.portNumber != 0) {
            ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        if (this.sslRootCer != null) {
            ref.add(new StringRefAddr("sslRootCer", this.sslRootCer));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (this.connectionProperties != null && !this.connectionProperties.isEmpty()) {
            this.connectionProperties.stringPropertyNames().stream().forEach(k -> props.setProperty((String)k, this.connectionProperties.getProperty((String)k)));
        }
        if (username != null) {
            props.setProperty("user", username);
        } else if (this.user != null) {
            props.setProperty("user", this.user);
        }
        if (password != null) {
            props.setProperty("password", password);
        } else if (this.password != null) {
            props.setProperty("password", this.password);
        }
        if (this.loginTimeout != 0) {
            props.setProperty(YasProperty.LOGIN_TIMEOUT.getName(), "" + this.loginTimeout);
        }
        if (this.sslRootCer != null) {
            props.setProperty(YasProperty.SSL_ROOT_CER.getName(), this.sslRootCer);
        }
        return this.getConnection(props);
    }

    protected Connection getConnection(Properties props) throws SQLException {
        String url = this.url;
        if (url == null && this.serverName != null && this.portNumber != 0 && this.databaseName != null) {
            StringBuilder sbUrl = new StringBuilder("jdbc:yasdb:");
            sbUrl.append("//").append(this.serverName).append(":").append(this.portNumber);
            sbUrl.append("/").append(this.databaseName);
            url = sbUrl.toString();
        }
        if (url == null) {
            url = props.getProperty("url", "");
        }
        this.checkConnectionProp(url, props);
        return this.yasDriver.connect(url, props);
    }

    void checkConnectionProp(String url, Properties props) throws SQLException {
        String user = props.getProperty("user", "");
        String password = props.getProperty("password", "");
        if ("".equalsIgnoreCase(user)) {
            throw SQLError.createSQLException("No connection user!Please set user.", YasState.INVALID_PARAMETER_VALUE);
        }
        if ("".equalsIgnoreCase(password)) {
            throw SQLError.createSQLException("No connection password!Please set password.", YasState.INVALID_PARAMETER_VALUE);
        }
        if ("".equalsIgnoreCase(url)) {
            throw SQLError.createSQLException("No connection URL!Please set URL.", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public String getSslRootCer() {
        return this.sslRootCer;
    }

    public void setSslRootCer(String sslRootCer) {
        this.sslRootCer = sslRootCer;
    }

    @Override
    public synchronized void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public synchronized int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public synchronized void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public synchronized String getDatabaseName() {
        return this.databaseName != null ? this.databaseName : "";
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    public synchronized void setPortNumber(int port) {
        this.portNumber = port;
    }

    public synchronized int getPortNumber() {
        return this.portNumber;
    }

    public synchronized void setServerName(String sn) {
        this.serverName = sn;
    }

    public synchronized String getServerName() {
        return this.serverName;
    }

    public synchronized void setURL(String url) {
        this.url = url;
    }

    public synchronized String getURL() {
        return this.url;
    }

    public synchronized void setUser(String userID) {
        this.user = userID;
    }

    public synchronized String getUser() {
        return this.user;
    }

    public synchronized Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public synchronized void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }
}

