/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.YasDataSource;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class YasDataSourceFactory
implements ObjectFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(YasDataSourceFactory.class);
    public static final String DATA_SOURCE_CLASS_NAME = YasDataSource.class.getName();
    public static final String XA_DATA_SOURCE_CLASS_NAME = "";
    public static final String POOL_DATA_SOURCE_CLASS_NAME = "";

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)refObj;
        String className = ref.getClassName();
        Properties prop = new Properties();
        YasDataSource ads = null;
        LOGGER.debug("getObjectInstance {},name {}", ref, className);
        if (className == null || !className.equals(DATA_SOURCE_CLASS_NAME) && !className.equals("") && !className.equals("")) {
            className = DATA_SOURCE_CLASS_NAME;
        }
        try {
            ads = (YasDataSource)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("YasDataSourceFactory", className, e.toString()));
        }
        if (ads != null) {
            StringRefAddr st = null;
            st = (StringRefAddr)ref.get("url");
            if (st != null) {
                ads.setURL((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("user")) != null) {
                ads.setUser((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("password")) != null) {
                ads.setPassword((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("description")) != null) {
                ads.setDescription((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("serverName")) != null) {
                ads.setServerName((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("databasename")) != null) {
                ads.setDatabaseName((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("portNumber")) != null) {
                String pn = (String)st.getContent();
                ads.setPortNumber(Integer.parseInt(pn));
            }
            if ((st = (StringRefAddr)ref.get("sslRootCer")) != null) {
                String sslRootCer = (String)st.getContent();
                ads.setSslRootCer(sslRootCer);
            }
        }
        return ads;
    }
}

