/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasConstants;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.exception.SQLError;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YasDatabaseMetaData
implements DatabaseMetaData {
    private static final Set<Integer> numberTypeSet = new HashSet<Integer>(){
        {
            this.add(8);
            this.add(4);
            this.add(-6);
            this.add(5);
            this.add(7);
            this.add(6);
            this.add(2);
            this.add(3);
        }
    };
    private static final Set<Integer> canConvertToNumber = new HashSet<Integer>(){
        {
            this.addAll(numberTypeSet);
            this.add(12);
            this.add(16);
            this.add(2005);
            this.add(1);
        }
    };
    private static final Set<Integer> canConvertToBoolean = new HashSet<Integer>(){
        {
            this.addAll(numberTypeSet);
            this.add(12);
            this.add(16);
        }
    };
    private static final Set<Integer> canConvertToBit = new HashSet<Integer>(){
        {
            this.addAll(numberTypeSet);
            this.add(12);
            this.add(16);
            this.add(-7);
        }
    };
    private static final Set<Integer> canConvertToString = new HashSet<Integer>(){
        {
            this.addAll(numberTypeSet);
            this.add(12);
            this.add(2005);
            this.add(16);
            this.add(91);
            this.add(92);
            this.add(2013);
        }
    };
    private static final Set<Integer> canConvertToDate = new HashSet<Integer>(){
        {
            this.add(91);
            this.add(92);
            this.add(12);
            this.add(2013);
            this.add(93);
            this.add(2014);
        }
    };
    private static final Set<String> TABLE_TYPES = new HashSet<String>(){
        {
            this.add("TABLE");
            this.add("VIEW");
            this.add("SYNONYM");
        }
    };
    protected final ConnectionImpl connection;
    public static final Pattern VERSION_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    public static Pattern sqlEscapePattern = Pattern.compile("/");
    public static final Pattern sqlWildcardPattern = Pattern.compile("^%|[^/]%");

    public YasDatabaseMetaData(ConnectionImpl conn) {
        this.connection = conn;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "YashanDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        String sql = "select * from V$INSTANCE";
        Throwable throwable = null;
        try (Statement statement = this.connection.createStatement();){
            Throwable throwable2;
            ResultSet resultSet;
            block25: {
                String string;
                block26: {
                    block27: {
                        resultSet = statement.executeQuery(sql);
                        throwable2 = null;
                        if (!resultSet.next()) break block25;
                        string = resultSet.getString("VERSION");
                        if (resultSet == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    resultSet.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        throw SQLError.createSQLException("System view error:V$INSTANCE", YasState.SYSTEM_ERROR);
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (resultSet != null) {
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    @Override
    public String getDriverName() {
        return "YashanDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return "1.4.12";
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            return Integer.valueOf(this.getDriverVersion().split("\\.")[0]);
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            return Integer.valueOf(this.getDriverVersion().split("-")[0].split("\\.")[1]);
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        String numberFuncFilter = "AND name IN ('ABS', 'ACOS', 'ASIN', 'ATAN', 'ATAN2', 'BIN_TO_NUM', 'BITAND', 'BITOR', 'BITXOR', 'CEIL', 'COS', 'COT', 'COUNT', 'DIV', 'EXP', 'FLOOR', 'LN', 'LOG', 'MAX', 'MOD', 'MIN', 'PI', 'POW', 'POWER', 'RANDOM', 'ROUND', 'SIGN', 'SIN', 'SINH', 'SQRT', 'STDDEV', 'STDDEV_POP', 'STDDEV_SAMP', 'SUM', 'TAN', 'TANH', 'TRUNCATE', 'VARIANCE', 'VAR_POP', 'VAR_SAMP')";
        return this.getFilterFunctions(numberFuncFilter);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        String strFuncFilter = "AND name IN ('ASCII', 'BIT_LENGTH', 'CHAR_LENGTH', 'CHARACTER_LENGTH', 'CHR', 'CONCAT', 'CONCAT_WS', 'FIND_IN_SET', 'GROUP_CONCAT', 'INITCAP', 'INSTR', 'LISTAGG', 'LEFT', 'LENGTH', 'LENGTHB', 'LOWER', 'LPAD', 'LTRIM', 'NLSSORT', 'OCTET_LENGTH', 'POSITION', 'REGEXP_COUNT', 'REGEXP_INSTR', 'REGEXP_LIKE', 'REGEXP_REPLACE', 'REGEXP_SUBSTR', 'REPLACE', 'RIGHT', 'RPAD', 'RTRIM', 'SPLIT', 'STRING_AGG', 'STRPOS', 'SUBSTR', 'SUBSTRING', 'SUBSTRING_INDEX', 'TO_BASE64', 'TO_CHAR', 'TRANSLATE', 'TRIM', 'UPPER', 'WM_CONCAT')";
        return this.getFilterFunctions(strFuncFilter);
    }

    private String getFilterFunctions(String sqlFilter) throws SQLException {
        Statement statement = this.connection.createStatement();
        String sql = "select name from v$function where 1=1 ";
        sql = sql + sqlFilter;
        statement.closeOnCompletion();
        ResultSet resultSet = statement.executeQuery(sql);
        String strFunctions = "";
        while (resultSet.next()) {
            strFunctions = strFunctions + resultSet.getString(1) + ",";
        }
        resultSet.close();
        if (!strFunctions.isEmpty()) {
            return strFunctions.substring(0, strFunctions.length() - 1);
        }
        return strFunctions;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        String systemFuncFilter = "AND name IN ('USER', 'USERENV', 'SYS_CONNECT_BY_PATH', 'SYS_CONTEXT', 'SYS_GUID')";
        return this.getFilterFunctions(systemFuncFilter);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        String timeFunFilter = "AND name IN ('ADD_MONTHS', 'AGE', 'CURRENT_TIMESTAMP', 'DATE', 'DATE_ADD', 'DATE_FORMAT', 'DAYOFWEEK', 'EXTRACT', 'LAST_DAY', 'LOCALTIME', 'LOCALTIMESTAMP', 'MONTHS_BETWEEN', 'NEXT_DAY', 'NOW', 'NUMTODSINTERVAL', 'NUMTOYMINTERVAL', 'SCN_TO_TIMESTAMP', 'SYSDATE', 'SYSTIMESTAMP', 'TIME', 'TIMEDIFF', 'TIMESTAMPDIFF', 'TIMESTAMP_TO_SCN', 'TO_DATE', 'TO_DSINTERVAL', 'TO_TIMESTAMP', 'TO_YMINTERVAL', 'UTC_TIMESTAMP')";
        return this.getFilterFunctions(timeFunFilter);
    }

    @Override
    public String getSearchStringEscape() {
        return "/";
    }

    @Override
    public String getExtraNameCharacters() {
        return "$#";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        switch (toType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return canConvertToNumber.contains(fromType);
            }
            case 16: {
                return canConvertToBoolean.contains(fromType);
            }
            case -7: {
                return canConvertToBit.contains(fromType);
            }
            case -1: 
            case 1: 
            case 12: {
                return canConvertToString.contains(fromType);
            }
            case 91: 
            case 92: 
            case 93: {
                return canConvertToDate.contains(fromType);
            }
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case 3001: 
            case 3002: {
                return fromType == 12;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 4000;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 8000;
    }

    protected int getIdentifierLength() {
        return 64;
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 32;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 1024;
    }

    @Override
    public int getMaxConnections() {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxIndexLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxSchemaNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxProcedureNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 65536;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxTablesInSelect() {
        return 128;
    }

    @Override
    public int getMaxUserNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 2 || level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT DECODE(PROCEDURE_NAME,\n        NULL,\n        NULL,\n        object_name) AS procedure_cat,\n        owner AS procedure_schem,\n         DECODE(PROCEDURE_NAME,\n        null,\n        object_name,\n        PROCEDURE_NAME) AS procedure_name,\n        null,\n         null,\n        null,\n        '' AS remarks, 1 AS procedure_type, DECODE(PROCEDURE_NAME,null,OBJECT_NAME,OBJECT_NAME||'.'||PROCEDURE_NAME) AS specific_name FROM all_procedures proc\nWHERE 1=1\n        AND owner LIKE ? escape '/'\n        AND NOT EXISTS\n    (SELECT *\n    FROM all_arguments arg1\n    WHERE (arg1.ARGUMENT_NAME is null\n            OR length(arg1.ARGUMENT_NAME) = 0)\n            AND arg1.IN_OUT = 'OUT'\n            AND arg1.OBJECT_ID = proc.OBJECT_ID\n            AND (arg1.SUBPROGRAM_ID = proc.SUBPROGRAM_ID\n            OR (arg1.SUBPROGRAM_ID is null)))\n        AND ( ( ? =1\n        AND ((OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME is null)\n        OR PROCEDURE_NAME LIKE ? ESCAPE '/' ))\n        OR (? =2\n        AND OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME is NULL )\n        OR (? =3\n        AND OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME LIKE ? ESCAPE '/' ))order by procedure_cat, procedure_schem, procedure_name ";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        int catalogType = catalog == null ? 1 : (catalog.equals("") ? 2 : 3);
        stmt.setString(1, this.getSchemaParam(schemaPattern));
        stmt.setInt(2, catalogType);
        stmt.setString(3, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.setString(4, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.setInt(5, catalogType);
        stmt.setString(6, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.setInt(7, catalogType);
        stmt.setString(8, catalog);
        stmt.setString(9, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String decodeColumnType = " DECODE(arg.ARGUMENT_NAME, NULL, 5,\nDECODE(arg.in_out, 'IN', 1,\n'OUT', 4,\n'IN/OUT', 2,\n0)) ";
        String colType = YasDatabaseMetaData.getJDBCDataTypeClause("arg.data_type");
        String sql = "SELECT DECODE(arg.SUBPROGRAM_NAME,NULL,NULL,arg.object_name) AS procedure_cat,\n       arg.owner AS procedure_schem,\n       DECODE(arg.SUBPROGRAM_NAME,null,arg.object_name,arg.SUBPROGRAM_NAME) AS procedure_name,\n       arg.argument_name AS column_name,\n" + decodeColumnType + " AS column_type,\n" + colType + " AS data_type,\n       arg.data_type AS type_name,\n       DECODE (arg.data_precision, NULL, arg.data_length,\n                               arg.data_precision) AS precision,\n       arg.data_length AS length,\n       arg.data_scale AS scale,\n       10 AS radix,\n" + 1 + " AS nullable,\n       NULL AS remarks,\n       arg.default_value AS column_def,\n       NULL as sql_data_type,\n       NULL AS sql_datetime_sub,\n       DECODE(arg.data_type,\n                         'CHAR', 8000,\n                         'VARCHAR', 8000,\n                         'RAW', 8000,\n                         NULL) AS char_octet_length,\n       arg.sequence AS ordinal_position,\n       'YES' AS is_nullable,\n DECODE(arg.SUBPROGRAM_NAME,null,arg.OBJECT_NAME,arg.OBJECT_NAME||'.'||arg.SUBPROGRAM_NAME)  AS specific_name FROM all_arguments arg, all_procedures proc\n WHERE arg.owner LIKE ? ESCAPE '/'\n AND (( ? =1 and ((proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null) or proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))  OR (? =2 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null ) or (? =3 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))\n AND arg.owner = proc.owner\n AND (arg.SUBPROGRAM_ID = proc.SUBPROGRAM_ID OR arg.SUBPROGRAM_ID is null)\n AND arg.object_id = proc.object_id\n AND not EXISTS(select * from all_arguments arg1       where (arg1.ARGUMENT_NAME  is null or length(arg1.ARGUMENT_NAME) = 0)     and arg1.IN_OUT = 'OUT'      and arg1.OBJECT_ID = arg.OBJECT_ID        and (arg1.SUBPROGRAM_ID = arg.SUBPROGRAM_ID or (arg1.SUBPROGRAM_ID is null))) \nAND arg.argument_name LIKE ? ESCAPE '/' \nORDER BY PROCEDURE_CAT,procedure_schem, procedure_name, SPECIFIC_NAME";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        int catalogType = catalog == null ? 1 : (catalog.equals("") ? 2 : 3);
        stmt.setString(1, this.getSchemaParam(schemaPattern));
        stmt.setInt(2, catalogType);
        stmt.setString(3, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.setString(4, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.setInt(5, catalogType);
        stmt.setString(6, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.setInt(7, catalogType);
        stmt.setString(8, catalog);
        stmt.setString(9, this.getLikeParam(procedureNamePattern, "procedureNamePattern"));
        stmt.setString(10, this.getLikeParam(columnNamePattern, "columnNamePattern"));
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    private String getLikeParam(String pattern, String name) throws SQLException {
        if (pattern == null) {
            return "%";
        }
        if (pattern.equals("")) {
            throw SQLError.createSQLException("invalid parameter \"" + name + "\"", YasState.INVALID_PARAMETER_VALUE);
        }
        return pattern;
    }

    private String getSchemaParam(String schemaPattern) throws SQLException {
        if (schemaPattern == null) {
            return "%";
        }
        if (!schemaPattern.equals("")) {
            return schemaPattern;
        }
        if (this.connection.getSession().isUserCaseSensitive()) {
            return "\"" + this.connection.getUserName() + "\"";
        }
        return this.connection.getUserName().toUpperCase();
    }

    private Set<String> filterTableTypes(String[] tableTypes) {
        if (tableTypes != null && tableTypes.length > 0) {
            HashSet<String> types = new HashSet<String>();
            for (String type : tableTypes) {
                if (!TABLE_TYPES.contains(type)) continue;
                types.add(type);
            }
            return types;
        }
        return Collections.emptySet();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String leftJoinCluse = "left join all_tab_comments";
        if (tableNamePattern != null) {
            if (this.hasSqlWildcard(tableNamePattern)) {
                leftJoinCluse = "inner join (select * from all_tab_comments c1 where c1.table_name  like ? escape '/' selectivity 0.00001 )";
            } else {
                tableNamePattern = this.stripSqlEscapes(tableNamePattern);
                leftJoinCluse = "inner join (select * from all_tab_comments c1 where c1.table_name = ?)";
            }
        }
        StringBuilder str = new StringBuilder("select null as table_cat,\no.owner as table_schem,\no.object_name as table_name,\no.object_type as table_type,\nc.comments as remarks,\nnull as type_cat,\nnull as type_schem,\nnull as type_name,\nnull as self_referencing_col_name,\nnull as ref_generation\nfrom all_objects o " + leftJoinCluse + " c on o.owner = c.owner  and o.object_name = c.table_name  where 1=1 ");
        if (schemaPattern != null) {
            if (this.hasSqlWildcard(schemaPattern)) {
                str.append(" AND o.owner like ?  escape '/' selectivity 0.00001 ");
            } else {
                schemaPattern = this.stripSqlEscapes(schemaPattern);
                str.append(" AND o.owner = ? ");
            }
        }
        Set<String> tableTypeSet = this.filterTableTypes(types);
        if (types != null) {
            if (!tableTypeSet.isEmpty()) {
                str.append(" and o.object_type in (?");
                for (int i = 1; i < tableTypeSet.size(); ++i) {
                    str.append(",?");
                }
                str.append(")");
            } else {
                str.append(" and 1 = 2 ");
            }
        } else {
            str.append(" and o.object_type in ('TABLE', 'VIEW', 'SYNONYM')");
        }
        str.append(" ORDER BY table_type, table_schem, table_name\n");
        PreparedStatement stmt = this.connection.prepareStatement(str.toString());
        int index = 1;
        if (tableNamePattern != null) {
            stmt.setString(index++, tableNamePattern);
        }
        if (schemaPattern != null) {
            stmt.setString(index++, schemaPattern);
        }
        for (String type : tableTypeSet) {
            stmt.setString(index++, type);
        }
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        Statement statement = this.connection.createStatement();
        String str = "select 'nothing' as table_cat from dual where 1 = 2";
        statement.closeOnCompletion();
        return statement.executeQuery(str);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Statement statement = this.connection.createStatement();
        String str = "select 'TABLE' as table_type from dual union select 'VIEW' as table_type from dual union select 'SYNONYM' as table_type from dual order by table_type";
        statement.closeOnCompletion();
        return statement.executeQuery(str);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String colType = YasDatabaseMetaData.getJDBCDataTypeClause("c.data_type");
        String leftJoinTableClause = "";
        String tableNamePatternParam = tableNamePattern;
        if (tableNamePattern != null) {
            if (this.hasSqlWildcard(tableNamePattern)) {
                leftJoinTableClause = " where r1.table_name like ?  escape '/' selectivity 0.00001 ";
            } else {
                tableNamePatternParam = this.stripSqlEscapes(tableNamePattern);
                leftJoinTableClause = " where r1.table_name = ? ";
            }
        }
        String colNullable = "decode(c.nullable, 'Y', 1, 'N', 0)";
        String colSize = "decode(c.data_precision, null, c.data_length, decode(c.data_type,'NUMBER', decode(c.data_scale,null, 0 , c.data_precision),c.data_precision))";
        String decimalDigits = "decode(c.data_type,'NUMBER',  decode(c.data_scale,null, -127, c.data_scale), c.data_scale)";
        String str = "select null as table_cat,c.owner as table_schem,c.table_name as table_name,c.column_name as column_name," + colType + " as data_type,c.data_type as type_name," + colSize + " as column_size,0 as buffer_length," + decimalDigits + " as decimal_digits,10 as num_prec_radix," + colNullable + " as nullable,r.comments as remarks,data_default as column_def,0 as sql_data_type,null as sql_datetime_sub,null as char_octet_length,c.column_id + 1 as ordinal_position,nullable as is_nullable,null as scope_catalog,null as scope_schema,null as scope_table,0 as source_data_type, '' as is_autoincrement, '' as is_generatedcolumn from all_tab_cols c left join  (select * from all_col_comments r1  " + leftJoinTableClause + ") r on  c.owner = r.owner and c.table_name = r.table_name  and c.column_name = r.column_name  where c.USER_GENERATED = 'Y' ";
        String schemaPatternParam = schemaPattern;
        String columnNamePatternParam = columnNamePattern;
        if (schemaPattern != null) {
            if (this.hasSqlWildcard(schemaPattern)) {
                str = str + "AND c.owner like ?  escape '/' selectivity 0.00001 ";
            } else {
                schemaPatternParam = this.stripSqlEscapes(schemaPattern);
                str = str + "AND c.owner = ? ";
            }
        }
        if (tableNamePattern != null) {
            if (this.hasSqlWildcard(tableNamePattern)) {
                str = str + " AND c.table_name like ?  escape '/' selectivity 0.00001 ";
            } else {
                tableNamePatternParam = this.stripSqlEscapes(tableNamePattern);
                str = str + " AND c.table_name = ? ";
            }
        }
        if (columnNamePattern != null) {
            if (this.hasSqlWildcard(columnNamePattern)) {
                str = str + " AND c.column_name like ?  escape '/' selectivity 0.00001 ";
            } else {
                columnNamePatternParam = this.stripSqlEscapes(columnNamePattern);
                str = str + " AND c.column_name = ? ";
            }
        }
        str = str + " order by TABLE_CAT,TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION";
        PreparedStatement preparedStatement = this.connection.prepareStatement(str);
        int parameterIndex = 1;
        if (tableNamePattern != null) {
            preparedStatement.setString(parameterIndex, tableNamePatternParam);
            ++parameterIndex;
        }
        if (schemaPattern != null) {
            preparedStatement.setString(parameterIndex, schemaPatternParam);
            ++parameterIndex;
        }
        if (tableNamePattern != null) {
            preparedStatement.setString(parameterIndex, tableNamePatternParam);
            ++parameterIndex;
        }
        if (columnNamePattern != null) {
            preparedStatement.setString(parameterIndex, columnNamePatternParam);
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.emptyResult();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       OWNER AS table_schem,\n       table_name,\ngrantor,\n       grantee,\n       privilege,\n       decode(grantable,'N','NO','Y','YES',NULL) AS is_grantable\nFROM ALL_TAB_PRIVS\nWHERE OWNER LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\nORDER BY OWNER,table_name, privilege");
        preparedStatement.setString(1, schemaPattern == null ? "%" : schemaPattern);
        preparedStatement.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String sql1 = "SELECT 1 AS scope, 'ROWID' AS column_name, -8 AS data_type,\n 'ROWID' AS type_name, 0 AS column_size, 0 AS buffer_length,\n       0 AS decimal_digits, 2 AS pseudo_column\nFROM DUAL\nWHERE :1 = 1\nUNION\nSELECT 2 AS scope,\n t.column_name,\n" + YasDatabaseMetaData.getJDBCDataTypeClause("t.data_type") + " AS data_type,\n t.data_type AS type_name,\n t.DATA_LENGTH AS column_size,\n  0 AS buffer_length,\n  t.data_scale AS decimal_digits,\n       1 AS pseudo_column\nFROM all_tab_columns t, all_ind_columns i\nWHERE :2 = 1\n  AND t.table_name = :3\n  AND t.owner like :4 escape '/'\n  AND t.nullable = :5\n  AND t.owner = i.table_owner\n  AND t.table_name = i.table_name\n  AND t.column_name = i.column_name\n";
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql1);
        switch (scope) {
            case 0: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 0);
                break;
            }
            case 1: {
                preparedStatement.setInt(1, 1);
                preparedStatement.setInt(2, 1);
                break;
            }
            case 2: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 1);
            }
        }
        preparedStatement.setString(3, table);
        preparedStatement.setString(4, schema == null ? "%" : schema);
        preparedStatement.setString(5, nullable ? "Y" : "N");
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String sql = "  SELECT 0 AS scope,\n t.column_name,\n" + YasDatabaseMetaData.getJDBCDataTypeClause("c.data_type") + " AS data_type,\n c.data_type AS type_name,\n c.DATA_LENGTH AS column_size,\n       0 as buffer_length,\n   c.data_scale as decimal_digits,\n   0 as pseudo_column\nFROM all_trigger_cols t, all_tab_columns c\nWHERE t.table_name = :1\n  AND c.owner like :2 escape '/'\n AND t.table_owner = c.owner\n  AND t.table_name = c.table_name\n AND t.column_name = c.column_name";
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        preparedStatement.setString(1, table);
        preparedStatement.setString(2, schema == null ? "%" : schema);
        ResultSet resultSet = preparedStatement.executeQuery();
        preparedStatement.closeOnCompletion();
        return resultSet;
    }

    private static String getJDBCDataTypeClause(String colName) {
        return "decode(" + colName + ",\n\t'BOOLEAN', " + 16 + ",\n\t'TINYINT', " + -6 + ",\n\t'SMALLINT', " + 5 + ",\n\t'INTEGER', " + 4 + ",\n\t'BIGINT', " + -5 + ",\n\t'FLOAT', " + 7 + ",\n\t'DOUBLE', " + 8 + ",\n\t'NUMBER', " + 2 + ",\n\t'DATE', " + 91 + ",\n\t'TIME', " + 92 + ",\n\t'TIMESTAMP', " + 93 + ",\n\t'TIMESTAMP_TZ', " + 2014 + ",\n\t'TIMESTAMP_LTZ', " + 2014 + ",\n\t'INTERVAL YEAR TO MONTH', " + 3001 + ",\n\t'INTERVAL DAY TO SECOND', " + 3002 + ",\n\t'CHAR', " + 1 + ",\n\t'NCHAR', " + -15 + ",\n\t'VARCHAR', " + 12 + ",\n\t'NVARCHAR', " + -9 + ",\n\t'RAW', " + -2 + ",\n\t'CLOB', " + 2005 + ",\n\t'BLOB', " + 2004 + ",\n\t'BIT', " + -7 + ",\n\t'CURSOR', " + 2012 + ",\n\t'NCLOB', " + 2011 + ",\n\t'JSON', " + 3009 + ",\n\t'ROWID', " + -8 + ",\n\t1111)";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position + 1 AS key_seq,\nc.constraint_name AS pk_name\nFROM all_cons_columns c  join\nall_constraints k on k.constraint_name = c.constraint_name AND k.owner = c.owner WHERE k.constraint_type in ('PRIMARY KEY','P')\nAND k.table_name = ? \nAND c.table_name = ?\n";
        if (schema != null) {
            if (this.hasSqlWildcard(schema)) {
                sql = sql + " AND k.owner like ? escape '/' selectivity 0.00001 \n";
            } else {
                sql = sql + "AND k.owner = ? \n";
                schema = this.stripSqlEscapes(schema);
            }
        }
        sql = sql + " ORDER BY column_name";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        stmt.setString(1, table);
        stmt.setString(2, table);
        if (schema != null) {
            stmt.setString(3, schema);
        }
        ResultSet rs = stmt.executeQuery();
        stmt.closeOnCompletion();
        return rs;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.queryKeys(null, null, schema, table, "ORDER BY pktable_schem, pktable_name, key_seq");
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.queryKeys(schema, table, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    ResultSet queryKeys(String pSchema, String pTable, String fSchema, String fTable, String orderByClause) throws SQLException {
        String pTableClause = pTable != null ? " AND p.table_name = ? " : "";
        String fTableClause = fTable != null ? " AND f.table_name = ? " : "";
        String pSchemaClause = pSchema != null ? " AND p.owner =  ? " : "";
        String fSchemaClause = fSchema != null ? " AND f.owner = ? " : "";
        String sql = "SELECT NULL AS pktable_cat,\n       p.owner as pktable_schem,\n       p.table_name as pktable_name,\n       pc.column_name as pkcolumn_name,\n       NULL as fktable_cat,\n       f.owner as fktable_schem,\n       f.table_name as fktable_name,\n       fc.column_name as fkcolumn_name,\n       fc.position as key_seq,\n       decode (f.update_rule, 'CASCADE', 0, 'SET NULL', 2, 3) as update_rule,\n       decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 3) as delete_rule,\n       f.constraint_name as fk_name,\n       p.constraint_name as pk_name,\n       7 as deferrability \n      FROM all_cons_columns pc, all_constraints p,\n      all_cons_columns fc, all_constraints f\nWHERE 1 = 1" + pTableClause + fTableClause + pSchemaClause + fSchemaClause + " AND f.constraint_type in ('FOREIGN KEY','R')\n  AND p.owner = f.r_owner\n  AND p.constraint_name = f.r_constraint_name\n  AND p.constraint_type in ('PRIMARY KEY','P')\n  AND pc.owner = p.owner\n  AND pc.constraint_name = p.constraint_name\n  AND pc.table_name = p.table_name\n  AND fc.owner = f.owner\n  AND fc.constraint_name = f.constraint_name\n  AND fc.table_name = f.table_name\n  AND fc.position = pc.position\n" + orderByClause;
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        int index = 1;
        if (pTable != null) {
            stmt.setString(index++, pTable);
        }
        if (fTable != null) {
            stmt.setString(index++, fTable);
        }
        if (pSchema != null) {
            stmt.setString(index++, pSchema);
        }
        if (fSchema != null) {
            stmt.setString(index, fSchema);
        }
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.queryKeys(primarySchema, primaryTable, foreignSchema, foreignTable, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Statement statement = this.connection.createStatement();
        String tintIntStr = "select\n'TINYINT' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'TINYINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String smallIntStr = "union select \n'SMALLINT' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'SMALLINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String intStr = "union select \n'INTEGER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'INTEGER' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String bigIntStr = "union select \n'BIGINT' as type_name, -5 as data_type, 19 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'BIGINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String charStr = "union select\n'CHAR' as type_name, 1 as data_type, 8000 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 1 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'CHAR' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String varcharStr = "union select\n'VARCHAR' as type_name, 12 as data_type, 32000 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 1 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'VARCHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String intervalYmStr = "union select\n'INTERVAL YEAR TO MONTH' as type_name, 3001 as data_type, 9 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'INTERVAL YEAR TO MONTH' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String intervalDsStr = "union select\n'INTERVAL DAY TO SECOND' as type_name, 3002 as data_type, 9 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'INTERVAL DAY TO SECOND' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String unionStr = tintIntStr + smallIntStr + intStr + bigIntStr + "union select \n'FLOAT' as type_name, " + 7 + " as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select \n'DOUBLE' as type_name, " + 8 + " as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'DOUBLE' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select \n'NUMBER' as type_name, " + 2 + " as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select \n'DATE' as type_name, " + 91 + " as data_type, 35 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'DATE' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select \n'TIME' as type_name, " + 92 + " as data_type, 35 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'TIME' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select \n'TIMESTAMP' as type_name, " + 93 + " as data_type, 35 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'TIMESTAMP' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select \n'TIMESTAMP WITH TIME ZONE' as type_name, " + 2014 + " as data_type, 35 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'TIMESTAMP WITH TIME ZONE' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select \n'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, " + 2014 + " as data_type, 35 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + intervalYmStr + intervalDsStr + charStr + "union select 'NCHAR' as type_name, " + -15 + " as data_type, 4000 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 1 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'NCHAR' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + varcharStr + "union select \n'NVARCHAR' as type_name, " + -9 + " as data_type, 16000 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 1 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'NVARCHAR' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'RAW' as type_name, " + -2 + " as data_type, 8000 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 1 as case_sensitive, 0 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'RAW' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'CLOB' as type_name, " + 2005 + " as data_type, -1 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 1 as case_sensitive, 0 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'CLOB' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'NCLOB' as type_name, " + 2011 + " as data_type, -1 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 1 as case_sensitive, 0 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'NCLOB' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'BLOB' as type_name, " + 2004 + " as data_type, -1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 0 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'BLOB' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n'BIT' as type_name, " + -7 + " as data_type, 64 as precision,\n'b''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'BIT' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'BOOLEAN' as type_name, " + 16 + " as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'BOOLEAN' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n'ROWID' as type_name, " + -8 + " as data_type, 42 as precision,\n'''' as literal_prefix, '''' as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'ROWID' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
        String sql = "select * from (" + unionStr + ") order by data_type";
        statement.closeOnCompletion();
        return statement.executeQuery(sql);
    }

    private static String quoteDatabaseObjectName(String paramString) {
        if (paramString == null || paramString.length() == 0) {
            return "''";
        }
        return (paramString.charAt(0) == '\"' ? "Q'" : "'") + paramString + "'";
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String sql = "select null as table_cat, owner as table_schem, table_name, 0 as NON_UNIQUE, null as index_qualifier, null as index_name, 0 as type, 0 as ordinal_position, null as column_name, null as asc_or_desc, num_rows as cardinality, blocks as pages, null as filter_condition from all_tables where table_name = ? ";
        if (schema != null && schema.length() > 0) {
            sql = sql + "  and owner = ? ";
        }
        sql = sql + " union\n";
        sql = sql + "select null as table_cat, i.owner as table_schem, i.table_name, decode (i.uniqueness, 'Y', 0, 1), null as index_qualifier, i.index_name, 1 as type, c.column_position + 1 as ordinal_position, c.column_name, decode (c.descend, 'N', 'A', 'D') as asc_or_desc, i.distinct_keys as cardinality, i.leaf_blocks as pages, null as filter_condition from all_indexes i, all_ind_columns c where i.table_name = ?";
        if (unique) {
            sql = sql + "  and i.uniqueness = 'Y' ";
        }
        if (schema != null && schema.length() > 0) {
            sql = sql + " and i.owner = ? ";
        }
        sql = sql + " and i.index_name = c.index_name and i.table_owner = c.table_owner and i.table_name = c.table_name and i.owner = c.index_owner ";
        sql = sql + " order by non_unique, type, index_name, ordinal_position";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        int index = 1;
        stmt.setString(index++, tableName);
        if (schema != null && schema.length() > 0) {
            stmt.setString(index++, schema);
        }
        stmt.setString(index++, tableName);
        if (schema != null && schema.length() > 0) {
            stmt.setString(index++, schema);
        }
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return !(type != 1003 && type != 1004 && type != 1005 || concurrency != 1007 && concurrency != 1008);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return type != 1003;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return type != 1003;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return type == 1005;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "SELECT NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS CLASS_NAME, 'STRUCT' AS DATA_TYPE, NULL AS REMARKS FROM DUAL WHERE 1=2 ";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        ResultSet rs = stmt.executeQuery();
        stmt.closeOnCompletion();
        return rs;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.emptyResult();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.emptyResult();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.emptyResult();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    private String checkVersion(String versionStr) throws SQLException {
        Matcher matcher = VERSION_PATTERN.matcher(versionStr);
        if (!matcher.find()) {
            throw SQLError.createSQLException("Incorrect version format: " + versionStr, YasState.UNKNOWN_STATE);
        }
        return matcher.group();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.valueOf(this.checkVersion(this.getDatabaseProductVersion()).split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.valueOf(this.checkVersion(this.getDatabaseProductVersion()).split("\\.")[1]);
    }

    @Override
    public int getJDBCMajorVersion() {
        return YasConstants.JDBC_MAJOR_VERSION;
    }

    @Override
    public int getJDBCMinorVersion() {
        return YasConstants.JDBC_MINOR_VERSION;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String str = "select username as table_schem, null as table_catalog from all_users where  username like ?  order by table_schem";
        PreparedStatement stmt = this.connection.prepareStatement(str);
        if (schemaPattern != null) {
            stmt.setString(1, schemaPattern);
        } else {
            stmt.setString(1, "%");
        }
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.emptyResult();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String sql = "SELECT DECODE(PROCEDURE_NAME,\n        NULL,\n        NULL,\n        object_name) AS FUNCTION_CAT,\n        owner AS FUNCTION_SCHEM,\n         DECODE(PROCEDURE_NAME,\n        null,\n        object_name,\n        PROCEDURE_NAME) AS FUNCTION_NAME,\n        DECODE(PROCEDURE_NAME,null,'Standalone function','Packaged function') AS remarks, 0 AS FUNCTION_TYPE,   DECODE(PROCEDURE_NAME,null,OBJECT_NAME,OBJECT_NAME||'.'||PROCEDURE_NAME) AS specific_name FROM all_procedures proc\nWHERE owner LIKE ? escape '/'\n        AND EXISTS\n    (SELECT *\n    FROM all_arguments arg1\n    WHERE (arg1.ARGUMENT_NAME is null\n            OR length(arg1.ARGUMENT_NAME) = 0)\n            AND arg1.IN_OUT = 'OUT'\n            AND arg1.OBJECT_ID = proc.OBJECT_ID\n            AND (arg1.SUBPROGRAM_ID = proc.SUBPROGRAM_ID\n            OR (arg1.SUBPROGRAM_ID is null)))\n        AND ( ( ? =1\n        AND ((OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME is null)\n        OR PROCEDURE_NAME LIKE ? ESCAPE '/' ))\n        OR (? =2\n        AND OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME is NULL )\n        OR (? =3\n        AND OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME LIKE ? ESCAPE '/' ))order by FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME ";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        int catalogType = catalog == null ? 1 : (catalog.equals("") ? 2 : 3);
        stmt.setString(1, this.getSchemaParam(schemaPattern));
        stmt.setInt(2, catalogType);
        stmt.setString(3, this.getLikeParam(functionNamePattern, "functionNamePattern"));
        stmt.setString(4, this.getLikeParam(functionNamePattern, "functionNamePattern"));
        stmt.setInt(5, catalogType);
        stmt.setString(6, this.getLikeParam(functionNamePattern, "functionNamePattern"));
        stmt.setInt(7, catalogType);
        stmt.setString(8, catalog);
        stmt.setString(9, this.getLikeParam(functionNamePattern, "functionNamePattern"));
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String decodeColumnType = " DECODE(arg.ARGUMENT_NAME, NULL, 5,\nDECODE(arg.in_out, 'IN', 1,\n'OUT', 4,\n'IN/OUT', 2,\n0)) ";
        String colType = YasDatabaseMetaData.getJDBCDataTypeClause("arg.data_type");
        String sql = "SELECT DECODE(arg.SUBPROGRAM_NAME,NULL,NULL,arg.object_name) AS FUNCTION_CAT,\n       arg.owner AS FUNCTION_SCHEM,\n       DECODE(arg.SUBPROGRAM_NAME,null,arg.object_name,arg.SUBPROGRAM_NAME) AS FUNCTION_NAME,\n       arg.argument_name AS column_name,\n" + decodeColumnType + " AS column_type,\n" + colType + " AS data_type,\n       arg.data_type AS type_name,\n       DECODE (arg.data_precision, NULL, arg.data_length,\n                               arg.data_precision) AS precision,\n       arg.data_length AS length,\n       arg.data_scale AS scale,\n       10 AS radix,\n" + 1 + " AS nullable,\n       NULL AS remarks,\n       arg.default_value AS column_def,\n       NULL as sql_data_type,\n       NULL AS sql_datetime_sub,\n       DECODE(arg.data_type,\n                         'CHAR', 8000,\n                         'VARCHAR', 8000,\n                         'RAW', 8000,\n                         NULL) AS char_octet_length,\n       arg.sequence - 1 AS ordinal_position,\n       'YES' AS is_nullable,\n DECODE(arg.SUBPROGRAM_NAME,null,arg.OBJECT_NAME,arg.OBJECT_NAME||'.'||arg.SUBPROGRAM_NAME)  AS specific_name FROM all_arguments arg, all_procedures proc\n WHERE arg.owner LIKE ? ESCAPE '/'\n AND (( ? =1 and ((proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null) or proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))  OR (? =2 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null ) or (? =3 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))\n AND arg.owner = proc.owner\n AND (arg.SUBPROGRAM_ID = proc.SUBPROGRAM_ID OR arg.SUBPROGRAM_ID is null)\n AND arg.object_id = proc.object_id\n AND EXISTS(select * from all_arguments arg1       where (arg1.ARGUMENT_NAME  is null or length(arg1.ARGUMENT_NAME) = 0)     and arg1.IN_OUT = 'OUT'      and arg1.OBJECT_ID = arg.OBJECT_ID        and (arg1.SUBPROGRAM_ID = arg.SUBPROGRAM_ID or (arg1.SUBPROGRAM_ID is null))) \n  AND (arg.argument_name LIKE ? ESCAPE '/'\n       OR ((arg.ARGUMENT_NAME is null or length(arg.ARGUMENT_NAME) = 0)\n           AND arg.IN_OUT = 'OUT'))\nORDER BY FUNCTION_CAT,FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        int catalogType = catalog == null ? 1 : (catalog.equals("") ? 2 : 3);
        stmt.setString(1, this.getSchemaParam(schemaPattern));
        stmt.setInt(2, catalogType);
        stmt.setString(3, this.getLikeParam(functionNamePattern, "procedureNamePattern"));
        stmt.setString(4, this.getLikeParam(functionNamePattern, "procedureNamePattern"));
        stmt.setInt(5, catalogType);
        stmt.setString(6, this.getLikeParam(functionNamePattern, "procedureNamePattern"));
        stmt.setInt(7, catalogType);
        stmt.setString(8, catalog);
        stmt.setString(9, this.getLikeParam(functionNamePattern, "procedureNamePattern"));
        stmt.setString(10, this.getLikeParam(columnNamePattern, "columnNamePattern"));
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String sql = " select * from(  select null as TABLE_CAT,\n  owner as TABLE_SCHEM,\n  table_name as TABLE_NAME,\n  'ROWID' as COLUMN_NAME,\n  -8 as DATA_TYPE,\n  18 as COLUMN_SIZE,\n  null as DECIMAL_DIGITS,\n  10 as NUM_PREC_RADIX,\n  'NO_USAGE_RESTRICTONS' as COLUMN_USAGE,\n  null as REMARKS,\n  null as CHAR_OCTET_LENGTH,\n  'NO' as IS_NULLABLE\nfrom all_tables\nwhere\n  owner like ? and\n  table_name like ? ESCAPE '/'\n  and 'ROWID' like ? ESCAPE '/'\nunion\n  select null as TABLE_CAT,\n  owner as TABLE_SCHEM,\n  table_name as TABLE_NAME,\n  'ROWNUM' as COLUMN_NAME,\n  2 as DATA_TYPE,\n  10 as COLUMN_SIZE,\n  38 as DECIMAL_DIGITS,\n  10 as NUM_PREC_RADIX,\n  'NO_USAGE_RESTRICTONS' as COLUMN_USAGE,\n  null as REMARKS,\n  null as CHAR_OCTET_LENGTH,\n  'NO' as IS_NULLABLE\nfrom all_tables\nwhere\n  owner like ? and\n  table_name like ? ESCAPE '/'and 'ROWNUM' like ? ESCAPE '/'union\n  select null as TABLE_CAT,\n  owner as TABLE_SCHEM,\n  table_name as TABLE_NAME,\n  'ROWSCN' as COLUMN_NAME,\n  2 as DATA_TYPE,\n  10 as COLUMN_SIZE,\n  38 as DECIMAL_DIGITS,\n  10 as NUM_PREC_RADIX,\n  'NO_USAGE_RESTRICTONS' as COLUMN_USAGE,\n  null as REMARKS,\n  null as CHAR_OCTET_LENGTH,\n  'NO' as IS_NULLABLE\nfrom all_tables\nwhere\n  owner like ? and\n  table_name like ? ESCAPE '/'\n  and 'ROWSCN' like ? ESCAPE '/') order by TABLE_CAT,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME \n";
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        stmt.setString(1, this.getSchemaParam(schemaPattern));
        stmt.setString(2, this.getLikeParam(tableNamePattern, "tableNamePattern"));
        stmt.setString(3, this.getLikeParam(columnNamePattern, "columnNamePattern"));
        stmt.setString(4, this.getSchemaParam(schemaPattern));
        stmt.setString(5, this.getLikeParam(tableNamePattern, "tableNamePattern"));
        stmt.setString(6, this.getLikeParam(columnNamePattern, "columnNamePattern"));
        stmt.setString(7, this.getSchemaParam(schemaPattern));
        stmt.setString(8, this.getLikeParam(tableNamePattern, "tableNamePattern"));
        stmt.setString(9, this.getLikeParam(columnNamePattern, "columnNamePattern"));
        return stmt.executeQuery();
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() {
        return true;
    }

    ResultSet emptyResult() throws SQLException {
        String sql = "SELECT NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS CLASS_NAME, 'STRUCT' AS DATA_TYPE, NULL AS REMARKS FROM DUAL WHERE 1=2 ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        stmt.closeOnCompletion();
        return rs;
    }

    protected boolean hasSqlWildcard(String sql) {
        Matcher matcher = sqlWildcardPattern.matcher(sql);
        return matcher.find();
    }

    protected String stripSqlEscapes(String sql) {
        Matcher matcher = sqlEscapePattern.matcher(sql);
        StringBuffer strBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(strBuffer, "");
        }
        matcher.appendTail(strBuffer);
        return strBuffer.toString();
    }
}

