/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.ParameterList;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.DebugBreakpoint;
import com.yashandb.jdbc.DebugBreakpointImpl;
import com.yashandb.jdbc.DebugFrame;
import com.yashandb.jdbc.DebugVar;
import com.yashandb.jdbc.Debugger;
import com.yashandb.jdbc.YasCallableStatement;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.protocol.DebugOperation;
import com.yashandb.util.Messages;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class YasDebugCallableStatement
extends YasCallableStatement
implements Debugger {
    private boolean debugOn = false;
    private long runObjectId = -1L;
    private int runSubprogramId = -1;
    private int runLineNum = -1;
    private long debugObjectId;
    private int debugSubprogramId;
    private int debugVersion;
    private List<DebugBreakpoint> breakpointList = new ArrayList<DebugBreakpoint>();

    YasDebugCallableStatement(ConnectionImpl connection, String sql, int rsType, int rsConcurrency, int rsHoldability, long objectId, int subprogramId, int version) throws SQLException {
        super(connection, sql, rsType, rsConcurrency, rsHoldability);
        this.debugObjectId = objectId;
        this.debugSubprogramId = subprogramId;
        this.debugVersion = version;
    }

    @Override
    public void pdbgAbort() throws SQLException {
        this.checkDebugOn();
        this.connection.getSession().pdbgAbort(this);
    }

    private void initBreakpoints() {
        if (this.breakpointList.isEmpty()) {
            return;
        }
        for (DebugBreakpoint debugBreakpoint : this.breakpointList) {
            debugBreakpoint.setId(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pdbgStart() throws SQLException {
        if (this.debugOn) {
            throw new YasException("This DebugMode has been opened", YasState.OBJECT_NOT_IN_STATE);
        }
        ParameterList[] parameterLists = null;
        if (this.preparedParameters != null) {
            parameterLists = new ParameterList[]{this.preparedParameters};
        }
        YasDebugCallableStatement yasDebugCallableStatement = this;
        synchronized (yasDebugCallableStatement) {
            this.checkClosed();
            this.closeForNextExecution();
            this.currentResultSet = this.connection.getSession().pdbgExecute(this, parameterLists);
            if (this.debugOn) {
                this.checkSoVersion();
                this.syncBreakpoints();
            }
        }
    }

    private void checkSoVersion() throws SQLException {
        this.checkDebugOn();
        this.connection.getSession().pdbgCheckVersion(this, this.debugObjectId, this.debugSubprogramId, this.debugVersion);
    }

    @Override
    public DebugBreakpoint pdbgAddBreakpoint(long objectId, int subprogramId, int lineNum) throws SQLException {
        if (lineNum < 1) {
            throw SQLError.createSQLException("invalid parameter, ''lineNum'' should not be < 1", YasState.INVALID_PARAMETER_VALUE);
        }
        this.checkClosed();
        if (this.breakpointAlreadyExist(objectId, subprogramId, lineNum)) {
            throw new YasException("Break point has already exists.", YasState.DATA_ERROR);
        }
        DebugBreakpointImpl debugBreakpoint = new DebugBreakpointImpl(objectId, subprogramId, lineNum);
        this.breakpointList.add(debugBreakpoint);
        if (this.debugOn) {
            this.syncBreakpoints();
        }
        return debugBreakpoint;
    }

    private void syncBreakpoints() throws SQLException {
        this.checkDebugOn();
        ArrayList<DebugBreakpoint> syncBreakpointList = new ArrayList<DebugBreakpoint>();
        for (DebugBreakpoint debugBreakpoint : this.breakpointList) {
            if (debugBreakpoint.getId() != -1) continue;
            syncBreakpointList.add(debugBreakpoint);
        }
        if (syncBreakpointList.isEmpty()) {
            return;
        }
        this.connection.getSession().pdbgAddBreakpoint(this, syncBreakpointList);
    }

    private boolean breakpointAlreadyExist(long objectId, int subprogramId, int lineNum) {
        if (this.breakpointList.isEmpty()) {
            return false;
        }
        for (DebugBreakpoint debugBreakpoint : this.breakpointList) {
            if (debugBreakpoint.getObjectId() != objectId || debugBreakpoint.getSubprogramId() != subprogramId || debugBreakpoint.getLineNum() != lineNum) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pdbgDeleteBreakpoint(DebugBreakpoint breakpoint) throws SQLException {
        if (breakpoint == null) {
            throw SQLError.createSQLException("invalid parameter, ''breakpoint'' should not be null.", YasState.INVALID_PARAMETER_VALUE);
        }
        this.checkClosed();
        DebugBreakpoint delteBreakpoint = null;
        for (DebugBreakpoint debugBreakpoint : this.breakpointList) {
            if (!breakpoint.equals(debugBreakpoint)) continue;
            delteBreakpoint = debugBreakpoint;
            break;
        }
        if (delteBreakpoint == null) {
            throw new YasException("Break point does not exist.", YasState.DATA_ERROR);
        }
        if (this.debugOn) {
            ArrayList<DebugBreakpoint> delteBreakpointList = new ArrayList<DebugBreakpoint>();
            delteBreakpointList.add(delteBreakpoint);
            this.connection.getSession().pdbgDeleteBreakpoint(this, delteBreakpointList);
        }
        this.breakpointList.remove(delteBreakpoint);
    }

    @Override
    public List<DebugBreakpoint> pdbgShowBreakpoints() throws SQLException {
        this.checkClosed();
        return this.breakpointList;
    }

    private void checkDebugOn() throws SQLException {
        this.checkClosed();
        if (!this.debugOn) {
            throw SQLError.createSQLException(Messages.get("This DebugMode has been closed.", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void pdbgDeleteAllBreakpoints() throws SQLException {
        this.checkClosed();
        if (this.breakpointList.isEmpty()) {
            return;
        }
        if (this.debugOn) {
            this.connection.getSession().pdbgDeleteBreakpoint(this, this.breakpointList);
        }
        this.breakpointList.clear();
    }

    @Override
    public void pdbgStepInto() throws SQLException {
        this.checkDebugOn();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_STEP_INTO);
    }

    @Override
    public void pdbgStepOut() throws SQLException {
        this.checkDebugOn();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_STEP_OUT);
    }

    @Override
    public void pdbgContinue() throws SQLException {
        this.checkDebugOn();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_CONTINUE);
    }

    @Override
    public void pdbgStepNext() throws SQLException {
        this.checkDebugOn();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_STEP_NEXT);
    }

    @Override
    public List<DebugVar> pdbgShowFrameVariables() throws SQLException {
        this.checkDebugOn();
        return this.connection.getSession().pdbgShowVars(this);
    }

    @Override
    public List<DebugFrame> pdbgShowFrames() throws SQLException {
        this.checkDebugOn();
        return this.connection.getSession().pdbgShowFrames(this);
    }

    public void setDebugStatus(int debugStatus, long objectId, int subprogramId, int lineNum) {
        if (debugStatus == 0) {
            this.debugOn = false;
            this.initBreakpoints();
            this.runObjectId = -1L;
            this.runSubprogramId = -1;
            this.runLineNum = -1;
            return;
        }
        this.debugOn = true;
        this.runObjectId = objectId;
        this.runSubprogramId = subprogramId;
        this.runLineNum = lineNum;
    }

    @Override
    public long getRunObjectId() throws SQLException {
        this.checkDebugOn();
        return this.runObjectId;
    }

    @Override
    public int getRunSubprogramId() throws SQLException {
        this.checkDebugOn();
        return this.runSubprogramId;
    }

    @Override
    public int getRunLineNum() throws SQLException {
        this.checkDebugOn();
        return this.runLineNum;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.debugOn) {
            this.pdbgAbort();
        }
        super.close();
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }
}

