/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasConstants;
import com.yashandb.conf.ConnectionUrl;
import com.yashandb.conf.YasProperty;
import com.yashandb.jdbc.ConnectionImpl;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class YasDriver
implements Driver {
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!ConnectionUrl.acceptsUrl(url)) {
            return null;
        }
        ConnectionUrl connectionUrl = ConnectionUrl.getInstance(url, info);
        return ConnectionImpl.getInstance(connectionUrl);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return ConnectionUrl.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties copy = new Properties(info);
        Properties parse = ConnectionUrl.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        YasProperty[] knownProperties = YasProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return YasConstants.MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return YasConstants.MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger");
    }
}

