/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.exception.SQLError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class YasLobInputStream
extends InputStream {
    private YasLargeObject largeObject = null;
    private int cachePos = 0;
    private int cacheLen = 0;
    private long steamLobRemainSize = 0L;
    private long lobOffset = 0L;
    private byte[] cacheData = null;
    private boolean isClosed = false;

    public YasLobInputStream(YasLargeObject largeObject) throws SQLException {
        this.largeObject = largeObject;
        this.cachePos = 0;
        int stepSize = largeObject.getStepSize();
        if (stepSize > 0) {
            this.cacheData = new byte[stepSize];
        } else {
            int length = (int)largeObject.getLobLength();
            this.cacheData = new byte[length];
        }
        this.cacheLen = largeObject.getBytes(0L, this.cacheData);
        this.steamLobRemainSize = largeObject.getLobLength();
    }

    public YasLobInputStream(YasLargeObject largeObject, long pos, long length) throws SQLException {
        if (pos < 1L || length < 0L) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
        long start = pos - 1L;
        long lobLength = largeObject.getLobLength();
        if (length == 0L || lobLength == 0L || start >= lobLength) {
            return;
        }
        this.largeObject = largeObject;
        long byteLen = Math.min(length, lobLength);
        if (start + byteLen > lobLength) {
            byteLen = lobLength - start;
        }
        this.cachePos = 0;
        this.steamLobRemainSize = byteLen;
        int stepSize = largeObject.getStepSize();
        if (stepSize > 0) {
            this.cacheData = new byte[stepSize];
        } else {
            int dataLen = (int)largeObject.getLobLength();
            this.cacheData = new byte[dataLen];
        }
        this.lobOffset = start;
        this.cacheLen = largeObject.getBytes(start, this.cacheData);
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.steamLobRemainSize <= 0L) {
            return -1;
        }
        int value = this.cacheData[this.cachePos++] & 0xFF;
        --this.steamLobRemainSize;
        if (this.cachePos >= this.cacheLen) {
            this.lobOffset += (long)this.cacheLen;
            try {
                this.cacheLen = this.largeObject.getBytes(this.lobOffset, this.cacheData);
                this.cachePos = 0;
            }
            catch (SQLException sqlException) {
                throw new IOException(sqlException.getMessage());
            }
        }
        return value;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.cacheLen > 0) {
            return this.cacheLen - this.cachePos;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        super.close();
        this.isClosed = true;
    }
}

