/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.Session;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.CharacterSet;
import java.sql.SQLException;

public class YasLobProcessor {
    private long lobLength = 0L;
    private long lobCharLength = 0L;
    private long startPos = 0L;
    private long endPos = 0L;
    private int chunkSize = 0;
    private static final int STEP_COUNT = 4;
    private byte[] stepBuffer = null;
    private byte[] lobLocator = null;
    private byte[] cacheData = null;
    private Session session = null;
    private int innerLobType = -1;
    private YasLargeObject yasLob = null;
    public static final int LOB_LOCATOR_KNL = 0;
    public static final int LOB_LOCATOR_TEMP = 1;
    public static final int LOB_LOCATOR_MEM = 2;
    public static final int LOB_LOCATOR_KNL_IN_ROW = 3;
    public static final int LOB_LOCATOR_TEMP_IN_ROW = 4;
    private static final int LOB_WRITE_APPEND_DATA_FLAG = -1;
    private static final int LOB_LOCATOR_LOB_SIZE_POS = 72;
    private int lobType = 0;
    private boolean updated = false;

    public int getInnerLobType() {
        return this.innerLobType;
    }

    public void setInnerLobType(int innerLobType) {
        this.innerLobType = innerLobType;
    }

    public long getLobLength() {
        return this.lobLength;
    }

    long getCharLength() throws SQLException {
        int readSize;
        if (this.lobLength == 0L) {
            return 0L;
        }
        if (this.lobCharLength > 0L) {
            return this.lobCharLength;
        }
        this.lobCharLength = 0L;
        byte[] tmpBuffer = this.getStepByteBuffer();
        long bytesSize = this.lobLength;
        long starPos = 0L;
        while (bytesSize > 0L && (readSize = this.getBytes(starPos, tmpBuffer)) > 0) {
            String strValue = new String(tmpBuffer, 0, readSize, CharacterSet.getCharSet(this.getCharset()));
            this.lobCharLength += (long)strValue.length();
            bytesSize -= (long)readSize;
            starPos += (long)readSize;
        }
        return this.lobCharLength;
    }

    public int getStepSize() {
        if (this.chunkSize <= 0) {
            return 0;
        }
        return this.chunkSize * 4;
    }

    private void checkBufferSize() {
        if (this.cacheData == null || this.cacheData.length < this.getStepSize()) {
            this.cacheData = new byte[this.getStepSize()];
        }
    }

    public int getBytes(long lobOffset, byte[] data) throws SQLException {
        if (data == null) {
            return 0;
        }
        if (lobOffset >= this.startPos && lobOffset < this.endPos) {
            int catchStart = (int)(lobOffset - this.startPos);
            int copyLen = Math.min(data.length, (int)(this.endPos - lobOffset));
            System.arraycopy(this.cacheData, catchStart, data, 0, copyLen);
            return copyLen;
        }
        if (lobOffset < this.lobLength) {
            this.checkBufferSize();
            int reqLen = this.getStepSize();
            if ((long)reqLen > this.lobLength - lobOffset) {
                reqLen = (int)(this.lobLength - lobOffset);
            }
            int cacheDataLen = this.session.getLobData(this, reqLen, lobOffset, this.cacheData);
            this.startPos = lobOffset;
            this.endPos = lobOffset + (long)cacheDataLen;
            int copyLen = Math.min(cacheDataLen, data.length);
            System.arraycopy(this.cacheData, 0, data, 0, copyLen);
            return copyLen;
        }
        return 0;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void initCacheBuffer(int cacheLength) {
        this.cacheData = new byte[cacheLength];
    }

    public void setEndPos(long endPos) {
        this.endPos = endPos;
    }

    public void setCacheData(byte[] srcData, int srcPos, int dataLen) {
        if (this.cacheData == null || this.cacheData.length < dataLen) {
            this.cacheData = new byte[dataLen];
        }
        System.arraycopy(srcData, srcPos, this.cacheData, 0, dataLen);
    }

    public void setLobLocator(byte[] lobLocator) {
        this.lobLocator = lobLocator;
    }

    public byte[] getLobLocator() {
        if (this.lobLocator == null) {
            return null;
        }
        byte[] data = new byte[this.lobLocator.length];
        System.arraycopy(this.lobLocator, 0, data, 0, this.lobLocator.length);
        return data;
    }

    public void setLobLength(long lobLength) {
        this.lobLength = lobLength;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public long length() throws SQLException {
        return this.lobLength;
    }

    private byte[] getStepByteBuffer() {
        if (this.stepBuffer != null) {
            return this.stepBuffer;
        }
        int stepSize = this.getStepSize();
        this.stepBuffer = this.getStepSize() > 0 ? new byte[stepSize] : new byte[(int)this.lobLength];
        return this.stepBuffer;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        int copyLen;
        if (pos < 1L || length < 0) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        long start = pos - 1L;
        if (length == 0 || this.lobLength == 0L || start >= this.lobLength) {
            return new byte[0];
        }
        int byteLen = (int)Math.min((long)length, this.lobLength);
        if (start + (long)byteLen > this.lobLength) {
            byteLen = (int)(this.lobLength - start);
        }
        if (byteLen <= 0) {
            return new byte[0];
        }
        this.resetCache();
        byte[] stepBytes = this.getStepByteBuffer();
        byte[] dataBytes = new byte[byteLen];
        int dataIndex = 0;
        while (byteLen > 0 && (copyLen = this.getBytes(start, stepBytes)) > 0) {
            if (copyLen > byteLen) {
                copyLen = byteLen;
            }
            System.arraycopy(stepBytes, 0, dataBytes, dataIndex, copyLen);
            start += (long)copyLen;
            dataIndex += copyLen;
            byteLen -= copyLen;
        }
        return dataBytes;
    }

    private void resetCache() {
        if (this.lobLocator != null && this.startPos != 0L) {
            this.startPos = 0L;
            this.endPos = 0L;
        }
    }

    public String getSubString(long pos, int length) throws SQLException {
        int bytesLen;
        long readCharLen;
        if (pos < 1L || length < 0) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        if (this.lobLength > 0L && this.lobCharLength <= 0L) {
            this.getCharLength();
        }
        long charStart = pos - 1L;
        if (length == 0 || this.lobCharLength == 0L || charStart >= this.lobCharLength) {
            return "";
        }
        int strLen = (int)Math.min((long)length, this.lobCharLength);
        if (charStart + (long)strLen > this.lobCharLength) {
            strLen = (int)(this.lobCharLength - charStart);
        }
        if (strLen <= 0) {
            return "";
        }
        this.resetCache();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] strBytes = null;
        int stepSize = this.getStepSize();
        strBytes = this.getStepSize() > 0 ? new byte[stepSize] : new byte[(int)this.lobLength];
        long byteStart = 0L;
        String readStr = null;
        for (readCharLen = 0L; readCharLen < charStart + 1L && (bytesLen = this.getBytes(byteStart, strBytes)) != 0; readCharLen += (long)readStr.length()) {
            byteStart += (long)bytesLen;
            readStr = new String(strBytes, 0, bytesLen, CharacterSet.getCharSet(this.getCharset()));
        }
        if (readStr.length() > 0) {
            stringBuilder.append(readStr.substring(readStr.length() - (int)(readCharLen - charStart)));
            strLen -= stringBuilder.length();
        }
        while (strLen > 0 && (bytesLen = this.getBytes(byteStart, strBytes)) > 0) {
            String strValue = new String(strBytes, 0, bytesLen, CharacterSet.getCharSet(this.getCharset()));
            stringBuilder.append(strValue);
            byteStart += (long)bytesLen;
            strLen -= strValue.length();
        }
        if (strLen < 0) {
            return stringBuilder.substring(0, stringBuilder.length() + strLen);
        }
        return stringBuilder.toString();
    }

    public int setString(long pos, String str) throws SQLException {
        int strLength = str.length();
        if (strLength > 40000 && (this.innerLobType == 0 || this.innerLobType == 3)) {
            return this.setStringByLobLocator(pos, str);
        }
        long reqPos = pos;
        for (int sendLen = 0; sendLen < strLength; sendLen += 40000) {
            String reqString = strLength > sendLen + 40000 ? str.substring(sendLen, sendLen + 40000) : str.substring(sendLen);
            byte[] bytes = reqString.getBytes(CharacterSet.getCharSet(this.getCharset()));
            long bytesPos = reqPos - 1L;
            this.lobLength = this.session.writeLob(this, bytesPos, bytes, 0, bytes.length);
            reqPos += 40000L;
        }
        this.innerLobType = this.lobLocator[0] & 0xFF;
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        this.startPos = 0L;
        this.endPos = 0L;
        this.lobCharLength = Math.max(pos + (long)str.length() - 1L, this.lobCharLength);
        this.updated = true;
        if (this.isKnlLob()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return strLength;
    }

    public int appendString(String str) throws SQLException {
        int strLength = str.length();
        for (int sendLen = 0; sendLen < strLength; sendLen += 40000) {
            String reqString = strLength > sendLen + 40000 ? str.substring(sendLen, sendLen + 40000) : str.substring(sendLen);
            byte[] bytes = reqString.getBytes(CharacterSet.getCharSet(this.getCharset()));
            this.lobLength = this.session.writeLob(this, -1L, bytes, 0, bytes.length);
        }
        this.innerLobType = this.lobLocator[0] & 0xFF;
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        this.lobCharLength += (long)str.length();
        this.updated = true;
        if (this.isKnlLob()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return strLength;
    }

    public int setBytes(long pos, byte[] bytes, int start, int length) throws SQLException {
        if (length > 320000 && (this.innerLobType == 0 || this.innerLobType == 3)) {
            return this.setBytesByLobLocator(pos, bytes, start, length);
        }
        long bytesPos = pos - 1L;
        this.lobLength = this.session.writeLob(this, bytesPos, bytes, start, length);
        this.innerLobType = this.lobLocator[0] & 0xFF;
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        if (this.startPos > bytesPos) {
            this.resetCache();
        } else if (this.endPos > bytesPos) {
            this.endPos = bytesPos;
        }
        this.updated = true;
        if (this.isKnlLob()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return length;
    }

    public void free() throws SQLException {
        this.session.closeLob(this);
    }

    public void truncate(long len) throws SQLException {
        if (len < 0L || len > this.lobLength) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        this.lobLength = this.session.trimLob(this, len);
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        if (this.startPos > this.lobLength) {
            this.resetCache();
        } else if (this.endPos > this.lobLength) {
            this.endPos = this.lobLength;
        }
        if (this.lobCharLength != 0L) {
            this.lobCharLength = len;
        }
        this.updated = true;
        if (this.isKnlLob()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStringByLobLocator(long pos, String str) throws SQLException {
        int strLength = str.length();
        YasClob tempClob = (YasClob)this.session.getConnection().createClob();
        try {
            tempClob.setString(1L, str);
            byte[] bytes = tempClob.getLobLocator();
            long bytesPos = pos - 1L;
            this.lobLength = this.session.writeLobByLobLocator(this, bytesPos, bytes);
            this.innerLobType = this.lobLocator[0] & 0xFF;
            if (this.chunkSize <= 0) {
                this.chunkSize = this.session.getLobChunkSize(this);
            }
            this.startPos = 0L;
            this.endPos = 0L;
            this.lobCharLength = Math.max(pos + (long)str.length() - 1L, this.lobCharLength);
            this.updated = true;
            if (this.isKnlLob()) {
                this.session.addUpdatedKnlLob(this.yasLob);
            }
            int n = strLength;
            return n;
        }
        finally {
            tempClob.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytesByLobLocator(long pos, byte[] bytes, int start, int length) throws SQLException {
        YasBlob tempBlob = (YasBlob)this.session.getConnection().createBlob();
        try {
            tempBlob.setBytes(1L, bytes, start, length);
            byte[] reqLobLocator = tempBlob.getLobLocator();
            long bytesPos = pos - 1L;
            this.lobLength = this.session.writeLobByLobLocator(this, bytesPos, reqLobLocator);
            this.innerLobType = this.lobLocator[0] & 0xFF;
            if (this.chunkSize <= 0) {
                this.chunkSize = this.session.getLobChunkSize(this);
            }
            if (this.startPos > bytesPos) {
                this.resetCache();
            } else if (this.endPos > bytesPos) {
                this.endPos = bytesPos;
            }
            this.updated = true;
            if (this.isKnlLob()) {
                this.session.addUpdatedKnlLob(this.yasLob);
            }
            int n = length;
            return n;
        }
        finally {
            tempBlob.free();
        }
    }

    public int getLobType() {
        return this.lobType;
    }

    public void setLobType(int lobType) {
        this.lobType = lobType;
    }

    public int getCsLobLocatorSize() {
        if (this.lobLocator != null) {
            return this.lobLocator.length;
        }
        if (this.session.getConnectVersion() == ConnectVersion.VER1) {
            return 72;
        }
        return 80;
    }

    private short getCharset() {
        if (this.getLobType() == 33) {
            return this.session.getnCharset();
        }
        return this.session.getCharset();
    }

    public void setYasLob(YasLargeObject yasLob) {
        this.yasLob = yasLob;
    }

    private boolean isKnlLob() {
        return this.innerLobType == 0 || this.innerLobType == 3;
    }

    public void initLobLength() throws SQLException {
        if (this.session.getConnectVersion().getValue() > ConnectVersion.VER1.getValue()) {
            this.lobLength = ByteConverter.int8(this.lobLocator, 72);
            return;
        }
        this.lobLength = this.session.getLobLength(this);
    }
}

