/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class YasParameterMetaData
implements ParameterMetaData {
    private final YasConnection connection;
    private final Field[] fields;
    private boolean throwUnsupportedFeature = false;

    public YasParameterMetaData(YasConnection connection, Field[] parameterFields) {
        this.connection = connection;
        this.fields = parameterFields;
    }

    public void setThrowUnsupported(boolean throwUnsupported) {
        this.throwUnsupportedFeature = throwUnsupported;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return "";
    }

    @Override
    public int getParameterCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.length;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        Field field = this.getField(param);
        return field.getYasType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        Field field = this.getField(param);
        return field.getTypeName();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        Field field = this.getField(param);
        return field.getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        Field field = this.getField(param);
        return field.getScale();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return false;
    }

    private void checkParamIndex(int param) throws SQLException {
        if (this.throwUnsupportedFeature) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "checkParamIndex for autoKey");
        }
        if (this.fields == null) {
            throw SQLError.createSQLException("The parameter count is 0", YasState.DATA_ERROR);
        }
        if (param < 1 || param > this.fields.length) {
            throw SQLError.createSQLException(Messages.get("The parameter index is out of range: {0}, number of parameters: {1}.", param, this.fields.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    private Field getField(int columnIndex) throws SQLException {
        this.checkParamIndex(columnIndex);
        return this.fields[columnIndex - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

