/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.ByteConverter;
import java.math.BigInteger;
import java.sql.RowId;
import java.sql.SQLException;

public class YasRowID
implements RowId {
    private byte[] data;
    private String strValue;
    private static final int ROW_ID_LEN = 16;
    private static final int ROWID_MAX_SPACE = 2048;
    private static final int ROWID_MAX_FILEID = 64;
    private static final int ROWID_MAX_BLOCKID = 0x4000000;
    private static final int ROWID_MAX_DIR = 4096;
    private static final int ROWID_STRING_SEGMENT = 5;

    public YasRowID(byte[] bytes) throws SQLException {
        if (bytes.length != 16) {
            throw SQLError.createSQLException("rowid data size should be 16 bytes", YasState.DATA_ERROR);
        }
        this.data = new byte[16];
        System.arraycopy(bytes, 0, this.data, 0, 16);
        this.convertDataToStr();
    }

    public YasRowID(String strValue) throws SQLException {
        if (strValue == null) {
            throw SQLError.createSQLException("The parameter can not be empty", YasState.INVALID_PARAMETER_VALUE);
        }
        this.strValue = strValue;
        this.data = new byte[16];
        this.convertStrToData();
    }

    private void convertDataToStr() {
        String bigLongStr;
        if ((long)this.data[7] < 0L) {
            byte[] tempIntData = new byte[8];
            System.arraycopy(this.data, 0, tempIntData, 0, 8);
            BigInteger bigInteger = new BigInteger(1, tempIntData);
            bigLongStr = bigInteger.toString();
        } else {
            long dataObjectId = ((long)this.data[7] & 0xFFL) << 56 | ((long)this.data[6] & 0xFFL) << 48 | ((long)this.data[5] & 0xFFL) << 40 | ((long)this.data[4] & 0xFFL) << 32 | ((long)this.data[3] & 0xFFL) << 24 | ((long)this.data[2] & 0xFFL) << 16 | ((long)this.data[1] & 0xFFL) << 8 | (long)this.data[0] & 0xFFL;
            bigLongStr = String.valueOf(dataObjectId);
        }
        int file = this.data[8] & 0x3F;
        int block = (this.data[11] & 0xFF) << 18 | (this.data[10] & 0xFF) << 10 | (this.data[9] & 0xFF) << 2 | (this.data[8] & 0xC0) >> 6;
        int dir = (this.data[13] & 0xFF) << 8 | this.data[12] & 0xFF;
        int space = (this.data[15] & 0xFF) << 8 | this.data[14] & 0xFF;
        this.strValue = String.format("%s:%d:%d:%d:%d", bigLongStr, space, file, block, dir);
    }

    private void convertStrToData() throws SQLException {
        String[] split = this.strValue.split(":");
        if (split.length == 5) {
            int dir;
            int block;
            int file;
            int space;
            long dataObjectId;
            try {
                dataObjectId = new BigInteger(split[0]).longValue();
                space = Integer.valueOf(split[1]);
                file = Integer.valueOf(split[2]);
                block = Integer.valueOf(split[3]);
                dir = Integer.valueOf(split[4]);
            }
            catch (NumberFormatException e) {
                throw SQLError.createSQLException("invalid ROWID string", YasState.INVALID_PARAMETER_VALUE);
            }
            if (space >= 2048 || file >= 64 || block >= 0x4000000 || dir >= 4096) {
                throw SQLError.createSQLException("invalid ROWID string", YasState.INVALID_PARAMETER_VALUE);
            }
            ByteConverter.int8(this.data, 0, dataObjectId);
            this.data[8] = (byte)(file | block << 6);
            this.data[9] = (byte)(block >>> 2);
            this.data[10] = (byte)(block >>> 10);
            this.data[11] = (byte)(block >>> 18);
            ByteConverter.int2(this.data, 12, dir);
            ByteConverter.int2(this.data, 14, space);
            return;
        }
        throw SQLError.createSQLException("invalid ROWID string", YasState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public byte[] getBytes() {
        return this.strValue.getBytes();
    }

    @Override
    public String toString() {
        return this.strValue;
    }

    public byte[] getRowIdBytes() {
        if (this.data == null) {
            return null;
        }
        byte[] resData = new byte[16];
        System.arraycopy(this.data, 0, resData, 0, 16);
        return resData;
    }
}

