/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class YasTypes {
    public static final int BIT = -7;
    public static final int TINYINT = -6;
    public static final int SMALLINT = 5;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 8;
    public static final int BOOLEAN = 16;
    public static final int REAL = 7;
    public static final int NUMERIC = 2;
    public static final int NUMBER = 2;
    public static final int DECIMAL = 3;
    public static final int TIME = 92;
    public static final int DATE = 91;
    public static final int TIMESTAMP = 93;
    public static final int TIMESTAMP_TZ = 2014;
    public static final int TIMESTAMP_LTZ = 2014;
    public static final int SHORTTIME = 92;
    public static final int CHAR = 1;
    public static final int NCHAR = -15;
    public static final int VARCHAR = 12;
    public static final int NVARCHAR = -9;
    public static final int CLOB = 2005;
    public static final int BLOB = 2004;
    public static final int NCLOB = 2011;
    public static final int ROWID = -8;
    public static final int STRUCT = 2002;
    public static final int ARRAY = 2003;
    public static final int REF = 2006;
    public static final int BINARY = -2;
    public static final int RAW = -2;
    public static final int VARBINARY = -3;
    public static final int LONGVARBINARY = -4;
    public static final int NULL = 0;
    public static final int UNKNOWN = 0;
    public static final int OTHER = 1111;
    public static final int REF_CURSOR = 2012;
    private static final int YASHAN_JDBC_TYPES_BASE = 3000;
    public static final int YM_INTERVAL = 3001;
    public static final int DS_INTERVAL = 3002;
    public static final int UTINYINT = 3003;
    public static final int USMALLINT = 3004;
    public static final int UINTEGER = 3005;
    public static final int UBIGINT = 3006;
    public static final int SHORTDATE = 3007;
    public static final int CURSOR = 3008;
    public static final int JSON = 3009;

    public static int getSQLType(int yashanType) {
        switch (yashanType) {
            case 2: {
                return -6;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return -5;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 2;
            }
            case 15: {
                return 92;
            }
            case 13: {
                return 91;
            }
            case 16: {
                return 93;
            }
            case 17: {
                return 2014;
            }
            case 18: {
                return 2014;
            }
            case 24: {
                return 1;
            }
            case 25: {
                return -15;
            }
            case 26: {
                return 12;
            }
            case 27: {
                return -9;
            }
            case 28: {
                return -2;
            }
            case 29: {
                return 2005;
            }
            case 33: {
                return 2011;
            }
            case 30: {
                return 2004;
            }
            case 31: {
                return -7;
            }
            case 1: {
                return 16;
            }
            case 32: {
                return -8;
            }
            case 0: {
                return 0;
            }
            case 19: {
                return 3001;
            }
            case 20: {
                return 3002;
            }
            case 6: {
                return 3003;
            }
            case 7: {
                return 3004;
            }
            case 8: {
                return 3005;
            }
            case 9: {
                return 3006;
            }
            case 14: {
                return 3007;
            }
            case 34: {
                return 3008;
            }
            case 35: {
                return 3009;
            }
        }
        return 1111;
    }

    public static int getYasType(int sqlType) throws SQLException {
        int yashanType;
        switch (sqlType) {
            case 4: {
                yashanType = 4;
                break;
            }
            case -6: {
                yashanType = 2;
                break;
            }
            case 5: {
                yashanType = 3;
                break;
            }
            case -5: {
                yashanType = 5;
                break;
            }
            case -7: {
                yashanType = 31;
                break;
            }
            case 16: {
                yashanType = 1;
                break;
            }
            case 7: {
                yashanType = 10;
                break;
            }
            case 6: 
            case 8: {
                yashanType = 11;
                break;
            }
            case 2: 
            case 3: {
                yashanType = 12;
                break;
            }
            case 1: {
                yashanType = 24;
                break;
            }
            case -1: 
            case 12: {
                yashanType = 26;
                break;
            }
            case -16: 
            case -9: {
                yashanType = 27;
                break;
            }
            case -15: {
                yashanType = 25;
                break;
            }
            case 2011: {
                yashanType = 33;
                break;
            }
            case 91: {
                yashanType = 13;
                break;
            }
            case 92: 
            case 2013: {
                yashanType = 15;
                break;
            }
            case 93: 
            case 2014: {
                yashanType = 16;
                break;
            }
            case 3002: {
                yashanType = 20;
                break;
            }
            case 3001: {
                yashanType = 19;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                yashanType = 28;
                break;
            }
            case 2004: {
                yashanType = 30;
                break;
            }
            case 2005: {
                yashanType = 29;
                break;
            }
            case -8: {
                yashanType = 32;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                yashanType = 0;
                break;
            }
            case 2012: 
            case 3008: {
                yashanType = 34;
                break;
            }
            case 3009: {
                yashanType = 35;
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Unknown Types value.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
            }
        }
        return yashanType;
    }

    public static String getTypeClassName(int yashanType) {
        switch (yashanType) {
            case 2: 
            case 3: 
            case 4: {
                return Integer.class.getName();
            }
            case 5: {
                return Long.class.getName();
            }
            case 10: {
                return Float.class.getName();
            }
            case 11: {
                return Double.class.getName();
            }
            case 12: {
                return BigDecimal.class.getName();
            }
            case 15: {
                return Time.class.getName();
            }
            case 13: {
                return Date.class.getName();
            }
            case 16: {
                return Timestamp.class.getName();
            }
            case 17: {
                return Timestamp.class.getName();
            }
            case 18: {
                return Timestamp.class.getName();
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return String.class.getName();
            }
            case 28: {
                return byte[].class.getName();
            }
            case 29: {
                return Clob.class.getName();
            }
            case 33: {
                return NClob.class.getName();
            }
            case 30: {
                return Blob.class.getName();
            }
            case 31: {
                return byte[].class.getName();
            }
            case 1: {
                return Boolean.class.getName();
            }
            case 32: {
                return RowId.class.getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return String.class.getName();
            }
            case 20: {
                return String.class.getName();
            }
            case 6: 
            case 7: 
            case 8: {
                return Integer.class.getName();
            }
            case 9: {
                return Long.class.getName();
            }
            case 14: {
                return Date.class.getName();
            }
        }
        return null;
    }
}

