/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.exception;

import com.yashandb.jdbc.exception.ServerErrorMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatchError
extends ServerErrorMessage {
    private static final Pattern pattern = Pattern.compile("\\[line: [0-9]+ column: [0-9]+\\] YAS-[0-9]+ ");

    public BatchError(int errCode, String msg) {
        super(errCode, 0, 0, msg);
    }

    @Override
    public String toString() {
        return "YAS-" + String.format("%05d", this.errCode) + " " + this.msg;
    }

    public static String converMsgToBatchMsg(String msg) {
        Matcher matcher = pattern.matcher(msg);
        if (matcher.find()) {
            return msg.substring(matcher.end());
        }
        return null;
    }
}

