/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.exception;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLExceptionType;
import com.yashandb.jdbc.exception.ServerErrorMessage;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class SQLError {
    public static YasException createSQLException(String message, YasState sqlState) {
        return new YasException(message, sqlState);
    }

    public static YasException createSQLException(String message, YasState sqlState, Throwable cause) {
        return new YasException(message, sqlState, cause);
    }

    public static SQLException createSQLException(ServerErrorMessage serverError, boolean detail) {
        return SQLError.createSQLException(serverError, detail, null);
    }

    public static SQLException createSQLException(ServerErrorMessage serverError, boolean detail, Throwable cause) {
        SQLException exception;
        SQLExceptionType sqlExceptionType = SQLExceptionType.findServerSQLExceptionType(serverError);
        SQLException sQLException = exception = sqlExceptionType != null ? sqlExceptionType.newSQLException(serverError.toString(), serverError.getErrCode()) : new YasException(serverError, detail);
        if (cause != null) {
            exception.initCause(cause);
        }
        return exception;
    }

    public static SQLException createSQLFeatureNotSupportedException(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(Messages.get("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), YasState.NOT_IMPLEMENTED.getState());
    }

    public static YasException OverFlowException(String fromType, String toType) {
        return SQLError.createSQLException(Messages.get("Convert an instance of {0} to type {1} OverFlow", fromType.toUpperCase(), toType.toUpperCase()), YasState.DATA_ERROR);
    }

    public static YasException TransformException(String fromType, String toType) {
        return SQLError.TransformException(fromType, toType, null);
    }

    public static YasException TransformException(String fromType, String toType, Exception cause) {
        return SQLError.createSQLException(Messages.get("Cannot convert an instance of {0} to type {1}", fromType.toUpperCase(), toType.toUpperCase()), YasState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    public static YasException ConvertValueException(String fromType, String value, String toType) {
        return SQLError.ConvertValueException(fromType, value, toType, null);
    }

    public static YasException ConvertValueException(String fromType, String value, String toType, Exception cause) {
        return SQLError.createSQLException(Messages.get("Cannot convert {0} value \"{1}\" to type {2}", fromType.toUpperCase(), value, toType.toUpperCase()), YasState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }
}

