/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.exception;

import com.yashandb.jdbc.exception.ServerErrorMessage;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SQLExceptionType {
    SQLNONTRANSIENTEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLNonTransientException(errorMessage, "58000", errorCode);
        }
    }
    ,
    SQLTRANSIENTEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLTransientException(errorMessage, "57000", errorCode);
        }
    }
    ,
    SQLDATAEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLDataException(errorMessage, "22000", errorCode);
        }
    }
    ,
    SQLFEATURENOTSUPPORTEDEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLFeatureNotSupportedException(errorMessage, "0A000", errorCode);
        }
    }
    ,
    SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLIntegrityConstraintViolationException(errorMessage, "23000", errorCode);
        }
    }
    ,
    SQLINVALIDAUTHORIZATIONSPECEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLInvalidAuthorizationSpecException(errorMessage, "28000", errorCode);
        }
    }
    ,
    SQLNONTRANSIENTCONNECTIONEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLNonTransientConnectionException(errorMessage, "08000", errorCode);
        }
    }
    ,
    SQLSYNTAXERROREXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLSyntaxErrorException(errorMessage, "42000", errorCode);
        }
    }
    ,
    SQLTIMEOUTEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLTimeoutException(errorMessage, "57000", errorCode);
        }
    }
    ,
    SQLTRANSACTIONROLLBACKEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLTransactionRollbackException(errorMessage, "40000", errorCode);
        }
    }
    ,
    SQLTRANSIENTCONNECTIONEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLTransientConnectionException(errorMessage, "08000", errorCode);
        }
    }
    ,
    SQLRECOVERABLEEXCEPTION{

        @Override
        SQLException newInstance(String errorMessage, int errorCode) {
            return new SQLRecoverableException(errorMessage, "56000", errorCode);
        }
    };

    private static final Map<Integer, String> serverErrorMap;

    public static SQLExceptionType findServerSQLExceptionType(int errorCode) {
        if (serverErrorMap.containsKey(errorCode)) {
            return SQLExceptionType.valueOf(serverErrorMap.get(errorCode).toUpperCase());
        }
        return null;
    }

    public static SQLExceptionType findServerSQLExceptionType(ServerErrorMessage serverError) {
        if (serverErrorMap.containsKey(serverError.getErrCode())) {
            return SQLExceptionType.valueOf(serverErrorMap.get(serverError.getErrCode()).toUpperCase());
        }
        List<Integer> otherErrorCode = serverError.getOtherErrorCode();
        for (Integer errorcode : otherErrorCode) {
            if (!serverErrorMap.containsKey(errorcode)) continue;
            return SQLExceptionType.valueOf(serverErrorMap.get(errorcode).toUpperCase());
        }
        return null;
    }

    abstract SQLException newInstance(String var1, int var2);

    public SQLException newSQLException(String errorMessage, int errCode) {
        return this.newInstance(errorMessage, errCode);
    }

    static {
        serverErrorMap = Stream.of({3, "SQLDataException"}, {4, "SQLFeatureNotSupportedException"}, {5, "SQLDataException"}, {7, "SQLDataException"}, {8, "SQLDataException"}, {9, "SQLDataException"}, {10, "SQLDataException"}, {11, "SQLDataException"}, {12, "SQLDataException"}, {13, "SQLDataException"}, {14, "SQLDataException"}, {15, "SQLDataException"}, {16, "SQLDataException"}, {17, "SQLDataException"}, {18, "SQLDataException"}, {21, "SQLDataException"}, {22, "SQLDataException"}, {23, "SQLDataException"}, {24, "SQLDataException"}, {25, "SQLDataException"}, {26, "SQLDataException"}, {27, "SQLDataException"}, {28, "SQLDataException"}, {29, "SQLDataException"}, {30, "SQLDataException"}, {31, "SQLDataException"}, {33, "SQLDataException"}, {37, "SQLDataException"}, {104, "SQLDataException"}, {202, "SQLSyntaxErrorException"}, {203, "SQLSyntaxErrorException"}, {207, "SQLSyntaxErrorException"}, {208, "SQLSyntaxErrorException"}, {209, "SQLSyntaxErrorException"}, {210, "SQLSyntaxErrorException"}, {211, "SQLDataException"}, {216, "SQLDataException"}, {217, "SQLSyntaxErrorException"}, {218, "SQLDataException"}, {220, "SQLDataException"}, {221, "SQLDataException"}, {222, "SQLFeatureNotSupportedException"}, {223, "SQLDataException"}, {402, "SQLNonTransientConnectionException"}, {404, "SQLNonTransientConnectionException"}, {405, "SQLNonTransientConnectionException"}, {406, "SQLNonTransientConnectionException"}, {407, "SQLNonTransientConnectionException"}, {408, "SQLNonTransientConnectionException"}, {409, "SQLNonTransientConnectionException"}, {413, "SQLTransientConnectionException"}, {507, "SQLDataException"}, {508, "SQLDataException"}, {1206, "SQLRecoverableException"}, {1406, "SQLRecoverableException"}, {1407, "SQLRecoverableException"}, {1410, "SQLNonTransientConnectionException"}, {1412, "SQLRecoverableException"}, {2010, "SQLInvalidAuthorizationSpecException"}, {2011, "SQLTransientException"}, {2015, "SQLRecoverableException"}, {2023, "SQLTransientException"}, {2024, "SQLTransientException"}, {2025, "SQLTransientException"}, {2028, "SQLRecoverableException"}, {2030, "SQLIntegrityConstraintViolationException"}, {2031, "SQLSyntaxErrorException"}, {2032, "SQLSyntaxErrorException"}, {2033, "SQLIntegrityConstraintViolationException"}, {2034, "SQLIntegrityConstraintViolationException"}, {2094, "SQLTimeoutException"}, {2100, "SQLRecoverableException"}, {2116, "SQLRecoverableException"}, {2143, "SQLInvalidAuthorizationSpecException"}, {2188, "SQLSyntaxErrorException"}, {2239, "SQLInvalidAuthorizationSpecException"}, {2242, "SQLDataException"}, {2243, "SQLRecoverableException"}, {2244, "SQLDataException"}, {2247, "SQLRecoverableException"}, {2248, "SQLRecoverableException"}, {2254, "SQLIntegrityConstraintViolationException"}, {2255, "SQLIntegrityConstraintViolationException"}, {2267, "SQLRecoverableException"}, {2268, "SQLSyntaxErrorException"}, {2285, "SQLSyntaxErrorException"}, {2286, "SQLFeatureNotSupportedException"}, {3001, "SQLSyntaxErrorException"}, {3006, "SQLFeatureNotSupportedException"}, {3237, "SQLDataException"}, {3243, "SQLFeatureNotSupportedException"}, {3410, "SQLRecoverableException"}, {3505, "SQLNonTransientException"}, {3508, "SQLFeatureNotSupportedException"}, {3701, "SQLRecoverableException"}, {3702, "SQLRecoverableException"}, {3709, "SQLRecoverableException"}, {3711, "SQLNonTransientException"}, {3712, "SQLRecoverableException"}, {4001, "SQLDataException"}, {4002, "SQLSyntaxErrorException"}, {4003, "SQLDataException"}, {4005, "SQLFeatureNotSupportedException"}, {4006, "SQLIntegrityConstraintViolationException"}, {4008, "SQLDataException"}, {4012, "SQLFeatureNotSupportedException"}, {4101, "SQLSyntaxErrorException"}, {4102, "SQLSyntaxErrorException"}, {4103, "SQLSyntaxErrorException"}, {4104, "SQLSyntaxErrorException"}, {4105, "SQLSyntaxErrorException"}, {4106, "SQLSyntaxErrorException"}, {4107, "SQLSyntaxErrorException"}, {4108, "SQLSyntaxErrorException"}, {4109, "SQLSyntaxErrorException"}, {4110, "SQLSyntaxErrorException"}, {4111, "SQLSyntaxErrorException"}, {4112, "SQLSyntaxErrorException"}, {4113, "SQLSyntaxErrorException"}, {4114, "SQLSyntaxErrorException"}, {4115, "SQLSyntaxErrorException"}, {4116, "SQLSyntaxErrorException"}, {4117, "SQLSyntaxErrorException"}, {4118, "SQLSyntaxErrorException"}, {4119, "SQLSyntaxErrorException"}, {4120, "SQLSyntaxErrorException"}, {4121, "SQLSyntaxErrorException"}, {4201, "SQLSyntaxErrorException"}, {4202, "SQLSyntaxErrorException"}, {4203, "SQLSyntaxErrorException"}, {4204, "SQLDataException"}, {4205, "SQLSyntaxErrorException"}, {4206, "SQLDataException"}, {4207, "SQLDataException"}, {4208, "SQLSyntaxErrorException"}, {4209, "SQLSyntaxErrorException"}, {4210, "SQLSyntaxErrorException"}, {4211, "SQLSyntaxErrorException"}, {4212, "SQLSyntaxErrorException"}, {4213, "SQLSyntaxErrorException"}, {4214, "SQLSyntaxErrorException"}, {4215, "SQLSyntaxErrorException"}, {4216, "SQLSyntaxErrorException"}, {4217, "SQLSyntaxErrorException"}, {4218, "SQLSyntaxErrorException"}, {4219, "SQLSyntaxErrorException"}, {4220, "SQLSyntaxErrorException"}, {4221, "SQLSyntaxErrorException"}, {4222, "SQLSyntaxErrorException"}, {4223, "SQLSyntaxErrorException"}, {4224, "SQLSyntaxErrorException"}, {4225, "SQLSyntaxErrorException"}, {4226, "SQLSyntaxErrorException"}, {4227, "SQLSyntaxErrorException"}, {4228, "SQLSyntaxErrorException"}, {4229, "SQLSyntaxErrorException"}, {4230, "SQLSyntaxErrorException"}, {4231, "SQLSyntaxErrorException"}, {4232, "SQLSyntaxErrorException"}, {4233, "SQLSyntaxErrorException"}, {4234, "SQLSyntaxErrorException"}, {4235, "SQLSyntaxErrorException"}, {4236, "SQLSyntaxErrorException"}, {4237, "SQLSyntaxErrorException"}, {4238, "SQLSyntaxErrorException"}, {4239, "SQLSyntaxErrorException"}, {4240, "SQLSyntaxErrorException"}, {4241, "SQLSyntaxErrorException"}, {4242, "SQLSyntaxErrorException"}, {4243, "SQLSyntaxErrorException"}, {4244, "SQLSyntaxErrorException"}, {4245, "SQLSyntaxErrorException"}, {4246, "SQLSyntaxErrorException"}, {4247, "SQLSyntaxErrorException"}, {4248, "SQLSyntaxErrorException"}, {4249, "SQLSyntaxErrorException"}, {4250, "SQLSyntaxErrorException"}, {4251, "SQLSyntaxErrorException"}, {4252, "SQLDataException"}, {4253, "SQLSyntaxErrorException"}, {4254, "SQLSyntaxErrorException"}, {4255, "SQLSyntaxErrorException"}, {4256, "SQLSyntaxErrorException"}, {4257, "SQLSyntaxErrorException"}, {4258, "SQLSyntaxErrorException"}, {4259, "SQLSyntaxErrorException"}, {4260, "SQLSyntaxErrorException"}, {4261, "SQLSyntaxErrorException"}, {4262, "SQLSyntaxErrorException"}, {4263, "SQLSyntaxErrorException"}, {4264, "SQLSyntaxErrorException"}, {4265, "SQLSyntaxErrorException"}, {4266, "SQLSyntaxErrorException"}, {4267, "SQLSyntaxErrorException"}, {4268, "SQLSyntaxErrorException"}, {4269, "SQLSyntaxErrorException"}, {4270, "SQLSyntaxErrorException"}, {4271, "SQLSyntaxErrorException"}, {4272, "SQLSyntaxErrorException"}, {4273, "SQLSyntaxErrorException"}, {4274, "SQLSyntaxErrorException"}, {4275, "SQLSyntaxErrorException"}, {4276, "SQLSyntaxErrorException"}, {4277, "SQLSyntaxErrorException"}, {4278, "SQLSyntaxErrorException"}, {4279, "SQLSyntaxErrorException"}, {4280, "SQLSyntaxErrorException"}, {4281, "SQLSyntaxErrorException"}, {4282, "SQLSyntaxErrorException"}, {4283, "SQLSyntaxErrorException"}, {4284, "SQLSyntaxErrorException"}, {4285, "SQLSyntaxErrorException"}, {4286, "SQLSyntaxErrorException"}, {4287, "SQLSyntaxErrorException"}, {4296, "SQLSyntaxErrorException"}, {4298, "SQLSyntaxErrorException"}, {4299, "SQLSyntaxErrorException"}, {4301, "SQLSyntaxErrorException"}, {4302, "SQLSyntaxErrorException"}, {4303, "SQLSyntaxErrorException"}, {4304, "SQLSyntaxErrorException"}, {4305, "SQLSyntaxErrorException"}, {4307, "SQLSyntaxErrorException"}, {4308, "SQLSyntaxErrorException"}, {4309, "SQLSyntaxErrorException"}, {4310, "SQLSyntaxErrorException"}, {4311, "SQLSyntaxErrorException"}, {4312, "SQLSyntaxErrorException"}, {4313, "SQLSyntaxErrorException"}, {4314, "SQLSyntaxErrorException"}, {4315, "SQLSyntaxErrorException"}, {4316, "SQLSyntaxErrorException"}, {4317, "SQLSyntaxErrorException"}, {4318, "SQLSyntaxErrorException"}, {4319, "SQLSyntaxErrorException"}, {4320, "SQLSyntaxErrorException"}, {4321, "SQLSyntaxErrorException"}, {4322, "SQLSyntaxErrorException"}, {4323, "SQLSyntaxErrorException"}, {4324, "SQLSyntaxErrorException"}, {4325, "SQLSyntaxErrorException"}, {4327, "SQLSyntaxErrorException"}, {4328, "SQLSyntaxErrorException"}, {4329, "SQLSyntaxErrorException"}, {4330, "SQLSyntaxErrorException"}, {4331, "SQLSyntaxErrorException"}, {4332, "SQLSyntaxErrorException"}, {4333, "SQLSyntaxErrorException"}, {4334, "SQLSyntaxErrorException"}, {4335, "SQLSyntaxErrorException"}, {4336, "SQLSyntaxErrorException"}, {4337, "SQLSyntaxErrorException"}, {4340, "SQLSyntaxErrorException"}, {4341, "SQLSyntaxErrorException"}, {4342, "SQLSyntaxErrorException"}, {4343, "SQLSyntaxErrorException"}, {4344, "SQLFeatureNotSupportedException"}, {4345, "SQLFeatureNotSupportedException"}, {4346, "SQLSyntaxErrorException"}, {4347, "SQLSyntaxErrorException"}, {4348, "SQLSyntaxErrorException"}, {4350, "SQLSyntaxErrorException"}, {4351, "SQLSyntaxErrorException"}, {4352, "SQLSyntaxErrorException"}, {4353, "SQLSyntaxErrorException"}, {4354, "SQLSyntaxErrorException"}, {4355, "SQLSyntaxErrorException"}, {4356, "SQLSyntaxErrorException"}, {4357, "SQLSyntaxErrorException"}, {4358, "SQLSyntaxErrorException"}, {4359, "SQLSyntaxErrorException"}, {4360, "SQLSyntaxErrorException"}, {4361, "SQLSyntaxErrorException"}, {4362, "SQLSyntaxErrorException"}, {4363, "SQLSyntaxErrorException"}, {4364, "SQLSyntaxErrorException"}, {4365, "SQLSyntaxErrorException"}, {4366, "SQLSyntaxErrorException"}, {4367, "SQLSyntaxErrorException"}, {4368, "SQLSyntaxErrorException"}, {4371, "SQLSyntaxErrorException"}, {4372, "SQLSyntaxErrorException"}, {4373, "SQLSyntaxErrorException"}, {4374, "SQLSyntaxErrorException"}, {4375, "SQLSyntaxErrorException"}, {4376, "SQLSyntaxErrorException"}, {4377, "SQLSyntaxErrorException"}, {4378, "SQLSyntaxErrorException"}, {4379, "SQLSyntaxErrorException"}, {4380, "SQLSyntaxErrorException"}, {4381, "SQLSyntaxErrorException"}, {4382, "SQLSyntaxErrorException"}, {4383, "SQLSyntaxErrorException"}, {4384, "SQLSyntaxErrorException"}, {4385, "SQLSyntaxErrorException"}, {4401, "SQLDataException"}, {4403, "SQLSyntaxErrorException"}, {4412, "SQLDataException"}, {4422, "SQLSyntaxErrorException"}, {4423, "SQLDataException"}, {4424, "SQLDataException"}, {4425, "SQLDataException"}, {4426, "SQLDataException"}, {4428, "SQLSyntaxErrorException"}, {4429, "SQLSyntaxErrorException"}, {4431, "SQLSyntaxErrorException"}, {4433, "SQLSyntaxErrorException"}, {4435, "SQLDataException"}, {4440, "SQLSyntaxErrorException"}, {4471, "SQLDataException"}, {4472, "SQLDataException"}, {4473, "SQLDataException"}, {4474, "SQLDataException"}, {4475, "SQLDataException"}, {4476, "SQLDataException"}, {4477, "SQLDataException"}, {4478, "SQLSyntaxErrorException"}, {4479, "SQLSyntaxErrorException"}, {4480, "SQLSyntaxErrorException"}, {4481, "SQLSyntaxErrorException"}, {4482, "SQLSyntaxErrorException"}, {4483, "SQLDataException"}, {4484, "SQLSyntaxErrorException"}, {4485, "SQLDataException"}, {4486, "SQLSyntaxErrorException"}, {4487, "SQLSyntaxErrorException"}, {4488, "SQLDataException"}, {4489, "SQLSyntaxErrorException"}, {4490, "SQLSyntaxErrorException"}, {4491, "SQLDataException"}, {4492, "SQLDataException"}, {4493, "SQLSyntaxErrorException"}, {4494, "SQLDataException"}, {4505, "SQLDataException"}, {4508, "SQLSyntaxErrorException"}, {4509, "SQLSyntaxErrorException"}, {4510, "SQLSyntaxErrorException"}, {4515, "SQLSyntaxErrorException"}, {4517, "SQLSyntaxErrorException"}, {4801, "SQLSyntaxErrorException"}, {4802, "SQLSyntaxErrorException"}, {4803, "SQLSyntaxErrorException"}, {4804, "SQLSyntaxErrorException"}, {5201, "SQLSyntaxErrorException"}, {5202, "SQLSyntaxErrorException"}, {5203, "SQLSyntaxErrorException"}, {5204, "SQLSyntaxErrorException"}, {5205, "SQLDataException"}, {5206, "SQLDataException"}, {5207, "SQLDataException"}, {5208, "SQLSyntaxErrorException"}, {5209, "SQLSyntaxErrorException"}, {5211, "SQLSyntaxErrorException"}, {5213, "SQLDataException"}, {5217, "SQLDataException"}, {5218, "SQLSyntaxErrorException"}, {5219, "SQLSyntaxErrorException"}, {5220, "SQLRecoverableException"}, {5221, "SQLSyntaxErrorException"}, {5222, "SQLSyntaxErrorException"}, {5223, "SQLSyntaxErrorException"}, {5224, "SQLSyntaxErrorException"}, {5225, "SQLSyntaxErrorException"}, {5226, "SQLSyntaxErrorException"}, {5227, "SQLSyntaxErrorException"}, {5228, "SQLSyntaxErrorException"}, {5229, "SQLSyntaxErrorException"}, {5230, "SQLSyntaxErrorException"}, {5231, "SQLSyntaxErrorException"}, {5232, "SQLSyntaxErrorException"}, {5233, "SQLSyntaxErrorException"}, {5234, "SQLSyntaxErrorException"}, {5235, "SQLSyntaxErrorException"}, {5236, "SQLDataException"}, {5237, "SQLSyntaxErrorException"}, {5239, "SQLSyntaxErrorException"}, {5241, "SQLSyntaxErrorException"}, {5242, "SQLSyntaxErrorException"}, {5243, "SQLSyntaxErrorException"}, {5245, "SQLSyntaxErrorException"}, {5246, "SQLSyntaxErrorException"}, {5247, "SQLSyntaxErrorException"}, {5248, "SQLSyntaxErrorException"}, {5249, "SQLSyntaxErrorException"}, {5250, "SQLSyntaxErrorException"}, {5252, "SQLSyntaxErrorException"}, {5253, "SQLSyntaxErrorException"}, {5254, "SQLSyntaxErrorException"}, {5255, "SQLSyntaxErrorException"}, {5256, "SQLSyntaxErrorException"}, {5257, "SQLSyntaxErrorException"}, {5258, "SQLSyntaxErrorException"}, {5259, "SQLSyntaxErrorException"}, {5260, "SQLSyntaxErrorException"}, {5261, "SQLSyntaxErrorException"}, {5262, "SQLSyntaxErrorException"}, {5263, "SQLSyntaxErrorException"}, {5264, "SQLSyntaxErrorException"}, {5265, "SQLSyntaxErrorException"}, {5266, "SQLSyntaxErrorException"}, {5267, "SQLSyntaxErrorException"}, {5268, "SQLSyntaxErrorException"}, {5270, "SQLSyntaxErrorException"}, {5271, "SQLSyntaxErrorException"}, {5272, "SQLSyntaxErrorException"}, {5273, "SQLSyntaxErrorException"}, {5274, "SQLSyntaxErrorException"}, {5275, "SQLSyntaxErrorException"}, {5276, "SQLSyntaxErrorException"}, {5277, "SQLSyntaxErrorException"}, {5278, "SQLSyntaxErrorException"}, {5279, "SQLSyntaxErrorException"}, {5280, "SQLSyntaxErrorException"}, {5281, "SQLSyntaxErrorException"}, {5282, "SQLSyntaxErrorException"}, {5283, "SQLSyntaxErrorException"}, {5284, "SQLSyntaxErrorException"}, {5285, "SQLSyntaxErrorException"}, {5286, "SQLSyntaxErrorException"}, {5287, "SQLSyntaxErrorException"}, {5288, "SQLSyntaxErrorException"}, {5289, "SQLSyntaxErrorException"}, {5290, "SQLSyntaxErrorException"}, {5291, "SQLSyntaxErrorException"}, {5292, "SQLSyntaxErrorException"}, {5295, "SQLSyntaxErrorException"}, {5299, "SQLDataException"}, {5302, "SQLSyntaxErrorException"}, {5306, "SQLSyntaxErrorException"}, {5309, "SQLSyntaxErrorException"}, {5311, "SQLSyntaxErrorException"}, {5312, "SQLSyntaxErrorException"}, {5314, "SQLSyntaxErrorException"}, {5315, "SQLSyntaxErrorException"}, {5316, "SQLSyntaxErrorException"}, {5317, "SQLSyntaxErrorException"}, {6001, "SQLDataException"}, {6012, "SQLRecoverableException"}, {6014, "SQLDataException"}, {6015, "SQLDataException"}, {6024, "SQLDataException"}, {6203, "SQLRecoverableException"}, {6206, "SQLRecoverableException"}, {6211, "SQLDataException"}, {6319, "SQLRecoverableException"}, {6320, "SQLRecoverableException"}, {6501, "SQLDataException"}, {6502, "SQLDataException"}, {6504, "SQLDataException"}, {6507, "SQLDataException"}).collect(Collectors.collectingAndThen(Collectors.toMap(data -> (Integer)data[0], data -> (String)data[1]), Collections::unmodifiableMap));
    }
}

