/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ServerErrorMessage
implements Serializable {
    protected int errCode;
    private int line;
    private int column;
    protected String msg;

    public ServerErrorMessage(int errCode, int line, int column, String msg) {
        this.errCode = errCode;
        this.line = line;
        this.column = column;
        this.msg = msg;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getSQLState() {
        return Integer.toString(this.errCode);
    }

    public String getNonSensitiveErrorMessage() {
        return null;
    }

    public String getMessage() {
        return this.msg;
    }

    public List<Integer> getOtherErrorCode() {
        String[] msgs;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String m : msgs = this.msg.split("\n")) {
            if (m == null || m.trim().length() == 0 || !m.contains("YAS-")) continue;
            try {
                int index = m.indexOf("YAS-");
                list.add(Integer.parseInt(m.substring(index + 4, index + 9)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public String toString() {
        return "[line: " + this.line + " column: " + this.column + "] YAS-" + String.format("%05d", this.errCode) + " " + this.msg;
    }
}

