/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.failover;

import com.yashandb.Session;
import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasFailover;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.util.ConnectorFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Utils;
import java.sql.SQLException;
import java.util.Properties;

public class YasFailoverProcessor {
    private final int failoverType;
    private final String failoverMethod;
    private final int failoverRetries;
    private final int failoverDelay;
    private static final int FO_EVENT_BEGIN = 1;
    private static final int FO_EVENT_END = 2;
    private static final int FO_EVENT_ABORT = 3;
    private static final int FO_EVENT_REAUTH = 4;
    private static final int FO_EVENT_ERROR = 5;
    private static final int FO_EVENT_RETRY = 6;
    private static final int FO_EVENT_UNKNOWN = 7;
    private static final String YAS_FO_TYPE_SESSION = "session";
    private static final String YAS_FO_TYPE_SELECT = "select";
    private HostSpec[] hostSpecs;
    private YasFailover appCallback = null;
    private Object appCallbackObject = null;
    private boolean needReTry = false;
    private YasLinkInfo preConnectLinkInfo = null;
    private SessionImpl session;
    private Properties info;

    public YasFailoverProcessor(Session session, Properties info, HostSpec[] hostSpecs) throws SQLException {
        this.failoverType = this.getFailoverType(YasProperty.FAILOVER_TYPE.get(info));
        this.failoverMethod = YasProperty.FAILOVER_METHOD.get(info);
        this.failoverRetries = YasProperty.FAILOVER_RETRIES.getInt(info);
        this.failoverDelay = YasProperty.FAILOVER_DELAY.getInt(info);
        this.session = (SessionImpl)session;
        this.hostSpecs = hostSpecs;
        this.info = info;
        this.checkParams();
    }

    private int getFailoverType(String type) {
        if (type == null) {
            return 3;
        }
        if (type.equalsIgnoreCase(YAS_FO_TYPE_SESSION)) {
            return 1;
        }
        if (type.equalsIgnoreCase(YAS_FO_TYPE_SELECT)) {
            return 2;
        }
        return 4;
    }

    private void checkParams() throws SQLException {
        if (this.failoverType != 1) {
            throw SQLError.createSQLException("failoverType only support session", YasState.DATA_ERROR);
        }
        if (!this.failoverMethod.equalsIgnoreCase("basic")) {
            throw SQLError.createSQLException("failoverMethod only support basic", YasState.DATA_ERROR);
        }
    }

    public void registerTAFCallback(YasFailover appCallback, Object appCallbackObject) {
        this.appCallback = appCallback;
        this.appCallbackObject = appCallbackObject;
    }

    private int callTAFCallbackMethod(int type, int event) {
        int result = 0;
        if (this.appCallback != null) {
            result = this.appCallback.callbackFn(this.session.getConnection(), this.appCallbackObject, type, event);
        }
        return result;
    }

    private void doBasicFailOver() throws SQLException {
        YasLinkInfo linkInfo = this.failoverConnect();
        if (linkInfo == null) {
            throw SQLError.createSQLException("failover reconnect fail", YasState.IO_ERROR);
        }
        this.session.refreshAfterFailover(linkInfo);
    }

    private SQLException tyrToFailOver(SQLException exception) {
        this.needReTry = false;
        try {
            if (this.preConnectLinkInfo == null) {
                this.doBasicFailOver();
            }
            try {
                this.callTAFCallbackMethod(this.failoverType, 2);
            }
            catch (Throwable t) {
                exception = SQLError.createSQLException(t.getMessage(), YasState.UNEXPECTED_ERROR);
            }
        }
        catch (SQLException e) {
            exception = e;
            try {
                int errorResult = this.callTAFCallbackMethod(this.failoverType, 5);
                if (errorResult == 6) {
                    this.needReTry = true;
                }
            }
            catch (Throwable t) {
                exception = SQLError.createSQLException(t.getMessage(), YasState.UNEXPECTED_ERROR);
            }
        }
        return exception;
    }

    public void doTransparentAppFailover() throws SQLException {
        SQLException exception = null;
        try {
            this.callTAFCallbackMethod(this.failoverType, 1);
        }
        catch (Throwable t) {
            exception = SQLError.createSQLException(t.getMessage(), YasState.UNEXPECTED_ERROR);
        }
        do {
            SQLException e = this.tyrToFailOver(exception);
            if (this.needReTry) continue;
            exception = e;
        } while (this.needReTry);
        if (exception != null) {
            throw exception;
        }
    }

    private YasLinkInfo failoverConnect() {
        if (this.appCallback != null) {
            return this.connect();
        }
        for (int i = 0; i < this.failoverRetries; ++i) {
            YasLinkInfo yasLinkInfo = this.connect();
            if (yasLinkInfo != null) {
                return yasLinkInfo;
            }
            try {
                Thread.sleep(Utils.toMillisecond(this.failoverDelay));
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public YasLinkInfo connect() {
        String serverType = this.session.getConnection().getServerType();
        try {
            HostConnector connector = ConnectorFactory.generateConnector(this.session, this.hostSpecs, serverType);
            connector.checkConfigurations(this.info);
            return connector.failoverConnect(this.session.getUser(), this.info);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int getFailoverType() {
        return this.failoverType;
    }
}

