/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.pool;

import com.yashandb.jdbc.pool.CallableStatementWrapper;
import com.yashandb.jdbc.pool.PreparedStatementWrapper;
import com.yashandb.jdbc.pool.StatementWrapper;
import com.yashandb.jdbc.pool.YasPooledConnection;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ConnectionWrapper
implements Connection {
    protected Connection physicalConn = null;
    protected YasPooledConnection pooledConnection;
    private boolean closed;
    private boolean isXa;

    protected static ConnectionWrapper getInstance(YasPooledConnection pooledConnection, Connection connection, boolean isXa) throws SQLException {
        return new ConnectionWrapper(pooledConnection, connection, isXa);
    }

    public ConnectionWrapper(YasPooledConnection pooledConnection, Connection connection, boolean isXa) throws SQLException {
        this.physicalConn = connection;
        this.pooledConnection = pooledConnection;
        this.closed = false;
        this.isXa = isXa;
    }

    protected void checkConnectionError(SQLException sqlEx) throws SQLException {
        if (this.pooledConnection != null) {
            this.pooledConnection.callConnectionEventListeners(1, sqlEx);
        }
        throw sqlEx;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.getAutoCommit();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return false;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.setCatalog(catalog);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.getCatalog();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed || this.physicalConn.isClosed();
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.setHoldability(arg0);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.getHoldability();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return 1;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.getMetaData();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.setReadOnly(readOnly);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.isReadOnly();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return false;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.setSavepoint();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.setSavepoint(arg0);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.setTransactionIsolation(level);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.getTransactionIsolation();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return 4;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.getTypeMap();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.physicalConn.setTypeMap(map);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.physicalConn.getWarnings();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.clearWarnings();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.commit();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.checkConnection();
            return StatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.createStatement());
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkConnection();
            return StatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkConnection();
            return StatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.nativeSQL(sql);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            this.checkConnection();
            return CallableStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareCall(sql));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkConnection();
            return CallableStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkConnection();
            return CallableStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Object res = null;
        try {
            this.checkConnection();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(sql));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkConnection();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkConnection();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        try {
            this.checkConnection();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(sql, resultSetType));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.checkConnection();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(sql, columnIndexes));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            this.checkConnection();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(sql, columnNames));
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.releaseSavepoint(savepoint);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.rollback();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.rollback(savepoint);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.close(true);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean fireClosedEvent) throws SQLException {
        YasPooledConnection yasPooledConnection = this.pooledConnection;
        synchronized (yasPooledConnection) {
            if (this.closed) {
                return;
            }
            if (fireClosedEvent) {
                this.pooledConnection.callConnectionEventListeners(2, null);
            }
            this.closed = true;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkConnection();
        this.physicalConn.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkConnection();
        return this.physicalConn.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.abort(executor);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.checkConnection();
            this.physicalConn.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.getNetworkTimeout();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return 0;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.createClob();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.createBlob();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.createNClob();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.createSQLXML();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.isValid(timeout);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkConnection();
            this.physicalConn.setClientInfo(name, value);
        }
        catch (SQLException sqlException) {
            try {
                this.checkConnectionError(sqlException);
            }
            catch (SQLException sqlEx2) {
                SQLClientInfoException clientEx = new SQLClientInfoException();
                clientEx.initCause(sqlEx2);
                throw clientEx;
            }
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkConnection();
            this.physicalConn.setClientInfo(properties);
        }
        catch (SQLException sqlException) {
            try {
                this.checkConnectionError(sqlException);
            }
            catch (SQLException sqlEx2) {
                SQLClientInfoException clientEx = new SQLClientInfoException();
                clientEx.initCause(sqlEx2);
                throw clientEx;
            }
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.physicalConn.getClientInfo(name);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.physicalConn.getClientInfo();
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.createArrayOf(typeName, elements);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.createStruct(typeName, attributes);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            this.checkConnection();
            return this.physicalConn.unwrap(iface);
        }
        catch (SQLException sqlException) {
            this.checkConnectionError(sqlException);
            return null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean isInstance = iface.isInstance(this);
        if (isInstance) {
            return true;
        }
        return iface.getName().equals("com.yashandb.jdbc.YasConnection") || iface.getName().equals(Connection.class.getName()) || iface.getName().equals(AutoCloseable.class.getName());
    }

    private void checkConnection() throws SQLException {
        if (this.physicalConn == null || this.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
    }
}

