/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.pool;

import com.yashandb.jdbc.pool.ConnectionWrapper;
import com.yashandb.jdbc.pool.YasPooledConnection;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementWrapper
implements Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementWrapper.class);
    protected Statement wrappedStmt;
    protected ConnectionWrapper wrappedConn;
    protected YasPooledConnection pooledConnection;
    protected SQLException sqlException = new SQLException("Statement.AlreadyClosed");

    protected static StatementWrapper getInstance(ConnectionWrapper c, YasPooledConnection conn, Statement toWrap) throws SQLException {
        return new StatementWrapper(c, conn, toWrap);
    }

    public StatementWrapper(ConnectionWrapper c, YasPooledConnection conn, Statement toWrap) {
        this.pooledConnection = conn;
        this.wrappedStmt = toWrap;
        this.wrappedConn = c;
    }

    protected void checkErrorEvent(SQLException sqlEx) throws SQLException {
        LOGGER.warn("checkErrorEvent:" + sqlEx.getMessage());
        if (this.pooledConnection != null) {
            this.pooledConnection.callConnectionEventListeners(1, sqlEx);
        }
        throw sqlEx;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedConn;
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return null;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setCursorName(name);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setEscapeProcessing(enable);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setFetchDirection(direction);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getFetchDirection();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 1000;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setFetchSize(rows);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getFetchSize();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 0;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getGeneratedKeys();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return null;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setMaxFieldSize(max);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getMaxFieldSize();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 0;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setMaxRows(max);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getMaxRows();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getMoreResults();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getMoreResults(current);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setQueryTimeout(seconds);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getQueryTimeout();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 0;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                ResultSet rs = this.wrappedStmt.getResultSet();
                return rs;
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return null;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getResultSetConcurrency();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 0;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getResultSetHoldability();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 1;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getResultSetType();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 1003;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getUpdateCount();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getWarnings();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return null;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.addBatch(sql);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.cancel();
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.clearBatch();
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.clearWarnings();
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public void close() throws SQLException {
        block6: {
            try {
                if (this.wrappedStmt != null) {
                    this.wrappedStmt.close();
                    break block6;
                }
                throw this.sqlException;
            }
            catch (SQLException sqlEx) {
                this.checkErrorEvent(sqlEx);
            }
            finally {
                this.wrappedStmt = null;
            }
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.execute(sql, autoGeneratedKeys);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.execute(sql, columnIndexes);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.execute(sql, columnNames);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.execute(sql);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeBatch();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return null;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs = null;
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            rs = this.wrappedStmt.executeQuery(sql);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
        return rs;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeUpdate(sql, autoGeneratedKeys);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeUpdate(sql, columnIndexes);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeUpdate(sql, columnNames);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeUpdate(sql);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1;
        }
    }

    @Override
    public synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if ("java.sql.Statement".equals(iface.getName()) || "java.sql.Wrapper.class".equals(iface.getName())) {
                return iface.cast(this);
            }
            throw new SQLException("Common.UnableToUnwrap");
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean isInstance = iface.isInstance(this);
        if (isInstance) {
            return true;
        }
        String interfaceClassName = iface.getName();
        return interfaceClassName.equals("com.mysql.cj.jdbc.Statement") || interfaceClassName.equals("java.sql.Statement") || interfaceClassName.equals("java.sql.Wrapper");
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.isClosed();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setPoolable(poolable);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.isPoolable();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.closeOnCompletion();
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.isCloseOnCompletion();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return false;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeLargeBatch();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return null;
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeLargeUpdate(sql);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeLargeUpdate(sql, autoGeneratedKeys);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeLargeUpdate(sql, columnIndexes);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.executeLargeUpdate(sql, columnNames);
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1L;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getLargeMaxRows();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return 0L;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.getLargeUpdateCount();
            }
            throw this.sqlException;
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
            return -1L;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw this.sqlException;
            }
            this.wrappedStmt.setLargeMaxRows(max);
        }
        catch (SQLException sqlEx) {
            this.checkErrorEvent(sqlEx);
        }
    }
}

