/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.pool;

import com.yashandb.jdbc.pool.ConnectionWrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class YasPooledConnection
implements PooledConnection,
Serializable {
    public static final int CONNECTION_ERROR_EVENT = 1;
    public static final int CONNECTION_CLOSED_EVENT = 2;
    public static final int STATEMENT_ERROR_EVENT = 3;
    public static final int STATEMENT_CLOSED_EVENT = 4;
    private static final long serialVersionUID = 6677891687109972348L;
    protected transient Connection logicalHandle = null;
    protected transient Connection physicalConn = null;
    private Map<ConnectionEventListener, ConnectionEventListener> connectionEventListeners;
    private Map<StatementEventListener, StatementEventListener> statementEventListeners;

    protected static YasPooledConnection getInstance(Connection connection) throws SQLException {
        return new YasPooledConnection(connection);
    }

    public YasPooledConnection(Connection connection) {
        this.physicalConn = connection;
        this.connectionEventListeners = new HashMap<ConnectionEventListener, ConnectionEventListener>();
        this.statementEventListeners = new HashMap<StatementEventListener, StatementEventListener>();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(false);
    }

    protected synchronized Connection getConnection(boolean isXa) throws SQLException {
        if (this.physicalConn == null) {
            SQLException sqlException = new SQLException("Physical Connection doesn't exist");
            this.callConnectionEventListeners(1, sqlException);
            throw sqlException;
        }
        try {
            if (this.logicalHandle != null) {
                this.logicalHandle.close();
            }
            this.logicalHandle = ConnectionWrapper.getInstance(this, this.physicalConn, isXa);
        }
        catch (SQLException sqlException) {
            this.callConnectionEventListeners(1, sqlException);
            throw sqlException;
        }
        return this.logicalHandle;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.close();
            this.physicalConn = null;
        }
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.clear();
            this.connectionEventListeners = null;
        }
        if (this.statementEventListeners != null) {
            this.statementEventListeners.clear();
            this.statementEventListeners = null;
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.put(listener, listener);
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.remove(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.statementEventListeners != null) {
            this.statementEventListeners.put(listener, listener);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (this.statementEventListeners != null) {
            this.statementEventListeners.remove(listener);
        }
    }

    protected synchronized void callConnectionEventListeners(int eventType, SQLException sqlException) {
        if (this.connectionEventListeners == null) {
            return;
        }
        Iterator<Map.Entry<ConnectionEventListener, ConnectionEventListener>> iterator = this.connectionEventListeners.entrySet().iterator();
        ConnectionEvent connectionevent = new ConnectionEvent(this, sqlException);
        while (iterator.hasNext()) {
            ConnectionEventListener connectioneventlistener = iterator.next().getValue();
            if (eventType == 2) {
                connectioneventlistener.connectionClosed(connectionevent);
                continue;
            }
            if (eventType != 1) continue;
            connectioneventlistener.connectionErrorOccurred(connectionevent);
        }
    }

    protected synchronized void callStatementEventListeners(int eventType, PreparedStatement pstmt, SQLException sqlException) {
        if (this.statementEventListeners == null) {
            return;
        }
        Iterator<Map.Entry<StatementEventListener, StatementEventListener>> iterator = this.statementEventListeners.entrySet().iterator();
        StatementEvent statementEvent = new StatementEvent(this, pstmt, sqlException);
        while (iterator.hasNext()) {
            StatementEventListener statementEventListener = iterator.next().getValue();
            if (eventType == 4) {
                statementEventListener.statementClosed(statementEvent);
                continue;
            }
            if (eventType != 3) continue;
            statementEventListener.statementErrorOccurred(statementEvent);
        }
    }
}

