/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.log;

import com.yashandb.log.Logger;
import com.yashandb.log.LoggerHelper;
import java.util.logging.Level;

public class JDKLoggerAdapter
implements Logger {
    java.util.logging.Logger logger;

    protected JDKLoggerAdapter(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void trace(String msg) {
        this.logger.log(Level.FINEST, msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.logger.log(Level.FINEST, LoggerHelper.format(format, arg));
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logger.log(Level.FINEST, LoggerHelper.arrayFormat(format, arguments));
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.log(Level.FINEST, msg, t);
    }

    @Override
    public void debug(String msg) {
        this.logger.log(Level.FINE, msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.logger.log(Level.FINE, LoggerHelper.format(format, arg));
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logger.log(Level.FINE, LoggerHelper.arrayFormat(format, arguments));
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.log(Level.FINE, msg, t);
    }

    @Override
    public void info(String msg) {
        this.logger.log(Level.INFO, msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.logger.log(Level.INFO, LoggerHelper.format(format, arg));
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logger.log(Level.INFO, LoggerHelper.arrayFormat(format, arguments));
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.log(Level.INFO, msg, t);
    }

    @Override
    public void warn(String msg) {
        this.logger.log(Level.WARNING, msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.logger.log(Level.WARNING, LoggerHelper.format(format, arg));
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logger.log(Level.WARNING, LoggerHelper.arrayFormat(format, arguments));
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.log(Level.WARNING, msg, t);
    }

    @Override
    public void error(String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.logger.log(Level.SEVERE, LoggerHelper.format(format, arg));
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logger.log(Level.SEVERE, LoggerHelper.arrayFormat(format, arguments));
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }
}

