/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerHelper {
    static final char DELIM_START = '{';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    public static String format(String messagePattern, Object arg) {
        return LoggerHelper.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static String arrayFormat(String messagePattern, Object[] argArray) {
        if (messagePattern == null) {
            return null;
        }
        if (argArray == null) {
            return messagePattern;
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (int l = 0; l < argArray.length; ++l) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern, i, messagePattern.length());
                return sbuf.toString();
            }
            if (LoggerHelper.isEscapedDelimeter(messagePattern, j)) {
                if (!LoggerHelper.isDoubleEscaped(messagePattern, j)) {
                    --l;
                    sbuf.append(messagePattern, i, j - 1);
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern, i, j - 1);
                LoggerHelper.deeplyAppendParameter(sbuf, argArray[l], new HashMap<Object[], Object>());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern, i, j);
            LoggerHelper.deeplyAppendParameter(sbuf, argArray[l], new HashMap<Object[], Object>());
            i = j + 2;
        }
        sbuf.append(messagePattern, i, messagePattern.length());
        return sbuf.toString();
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a)) {
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                LoggerHelper.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map<Object[], Object> seenMap) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            LoggerHelper.safeObjectAppend(sbuf, o);
        } else if (o instanceof boolean[]) {
            LoggerHelper.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            LoggerHelper.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            LoggerHelper.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            LoggerHelper.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            LoggerHelper.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            LoggerHelper.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            LoggerHelper.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            LoggerHelper.doubleArrayAppend(sbuf, (double[])o);
        } else {
            LoggerHelper.objectArrayAppend(sbuf, (Object[])o, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = String.valueOf(o);
            sbuf.append(oAsString);
        }
        catch (Throwable t) {
            sbuf.append("Logger: Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    static void setHandler(Logger logger) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        consoleHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                String dateFormat = sdf.format(record.getMillis());
                String levelName = record.getLevel().getName();
                String className = record.getLoggerName();
                String message = this.formatMessage(record);
                String methodName = "";
                String throwable = "";
                try {
                    if (record.getThrown() != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        pw.println();
                        record.getThrown().printStackTrace(pw);
                        pw.close();
                        throwable = sw.toString();
                    }
                }
                catch (Exception e) {
                    throwable = e.getMessage();
                }
                StringBuilder sb = new StringBuilder();
                sb = sb.append(dateFormat).append(" ").append(levelName).append(" - ").append(methodName).append(" ").append(message).append(" ").append(throwable).append(" [").append(className).append("]").append("\n");
                return String.format("%-8s", sb.toString());
            }
        });
        logger.setUseParentHandlers(false);
        logger.addHandler(consoleHandler);
    }
}

