/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.Packet;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberParameter
extends YasParameter {
    private static final int MAX_NUMBER_LEN = 18;

    public NumberParameter() {
        this.type = 12;
    }

    @Override
    public void setValue(Object obj) {
        if (!(obj instanceof BigDecimal)) {
            this.value = obj;
            return;
        }
        BigDecimal num = (BigDecimal)obj;
        num = ByteConverter.adjustNumber(num);
        this.value = num;
    }

    @Override
    public int processWrite(Packet packet) throws SQLException {
        BigDecimal num = (BigDecimal)this.value;
        byte[] numberData = new byte[18];
        int dataLen = ByteConverter.bigDecimalToBytes(numberData, 0, num);
        packet.writeByte((byte)dataLen);
        packet.writeBytes(numberData, 0, dataLen);
        ByteConverter.toBigDecimal(numberData, 0);
        return dataLen;
    }

    @Override
    public int getParamLength() throws SQLException {
        BigDecimal num = (BigDecimal)this.value;
        byte[] n = new byte[18];
        return ByteConverter.bigDecimalToBytes(n, 0, num) + 1;
    }
}

