/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.parameter.BigIntParameter;
import com.yashandb.parameter.BitParameter;
import com.yashandb.parameter.BlobParameter;
import com.yashandb.parameter.BooleanParameter;
import com.yashandb.parameter.ClobParameter;
import com.yashandb.parameter.DateParameter;
import com.yashandb.parameter.DoubleParameter;
import com.yashandb.parameter.DsIntervalParameter;
import com.yashandb.parameter.FloatParameter;
import com.yashandb.parameter.IntegerParameter;
import com.yashandb.parameter.NumberParameter;
import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.RawParameter;
import com.yashandb.parameter.RowIdParameter;
import com.yashandb.parameter.SmallIntParameter;
import com.yashandb.parameter.TimeParameter;
import com.yashandb.parameter.TimeStampParameter;
import com.yashandb.parameter.TinyIntParameter;
import com.yashandb.parameter.VarcharParameter;
import com.yashandb.parameter.YasParameter;
import com.yashandb.parameter.YmIntervalParameter;
import java.sql.SQLException;

public class ParameterLittleEndianFactory
extends ParameterFactory {
    @Override
    public YasParameter getParameter(int type) throws SQLException {
        YasParameter parameter;
        switch (type) {
            case 1: {
                parameter = new BooleanParameter();
                break;
            }
            case 31: {
                parameter = new BitParameter();
                break;
            }
            case 2: {
                parameter = new TinyIntParameter();
                break;
            }
            case 3: {
                parameter = new SmallIntParameter();
                break;
            }
            case 4: {
                parameter = new IntegerParameter();
                break;
            }
            case 5: {
                parameter = new BigIntParameter();
                break;
            }
            case 0: 
            case 24: 
            case 26: 
            case 35: {
                parameter = new VarcharParameter();
                break;
            }
            case 25: 
            case 27: {
                parameter = new VarcharParameter();
                parameter.setType(27);
                break;
            }
            case 11: {
                parameter = new DoubleParameter();
                break;
            }
            case 10: {
                parameter = new FloatParameter();
                break;
            }
            case 12: {
                parameter = new NumberParameter();
                break;
            }
            case 13: {
                parameter = new DateParameter();
                break;
            }
            case 16: {
                parameter = new TimeStampParameter();
                break;
            }
            case 15: {
                parameter = new TimeParameter();
                break;
            }
            case 20: {
                parameter = new DsIntervalParameter();
                break;
            }
            case 19: {
                parameter = new YmIntervalParameter();
                break;
            }
            case 32: {
                parameter = new RowIdParameter();
                break;
            }
            case 28: {
                parameter = new RawParameter();
                break;
            }
            case 34: {
                parameter = new SmallIntParameter();
                break;
            }
            case 29: 
            case 33: {
                parameter = new ClobParameter();
                break;
            }
            case 30: {
                parameter = new BlobParameter();
                break;
            }
            default: {
                throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), " Bind Type " + DataType.getTypeName(type));
            }
        }
        return parameter;
    }
}

