/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.Packet;
import com.yashandb.util.StreamWrapper;
import java.io.IOException;
import java.sql.SQLException;

public class RawParameter
extends YasParameter {
    private byte[] rawByteBuffer = null;

    public RawParameter() {
        this.type = 28;
    }

    private byte[] getByteBuffer() {
        if (this.rawByteBuffer != null) {
            return this.rawByteBuffer;
        }
        this.rawByteBuffer = new byte[32000];
        return this.rawByteBuffer;
    }

    @Override
    public int processWrite(Packet packet) throws SQLException {
        StreamWrapper streamWrapper = (StreamWrapper)this.value;
        byte[] bytes = streamWrapper.getBytes();
        int byteOffset = streamWrapper.getOffset();
        int dataLen = streamWrapper.getLength();
        dataLen = Math.min(dataLen, 32000);
        if (bytes == null) {
            bytes = this.getByteBuffer();
            byteOffset = 0;
            try {
                dataLen = streamWrapper.getStream().read(bytes, 0, dataLen);
                if (dataLen <= 0) {
                    packet.writeByte((byte)-1);
                    return 1;
                }
            }
            catch (IOException ioException) {
                throw SQLError.createSQLException(ioException.getMessage(), YasState.DATA_ERROR);
            }
        }
        if (bytes.length == 0) {
            packet.writeByte((byte)-1);
            return 1;
        }
        if (dataLen < 253) {
            packet.writeByte((byte)dataLen);
        } else {
            packet.writeByte((byte)-3);
            packet.writeShort((short)dataLen);
        }
        packet.writeBytes(bytes, byteOffset, dataLen);
        return dataLen;
    }

    @Override
    public int getParamLength() {
        StreamWrapper streamWrapper = (StreamWrapper)this.value;
        int dataLen = streamWrapper.getLength();
        if (dataLen < 253) {
            return dataLen + 1;
        }
        return dataLen + 3;
    }
}

